/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AsyncUpdateAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.ActionContext;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class RevertAllUnchangedFilesAction
extends AsyncUpdateAction<ActionContext>
implements DumbAware {
    protected ActionContext prepareDataFromContext(AnActionEvent e) {
        return new ActionContext(VcsContextFactory.SERVICE.getInstance().createCachedContextOn(e), RevertAllUnchangedFilesAction.getSelectedFiles(e));
    }

    protected void performUpdate(Presentation presentation, ActionContext context) {
        Project project = context.context.getProject();
        if (project == null) {
            presentation.setVisible(false);
            return;
        }
        presentation.setVisible(RevertAllUnchangedFilesAction.hasFilesUnderPerforce(context.files, project));
        presentation.setEnabled(PerforceSettings.getSettings((Project)project).ENABLED);
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }

    private static Collection<VirtualFile> getSelectedFiles(AnActionEvent e) {
        Object panel = e.getData(Refreshable.PANEL_KEY);
        if (panel instanceof CommitMessageI && panel instanceof CheckinProjectPanel) {
            return ((CheckinProjectPanel)panel).getRoots();
        }
        VirtualFile[] array = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (array != null) {
            return Arrays.asList(array);
        }
        e.getPresentation().setVisible(false);
        return Collections.emptyList();
    }

    private static boolean hasFilesUnderPerforce(Collection<VirtualFile> roots, Project project) {
        return !RevertAllUnchangedFilesAction.findFilesUnderPerforce(roots, project).isEmpty();
    }

    public void actionPerformed(AnActionEvent e) {
        VcsContext context = VcsContextFactory.SERVICE.getInstance().createCachedContextOn(e);
        CheckinProjectPanel panel = (CheckinProjectPanel)e.getData(Refreshable.PANEL_KEY);
        Collection<VirtualFile> roots = RevertAllUnchangedFilesAction.getSelectedFiles(e);
        Project project = context.getProject();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
        RevertAllUnchangedFilesAction.revertUnchanged(project, roots, panel, context.getSelectedChangeLists());
    }

    public static void revertUnchanged(final Project project, final Collection<VirtualFile> roots, @Nullable CheckinProjectPanel panel, final @Nullable ChangeList[] selection) {
        final ArrayList exceptions = new ArrayList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                if (selection != null && selection.length > 0 && RevertAllUnchangedFilesAction.revertChangeLists(project, selection, exceptions)) {
                    return;
                }
                RevertAllUnchangedFilesAction.revertFiles(roots, project, exceptions);
            }
        }, PerforceBundle.message((String)"message.title.revert.unchanged", (Object[])new Object[0]), false, project);
        RevertAllUnchangedFilesAction.refreshAndDirty(project, roots);
        if (panel != null) {
            panel.refresh();
        }
        if (!exceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, PerforceBundle.message((String)"message.title.revert.unchanged.files", (Object[])new Object[0]));
        }
    }

    private static void refreshAndDirty(final Project project, Collection<VirtualFile> roots) {
        VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])roots.toArray(new VirtualFile[roots.size()]));
        if (RevertAllUnchangedFilesAction.hasDirectories(roots)) {
            VirtualFileManager.getInstance().asyncRefresh(new Runnable(){

                @Override
                public void run() {
                    P4File.invalidateFstat(project);
                    VcsDirtyScopeManager.getInstance((Project)project).markEverythingDirty();
                }
            });
        } else {
            for (final VirtualFile vFile : RevertAllUnchangedFilesAction.findFilesUnderPerforce(roots, project)) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        vFile.refresh(false, false);
                    }
                });
                P4File.invalidateFstat(vFile);
                if (vFile.isDirectory()) {
                    VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(vFile);
                    continue;
                }
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(vFile);
            }
        }
    }

    private static boolean hasDirectories(Collection<VirtualFile> roots) {
        return ContainerUtil.find(roots, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return file.isDirectory();
            }
        }) != null;
    }

    private static void revertFiles(Collection<VirtualFile> roots, Project project, List<VcsException> exceptions) {
        List<VirtualFile> files = RevertAllUnchangedFilesAction.findFilesUnderPerforce(roots, project);
        MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(files, project);
        for (P4Connection connection : map.keySet()) {
            try {
                List paths = ContainerUtil.map2List((Collection)map.get((Object)connection), (Function)new Function<VirtualFile, String>(){

                    public String fun(VirtualFile file) {
                        return P4File.create(file).getRecursivePath();
                    }
                });
                PerforceRunner.getInstance(project).revertUnchanged(connection, paths);
            }
            catch (VcsException e1) {
                exceptions.add(e1);
            }
        }
    }

    private static List<VirtualFile> findFilesUnderPerforce(Collection<VirtualFile> roots, Project project) {
        final PerforceVcs vcs = PerforceVcs.getInstance(project);
        final ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        return ContainerUtil.findAll(roots, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return vcsManager.getVcsFor(file) == vcs;
            }
        });
    }

    private static boolean revertChangeLists(Project project, ChangeList[] selectedChangeLists, List<VcsException> exceptions) {
        boolean foundAll = true;
        PerforceNumberNameSynchronizer synchronizer = PerforceNumberNameSynchronizer.getInstance(project);
        Collection<P4Connection> connectionList = PerforceSettings.getSettings(project).getAllConnections();
        HashSet<Pair> numbers = new HashSet<Pair>();
        for (P4Connection connection : connectionList) {
            try {
                PerforceManager.ensureValidClient(project, connection);
            }
            catch (VcsException e) {
                exceptions.add(e);
                continue;
            }
            ConnectionKey connectionKey = connection.getConnectionKey();
            for (ChangeList changeList : selectedChangeLists) {
                Collection<Long> exNumbers = synchronizer.getNumbers(connectionKey, changeList.getName());
                if (exNumbers != null && !exNumbers.isEmpty()) {
                    for (Long exNumber : exNumbers) {
                        numbers.add(Pair.create((Object)exNumber, (Object)connection));
                    }
                    continue;
                }
                foundAll = false;
            }
        }
        for (Pair pair : numbers) {
            try {
                PerforceRunner.getInstance(project).revertUnchanged((P4Connection)pair.getSecond(), (Long)pair.getFirst());
            }
            catch (VcsException e1) {
                exceptions.add(e1);
            }
        }
        return foundAll;
    }
}

