/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.P4HaveParser;
import org.jetbrains.idea.perforce.perforce.PathsHelper;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public abstract class UnversionedScopeScanner {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.UnversionedScopeScanner");
    private final Project myProject;
    private final PerforceRunner myRunner;

    public UnversionedScopeScanner(Project project) {
        this.myProject = project;
        this.myRunner = PerforceRunner.getInstance(this.myProject);
    }

    protected abstract void checkCanceled();

    public ScanResult doRescan(Collection<FilePath> dirtyFiles) throws VcsException {
        final ScanResult result = new ScanResult();
        if (LOG.isDebugEnabled()) {
            LOG.debug("scope=" + dirtyFiles);
        }
        MultiMap<P4Connection, FilePath> map = FileGrouper.distributePathsByConnection(dirtyFiles, this.myProject);
        for (P4Connection connection : map.keySet()) {
            Collection files = map.get((Object)connection);
            final Set<VirtualFile> localFiles = this.enumerateLocalFiles(files);
            result.allLocalFiles.addAll(localFiles);
            this.checkCanceled();
            final LocalFileSystem fs = LocalFileSystem.getInstance();
            this.myRunner.haveMultiple(this.collectPaths(files), connection, new P4HaveParser(PerforceManager.getInstance(this.myProject)){

                @Override
                public void consumeRevision(String path, long revision) {
                    UnversionedScopeScanner.this.checkCanceled();
                    VirtualFile vFile = this.findVirtualFile(path);
                    if (vFile != null) {
                        localFiles.remove(vFile);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("locally missing file reported: " + path);
                        }
                        result.missingFiles.add(path);
                    }
                }

                private VirtualFile findVirtualFile(String path) {
                    VirtualFile vFile = fs.findFileByPathIfCached(FileUtil.toSystemIndependentName((String)path));
                    if (vFile != null) {
                        return vFile;
                    }
                    File ioFile = new File(path);
                    String appleForkPath = FileUtil.toSystemIndependentName((String)ioFile.getParent()) + "/%" + ioFile.getName();
                    return fs.findFileByPathIfCached(FileUtil.toSystemIndependentName((String)appleForkPath));
                }
            });
            this.checkCanceled();
            for (VirtualFile file : localFiles) {
                boolean ignored = ChangeListManager.getInstance((Project)this.myProject).isIgnoredFile(file);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("localOnly reported: " + file + (ignored ? ", ignored" : ""));
                }
                if (ignored) continue;
                result.localOnly.add(file);
            }
        }
        return result;
    }

    private PathsHelper collectPaths(Collection<FilePath> value) {
        PathsHelper helper = new PathsHelper(PerforceManager.getInstance(this.myProject));
        for (FilePath dir : value) {
            if (dir.isDirectory()) {
                helper.addRecursively(dir);
                continue;
            }
            helper.add(dir);
        }
        return helper;
    }

    static List<FilePath> createEverythingDirtyScope(Project project) throws VcsException {
        ArrayList scope = ContainerUtil.newArrayList();
        for (Pair<P4Connection, Collection<VirtualFile>> pair : PerforceVcs.getInstance(project).getRootsByConnections()) {
            for (VirtualFile file : (Collection)pair.second) {
                scope.add(VcsUtil.getFilePath((VirtualFile)file));
            }
        }
        return scope;
    }

    private Set<VirtualFile> enumerateLocalFiles(Collection<FilePath> roots) {
        VcsDirtyScopeImpl scope = new VcsDirtyScopeImpl((AbstractVcs)PerforceVcs.getInstance(this.myProject), this.myProject);
        for (FilePath root : roots) {
            scope.addDirtyDirRecursively(root);
        }
        THashSet localFiles = new THashSet();
        scope.iterateExistingInsideScope((Processor)new Processor<VirtualFile>((Set)localFiles){
            final /* synthetic */ Set val$localFiles;
            {
                this.val$localFiles = set;
            }

            public boolean process(VirtualFile file) {
                if (!file.isDirectory()) {
                    this.val$localFiles.add(file);
                } else {
                    UnversionedScopeScanner.this.checkCanceled();
                }
                return true;
            }
        });
        return localFiles;
    }

    static class ScanResult {
        final Set<String> missingFiles = ContainerUtil.newTroveSet();
        final List<VirtualFile> localOnly = ContainerUtil.newArrayList();
        final Set<VirtualFile> allLocalFiles = ContainerUtil.newTroveSet();

        ScanResult() {
        }
    }
}

