/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.util.tracer;

import com.intellij.openapi.util.Factory;
import com.intellij.util.Consumer;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.util.tracer.IntervalStatistics;
import org.jetbrains.idea.perforce.util.tracer.Tracer;

class LongCallsStatistics<Kind extends Enum>
extends IntervalStatistics<Data<Kind>, IntervalData<Kind>, AverageData<Kind>>
implements Tracer<Kind, Long> {
    private static final int ourDefaultMaxKept = 20;
    private static final long ourDefaultLowerBound = 1000L;
    private final long myLowerBound;

    public LongCallsStatistics(long intervalInMillis, int historyQueueSize, @Nullable Runnable switchListener, final int maxKept, long lowerBound) {
        super(intervalInMillis, historyQueueSize, new Factory<IntervalData<Kind>>(){

            public IntervalData<Kind> create() {
                return new IntervalData(maxKept <= 0 ? 20 : maxKept);
            }
        }, new Factory<AverageData<Kind>>(){

            public AverageData<Kind> create() {
                return new AverageData(maxKept <= 0 ? 20 : maxKept);
            }
        }, switchListener);
        this.myLowerBound = lowerBound < 0L ? 1000L : lowerBound;
    }

    @Override
    public Long start(Kind kind, String presentation) {
        return System.currentTimeMillis();
    }

    @Override
    public void stop(Long key, Kind kind, String presentation) {
        long interval = System.currentTimeMillis() - key;
        if (interval < this.myLowerBound) {
            return;
        }
        this.step(new Data(presentation, interval));
    }

    public static class Data<Kind> {
        private final Throwable myStackTraceHolder;
        private final String myPresentation;
        private final long myInterval;

        public Data(String presentation, long interval) {
            this.myPresentation = presentation;
            this.myInterval = interval;
            this.myStackTraceHolder = new Throwable();
        }

        public Throwable getStackTraceHolder() {
            return this.myStackTraceHolder;
        }

        public String getPresentation() {
            return this.myPresentation;
        }

        public long getInterval() {
            return this.myInterval;
        }
    }

    public static class AverageData<Kind>
    extends MyMapHolder<Kind>
    implements Consumer<IntervalData<Kind>> {
        public AverageData(int maxKept) {
            super(maxKept);
        }

        public void consume(IntervalData<Kind> kindIntervalData) {
            SortedMap map = kindIntervalData.getMap();
            for (Data kindData : map.values()) {
                this.accept(kindData);
            }
        }
    }

    public static class IntervalData<Kind>
    extends MyMapHolder<Kind>
    implements Consumer<Data<Kind>> {
        public IntervalData(int maxKept) {
            super(maxKept);
        }

        public void consume(Data<Kind> kindData) {
            this.accept(kindData);
        }
    }

    static class MyMapHolder<Kind> {
        private final int myMaxKept;
        private final SortedMap<Long, Data<Kind>> myMap;

        MyMapHolder(int maxKept) {
            this.myMaxKept = maxKept;
            this.myMap = new TreeMap<Long, Data<Kind>>();
        }

        protected void accept(Data<Kind> kindData) {
            long interval = kindData.getInterval();
            if (!this.myMap.isEmpty() && this.myMap.firstKey() > interval) {
                return;
            }
            if (this.myMap.size() == this.myMaxKept) {
                this.myMap.remove(this.myMap.firstKey());
            }
            this.myMap.put(interval, kindData);
        }

        public SortedMap<Long, Data<Kind>> getMap() {
            return this.myMap;
        }
    }
}

