/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.TableInfoProvider;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.JavaContainerType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistenceCommonUtil {
    private static final Key<CachedValue<List<PersistenceFacet>>> MODULE_PERSISTENCE_FACETS = Key.create((String)"MODULE_PERSISTENCE_FACETS");

    private PersistenceCommonUtil() {
    }

    @NotNull
    public static List<PersistenceFacet> getAllPersistenceFacets(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/persistence/util/PersistenceCommonUtil", "getAllPersistenceFacets"));
        }
        List<PersistenceFacet> result = Collections.emptyList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            List<PersistenceFacet> facets = PersistenceCommonUtil.getAllPersistenceFacets(module);
            if (facets.isEmpty()) continue;
            if (result.isEmpty()) {
                result = new ArrayList<PersistenceFacet>(facets.size());
            }
            result.addAll(facets);
        }
        List<PersistenceFacet> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceCommonUtil", "getAllPersistenceFacets"));
        }
        return list;
    }

    @NotNull
    public static List<PersistenceFacet> getAllPersistenceFacets(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/persistence/util/PersistenceCommonUtil", "getAllPersistenceFacets"));
        }
        List<PersistenceFacet> result = Collections.emptyList();
        for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
            if (!(facet instanceof PersistenceFacet)) continue;
            if (result.isEmpty()) {
                result = new ArrayList<PersistenceFacet>();
            }
            result.add((PersistenceFacet)facet);
        }
        List<PersistenceFacet> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceCommonUtil", "getAllPersistenceFacets"));
        }
        return list;
    }

    @NotNull
    public static List<PersistenceFacet> getAllPersistenceFacetsWithDependencies(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/persistence/util/PersistenceCommonUtil", "getAllPersistenceFacetsWithDependencies"));
        }
        if (module.isDisposed()) {
            List<PersistenceFacet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceCommonUtil", "getAllPersistenceFacetsWithDependencies"));
            }
            return list;
        }
        CachedValue cachedValue = (CachedValue)module.getUserData(MODULE_PERSISTENCE_FACETS);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<List<PersistenceFacet>>(){

                public CachedValueProvider.Result<List<PersistenceFacet>> compute() {
                    THashSet modules = new THashSet();
                    ContainerUtil.addAll((Collection)modules, (Object[])JamCommonUtil.getAllDependentModules((Module)module));
                    ContainerUtil.addAll((Collection)modules, (Object[])JamCommonUtil.getAllModuleDependencies((Module)module));
                    THashSet facets = new THashSet();
                    for (Module depModule : modules) {
                        facets.addAll(PersistenceCommonUtil.getAllPersistenceFacets(depModule));
                    }
                    return new CachedValueProvider.Result(new ArrayList(facets), new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
                }
            }, false);
            module.putUserData(MODULE_PERSISTENCE_FACETS, (Object)cachedValue);
        }
        List list = (List)cachedValue.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceCommonUtil", "getAllPersistenceFacetsWithDependencies"));
        }
        return list;
    }

    public static PersistenceModelBrowser createSameUnitsModelBrowser(@Nullable PsiElement sourceElement) {
        PsiClass sourceClass;
        Set unitSet = sourceElement == null || (sourceClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, PsiClass.class, (boolean)false)) == null ? null : (Set)PersistenceCommonUtil.getAllPersistenceUnits(sourceClass, new THashSet());
        return PersistenceCommonUtil.createUnitsAndTypeMapper(unitSet);
    }

    public static PersistenceModelBrowser createSameUnitsModelBrowser(@Nullable DomElement sourceDom) {
        DomElement rootElement;
        THashSet unitSet = sourceDom == null || !((rootElement = DomUtil.getFileElement((DomElement)sourceDom).getRootElement()) instanceof PersistenceMappings) ? null : new THashSet(PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceUnits((PersistenceMappings)rootElement));
        return PersistenceCommonUtil.createUnitsAndTypeMapper(unitSet);
    }

    public static PersistenceModelBrowser createUnitsAndTypeMapper(final @Nullable Set<PersistencePackage> unitSet) {
        return PersistenceHelper.getHelper().createModelBrowser().setRoleFilter(new Condition<PersistenceClassRole>(){

            public boolean value(PersistenceClassRole role) {
                PersistentObject object = role.getPersistentObject();
                PersistenceClassRoleEnum roleType = role.getType();
                return roleType != PersistenceClassRoleEnum.ENTITY_LISTENER && object != null && (unitSet == null || unitSet.contains(role.getPersistenceUnit()));
            }
        });
    }

    public static PersistenceModelBrowser createFacetAndUnitModelBrowser(final PersistenceFacet facet, final PersistencePackage unit, final @Nullable PersistenceClassRoleEnum type) {
        return PersistenceHelper.getHelper().createModelBrowser().setRoleFilter(new Condition<PersistenceClassRole>(){

            public boolean value(PersistenceClassRole role) {
                PersistentObject object = role.getPersistentObject();
                return !(object == null || type != null && role.getType() != type || unit != null && !unit.equals(role.getPersistenceUnit()) || facet != null && !facet.equals(role.getFacet()));
            }
        });
    }

    @Nullable
    public static PsiType getTargetEntityType(PsiMember psiMember) {
        return PersistenceCommonUtil.getTargetEntityType(PropertyUtil.getPropertyType((PsiMember)psiMember));
    }

    @Nullable
    public static PsiType getTargetEntityType(PsiType type) {
        return PersistenceCommonUtil.getTypeInfo(type).getValueType();
    }

    public static <T extends Collection<PersistencePackage>> T getAllPersistenceUnits(@Nullable PsiClass sourceClass, @NotNull T result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/persistence/util/PersistenceCommonUtil", "getAllPersistenceUnits"));
        }
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles(sourceClass)) {
            ContainerUtil.addIfNotNull((Object)role.getPersistenceUnit(), result);
        }
        return result;
    }

    @NotNull
    public static <V extends PersistenceMappings> Collection<V> getDomEntityMappings(Class<V> mappingsClass, PersistencePackage unit, PersistenceFacet facet) {
        THashSet result = new THashSet();
        for (PersistenceMappings persistenceMappings : facet.getDefaultEntityMappings(unit)) {
            if (!ReflectionUtil.isAssignable(mappingsClass, persistenceMappings.getClass())) continue;
            result.add((Object)persistenceMappings);
        }
        for (GenericValue genericValue : unit.getModelHelper().getMappingFiles(mappingsClass)) {
            ContainerUtil.addIfNotNull((Object)genericValue.getValue(), (Collection)result);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceCommonUtil", "getDomEntityMappings"));
        }
        return tHashSet;
    }

    public static boolean isSameTable(TableInfoProvider table1, TableInfoProvider table2) {
        if (table1 == null || table2 == null) {
            return false;
        }
        String name1 = (String)table1.getTableName().getValue();
        return StringUtil.isNotEmpty((String)name1) && Comparing.equal((String)name1, (String)((String)table2.getTableName().getValue())) && Comparing.equal((String)((String)table1.getSchema().getValue()), (String)((String)table2.getSchema().getValue())) && Comparing.equal((String)((String)table1.getCatalog().getValue()), (String)((String)table2.getCatalog().getValue()));
    }

    public static String getUniqueId(PsiElement psiElement) {
        VirtualFile virtualFile = psiElement == null ? null : PsiUtilBase.getVirtualFile((PsiElement)psiElement);
        return virtualFile == null ? "" : virtualFile.getUrl();
    }

    public static String getMultiplicityString(boolean optional, boolean many) {
        String first = optional ? "0" : "1";
        String last = many ? "*" : "1";
        return first.equals(last) ? first : first + ".." + last;
    }

    public static <T, V extends Collection<T>> V mapPersistenceRoles(V result, Project project, PersistenceFacet facet, PersistencePackage unit, Function<PersistenceClassRole, T> mapper) {
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles(project)) {
            if (facet != null && facet != role.getFacet() || unit != null && unit != role.getPersistenceUnit()) continue;
            ContainerUtil.addIfNotNull((Object)mapper.fun((Object)role), result);
        }
        return result;
    }

    public static boolean haveCorrespondingMultiplicity(PersistentRelationshipAttribute a1, PersistentRelationshipAttribute a2) {
        return a1.getAttributeModelHelper().getRelationshipType().corresponds(a2.getAttributeModelHelper().getRelationshipType());
    }

    @NotNull
    public static JavaTypeInfo getTypeInfo(PsiType type) {
        PsiClass psiClass;
        if (type instanceof PsiArrayType) {
            JavaTypeInfo javaTypeInfo = new JavaTypeInfo(JavaContainerType.ARRAY, type, ((PsiArrayType)type).getComponentType());
            if (javaTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceCommonUtil", "getTypeInfo"));
            }
            return javaTypeInfo;
        }
        PsiClassType.ClassResolveResult classResolveResult = type instanceof PsiClassType ? ((PsiClassType)type).resolveGenerics() : null;
        PsiClass psiClass2 = psiClass = classResolveResult == null ? null : classResolveResult.getElement();
        if (psiClass == null) {
            JavaTypeInfo javaTypeInfo = new JavaTypeInfo(null, type, new PsiType[0]);
            if (javaTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceCommonUtil", "getTypeInfo"));
            }
            return javaTypeInfo;
        }
        PsiManager manager = psiClass.getManager();
        GlobalSearchScope scope = ProjectScope.getAllScope((Project)manager.getProject());
        for (JavaContainerType collectionType : JavaContainerType.values()) {
            PsiClass aClass;
            if (collectionType == JavaContainerType.ARRAY || (aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(collectionType.getJavaBaseClassName(), scope)) == null || !manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)psiClass) && !psiClass.isInheritor(aClass, true)) continue;
            final PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)psiClass, (PsiSubstitutor)classResolveResult.getSubstitutor());
            JavaTypeInfo result = new JavaTypeInfo(collectionType, type, (PsiType[])ArrayUtil.reverseArray((Object[])ContainerUtil.map2Array((Object[])aClass.getTypeParameters(), PsiType.class, (Function)new NullableFunction<PsiTypeParameter, PsiType>(){

                public PsiType fun(PsiTypeParameter psiTypeParameter) {
                    return superClassSubstitutor.substitute(psiTypeParameter);
                }
            })));
            if (result.containerType == JavaContainerType.MAP && result.parameters.length != 2 || JavaContainerType.isCollection(result.containerType) && result.parameters.length != 1) {
                JavaTypeInfo javaTypeInfo = new JavaTypeInfo(null, type, new PsiType[0]);
                if (javaTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceCommonUtil", "getTypeInfo"));
                }
                return javaTypeInfo;
            }
            JavaTypeInfo javaTypeInfo = result;
            if (javaTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceCommonUtil", "getTypeInfo"));
            }
            return javaTypeInfo;
        }
        JavaTypeInfo javaTypeInfo = new JavaTypeInfo(null, type, new PsiType[0]);
        if (javaTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/PersistenceCommonUtil", "getTypeInfo"));
        }
        return javaTypeInfo;
    }

    public static Query<PersistentObject> queryPersistentObjects(PersistenceMappings mappings) {
        return new ExecutorsQuery((Object)mappings, Collections.singletonList(new QueryExecutor<PersistentObject, PersistenceMappings>(){

            public boolean execute(@NotNull PersistenceMappings queryParameters, @NotNull Processor<PersistentObject> consumer) {
                if (queryParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/persistence/util/PersistenceCommonUtil$5", "execute"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/persistence/util/PersistenceCommonUtil$5", "execute"));
                }
                if (!ContainerUtil.process(queryParameters.getModelHelper().getPersistentEntities(), consumer)) {
                    return false;
                }
                if (!ContainerUtil.process(queryParameters.getModelHelper().getPersistentSuperclasses(), consumer)) {
                    return false;
                }
                return ContainerUtil.process(queryParameters.getModelHelper().getPersistentEmbeddables(), consumer);
            }
        }));
    }

    @Nullable
    public static PsiClass getTargetClass(PersistentRelationshipAttribute attribute) {
        PsiType entityType;
        GenericValue<PsiClass> classValue = attribute.getTargetEntityClass();
        PsiClass targetClass = classValue.getStringValue() != null ? (PsiClass)classValue.getValue() : ((entityType = PersistenceCommonUtil.getTargetEntityType(attribute.getPsiMember())) instanceof PsiClassType ? ((PsiClassType)entityType).resolve() : null);
        return targetClass;
    }

    @Nullable
    public static PsiClass getTargetClass(PersistentEmbeddedAttribute attribute) {
        PsiType entityType;
        GenericValue<PsiClass> classValue = attribute.getTargetEmbeddableClass();
        PsiClass targetClass = classValue.getStringValue() != null ? (PsiClass)classValue.getValue() : ((entityType = PropertyUtil.getPropertyType((PsiMember)attribute.getPsiMember())) instanceof PsiClassType ? ((PsiClassType)entityType).resolve() : null);
        return targetClass;
    }

    @Nullable
    public static PsiType getPrimaryKeyClass(@NotNull PersistentEntityBase persistentObject, PersistenceModelBrowser browser) {
        if (persistentObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentObject", "com/intellij/persistence/util/PersistenceCommonUtil", "getPrimaryKeyClass"));
        }
        ArrayList<PersistentAttribute> idAttrs = new ArrayList<PersistentAttribute>();
        for (PersistentObject object : browser.queryPersistentObjectHierarchy(persistentObject)) {
            if (!(object instanceof PersistentEntityBase)) continue;
            PsiClass idClass = (PsiClass)((PersistentEntityBase)object).getIdClassValue().getValue();
            if (idClass != null) {
                return JavaPsiFacade.getElementFactory((Project)idClass.getProject()).createType(idClass);
            }
            for (PersistentAttribute idAttr : object.getObjectModelHelper().getAttributes()) {
                if (!idAttr.getAttributeModelHelper().isIdAttribute()) continue;
                idAttrs.add(idAttr);
            }
        }
        return idAttrs.size() == 1 ? ((PersistentAttribute)idAttrs.get(0)).getPsiType() : null;
    }

    public static PersistenceClassRole[] getPersistenceRoles(PsiClass psiClass) {
        if (psiClass == null) {
            return PersistenceClassRole.EMPTY_ARRAY;
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        PersistenceRoleHolder.getInstance(psiClass.getProject()).processAllRoles(psiClass, (Processor<PersistenceClassRole>)collectProcessor);
        return (PersistenceClassRole[])ContainerUtil.toArray((Collection)collectProcessor.getResults(), PersistenceClassRole.ARRAY_FACTORY);
    }

    public static PersistenceClassRole[] getPersistenceRoles(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/persistence/util/PersistenceCommonUtil", "getPersistenceRoles"));
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        PersistenceRoleHolder.getInstance(project).processAllRoles((Processor<PersistenceClassRole>)collectProcessor);
        return (PersistenceClassRole[])ContainerUtil.toArray((Collection)collectProcessor.getResults(), PersistenceClassRole.ARRAY_FACTORY);
    }
}

