/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.dsm.actions.AbstractDsmAction;
import com.intellij.dsm.actions.DsmUIUtil;
import com.intellij.dsm.model.DsmModel;
import com.intellij.dsm.model.DsmModelImpl;
import com.intellij.dsm.model.DsmModelUtil;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmTable;
import com.intellij.dsm.ui.DsmView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.BooleanFunction;
import java.util.Collection;
import java.util.HashSet;
import org.gga.graph.Edge;
import org.gga.graph.Subgraph;
import org.gga.graph.maps.DataGraph;

public class ExploreDependenciesAction<N>
extends AbstractDsmAction<N>
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        this.onAction(e);
    }

    private void onAction(AnActionEvent e) {
        DsmModel dsmModel = this.getModel(e);
        assert (dsmModel != null);
        DsmSelection selection = this.getSelection(e).iterator().next();
        assert (selection != null && selection.type == DsmSelection.Type.CELL);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final HashSet from = new HashSet();
        final HashSet to = new HashSet();
        DsmModelUtil.collectLeafData(selection.node1, from);
        DsmModelUtil.collectLeafData(selection.node2, to);
        final DataGraph graph = dsmModel.getGraph();
        final HashSet includedNodes = new HashSet();
        for (Object n2 : to) {
            for (Object n1 : from) {
                if (graph.edge(n2, n1) == null && graph.edge(n1, n2) == null) continue;
                includedNodes.add(n1);
                includedNodes.add(n2);
            }
        }
        DataGraph newGraph = (DataGraph)Subgraph.subgraph(graph, new BooleanFunction<N>(){

            public boolean fun(N n) {
                return includedNodes.contains(n);
            }
        }, (BooleanFunction<Edge>)new BooleanFunction<Edge>(){

            public boolean fun(Edge edge) {
                Object n1 = graph.getNode(edge.v());
                Object n2 = graph.getNode(edge.w());
                if (from.contains(n1)) {
                    return to.contains(n2);
                }
                if (from.contains(n2)) {
                    return to.contains(n1);
                }
                return false;
            }
        }).first;
        String name = ExploreDependenciesAction.getNewName(selection);
        DsmTreeStructure oldTreeStructure = dsmModel.getTreeStructure();
        DsmUIUtil.showView(project, new DsmView(new DsmModelImpl(newGraph, oldTreeStructure.createNewStructure(newGraph), dsmModel.getNodeClass())), name);
    }

    private static <N> String getNewName(DsmSelection<N> selection) {
        assert (selection.type == DsmSelection.Type.CELL);
        return DsmModelUtil.getShortName(selection.node2) + " -> " + DsmModelUtil.getShortName(selection.node1);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(this.isEnabled(e));
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        Collection selection = this.getSelection(e);
        if (selection == null) {
            return false;
        }
        if (selection.size() != 1) {
            return false;
        }
        DsmSelection s = selection.iterator().next();
        if (s.type != DsmSelection.Type.CELL) {
            return false;
        }
        DsmTable dsmTable = this.getTable(e);
        assert (dsmTable != null);
        DataGraph graph = dsmTable.getGraph();
        int sum = 0;
        for (DsmTreeStructure.TreeNode n1 : s.node1) {
            for (DsmTreeStructure.TreeNode n2 : s.node2) {
                Integer i = graph.edge(n2, n1);
                if (i == null) continue;
                sum += i.intValue();
            }
        }
        return sum != 0;
    }
}

