/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.And;
import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.gga.graph.maps.DataGraph;

public class PackagesSplitter
implements TopToBottomTreeStructure.TreeSplitter<ClassNode> {
    @Override
    public List<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> split(DataGraph<ClassNode, Integer> dataGraph, BooleanFunction<ClassNode> memberFunction, TopToBottomTreeStructure.NodeData parentData) {
        ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>> result = new ArrayList<Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>>();
        if (parentData instanceof MyClassesData) {
            result.add(new Pair(memberFunction, null));
            return result;
        }
        HashSet<String> subPackages = new HashSet<String>();
        final HashSet<ClassNode> classesInPackage = new HashSet<ClassNode>();
        String currentPackage = parentData instanceof MyNodeData ? ((MyNodeData)parentData).myPackageName : "";
        String prefix = currentPackage.length() == 0 ? currentPackage : currentPackage + ".";
        for (int i = 0; i < dataGraph.V(); ++i) {
            ClassNode classNode = dataGraph.getNode(i);
            if (!memberFunction.fun((Object)classNode)) continue;
            String packageName = classNode.getPackageName();
            if (packageName.startsWith(prefix)) {
                String subName = packageName.substring(prefix.length());
                int idx = subName.indexOf(".");
                if (idx >= 0) {
                    subName = subName.substring(0, idx);
                }
                subPackages.add(subName);
                continue;
            }
            classesInPackage.add(classNode);
        }
        if (!subPackages.isEmpty()) {
            Object[] names = ArrayUtil.toStringArray(subPackages);
            Arrays.sort(names);
            for (Object packageShortName : names) {
                final String packageName = prefix + (String)packageShortName;
                result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair(new And<ClassNode>(memberFunction, new BooleanFunction<ClassNode>(){

                    public boolean fun(ClassNode classNode) {
                        String name = classNode.getPackageName();
                        return StringUtil.startsWithConcatenation((String)name, (String[])new String[]{packageName, "."}) || name.equals(packageName);
                    }
                }), (Object)new MyNodeData(packageName, (String)packageShortName)));
            }
        }
        if (!classesInPackage.isEmpty()) {
            result.add((Pair<BooleanFunction<ClassNode>, TopToBottomTreeStructure.NodeData>)new Pair((Object)new BooleanFunction<ClassNode>(){

                public boolean fun(ClassNode classNode) {
                    return classesInPackage.contains(classNode);
                }
            }, (Object)new MyClassesData(currentPackage)));
        }
        return result;
    }

    private static class MyClassesData
    extends TopToBottomTreeStructure.NodeData {
        public MyClassesData(String packageName) {
            super("*", packageName + ".*", AllIcons.Nodes.Package);
        }
    }

    private static class MyNodeData
    extends TopToBottomTreeStructure.NodeData {
        private final String myPackageName;

        public MyNodeData(String packageName, String name) {
            super(name, packageName, AllIcons.Nodes.Package);
            this.myPackageName = packageName;
        }
    }
}

