/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.jee;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.facet.EjbFacetConfiguration;
import com.intellij.javaee.ejb.facet.EjbFacetType;
import com.intellij.javaee.model.EjbRootDescriptor;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElementFactory;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.idea.maven.ext.jee.JavaeeFacetImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class EjbFacetImporter
extends JavaeeFacetImporter<EjbFacet, EjbFacetConfiguration, EjbFacetType> {
    public EjbFacetImporter() {
        super("org.apache.maven.plugins", "maven-ejb-plugin", "ejb", EjbFacetType.getInstance());
    }

    protected String getTargetExtension(MavenProject p) {
        return "jar";
    }

    @Override
    protected void setupJavaeeFacet(EjbFacet f, MavenProject p) {
        this.setDescriptor(f, EjbRootDescriptor.EJB_JAR_META_DATA, this.makePath(p, new String[]{"src/main/resources/META-INF/ejb-jar.xml"}));
    }

    @Override
    protected ArtifactType getArtifactType(boolean exploded) {
        return exploded ? JavaeeArtifactUtil.getInstance().getExplodedEjbArtifactType() : JavaeeArtifactUtil.getInstance().getEjbJarArtifactType();
    }

    @Override
    protected void setSourceRoots(EjbFacet f, String[] urls) {
        f.setEjbSourceRoots(urls);
    }

    @Override
    protected void ensureArtifactExists(MavenProject mavenProject, IdeModifiableModelsProvider modelsProvider, Module module, boolean exploded) {
        super.ensureArtifactExists(mavenProject, modelsProvider, module, exploded);
        if (!this.shouldGenerateClient(mavenProject)) {
            return;
        }
        String clientArtifactName = MavenUtil.getEjbClientArtifactName((Module)module);
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        Artifact artifact = artifactModel.findArtifact(clientArtifactName);
        if (artifact == null || !artifact.getArtifactType().equals(JavaeeArtifactUtil.getInstance().getExplodedEjbArtifactType())) {
            if (artifact != null) {
                artifactModel.removeArtifact(artifact);
            }
            artifactModel.addArtifact(clientArtifactName, JavaeeArtifactUtil.getInstance().getExplodedEjbArtifactType());
        }
    }

    private boolean shouldGenerateClient(MavenProject mavenProject) {
        Element cfg = this.getConfig(mavenProject);
        return cfg != null && Boolean.parseBoolean(cfg.getChildTextTrim("generateClient"));
    }

    @Override
    protected void reimportFacet(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, EjbFacet facet, MavenProjectsTree mavenTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        super.reimportFacet(modelsProvider, module, rootModel, facet, mavenTree, mavenProject, changes, mavenProjectToModuleName, postTasks);
        this.findArtifact(modelsProvider, module, true).getRootElement().addOrFindChild(PackagingElementFactory.getInstance().createModuleOutput(module));
        this.configClientArtifact(modelsProvider, module, rootModel, facet, mavenProject);
    }

    private void configClientArtifact(IdeModifiableModelsProvider modelsProvider, Module module, MavenRootModelAdapter rootModel, EjbFacet facet, MavenProject mavenProject) {
        boolean shouldConfigurePaths;
        ModifiableArtifact modifiableArtifact;
        String clientArtifactName = MavenUtil.getEjbClientArtifactName((Module)module);
        ModifiableArtifactModel artifactModel = modelsProvider.getModifiableArtifactModel();
        Artifact artifact = artifactModel.findArtifact(clientArtifactName);
        if (!this.shouldGenerateClient(mavenProject)) {
            if (artifact != null) {
                artifactModel.removeArtifact(artifact);
            }
            return;
        }
        if (artifact == null || !artifact.getArtifactType().equals(JavaeeArtifactUtil.getInstance().getExplodedEjbArtifactType())) {
            if (artifact != null) {
                artifactModel.removeArtifact(artifact);
            }
            modifiableArtifact = artifactModel.addArtifact(clientArtifactName, JavaeeArtifactUtil.getInstance().getExplodedEjbArtifactType());
            shouldConfigurePaths = true;
        } else {
            modifiableArtifact = artifactModel.getOrCreateModifiableArtifact(artifact);
            shouldConfigurePaths = MavenProjectsManager.getInstance((Project)module.getProject()).getImportingSettings().isUseMavenOutput();
        }
        if (shouldConfigurePaths) {
            modifiableArtifact.setOutputPath(this.makePath(mavenProject, new String[]{mavenProject.getBuildDirectory(), this.getTargetFileName(mavenProject, "-client.jar")}));
        }
        this.prepareRootElement(facet, modifiableArtifact.getRootElement(), mavenProject);
        this.reimportSourceRoots(facet, rootModel);
        this.reimportAppServerDescriptors(facet, mavenProject);
        modifiableArtifact.getRootElement().addOrFindChild(PackagingElementFactory.getInstance().createModuleOutput(module));
    }

    @Override
    protected void doAddLibraryDependency(IdeModifiableModelsProvider modelsProvider, MavenProject mavenProject, ModifiableArtifact artifact, Library depLibrary, String relativeOutputPath, String jarFileName) {
    }

    @Override
    protected boolean isLinkViaManifest(MavenProject project) {
        return true;
    }

    @Override
    protected boolean shouldIncludeInArtifact(MavenProject project) {
        return false;
    }
}

