/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.JspImplicitVariableImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.SpringBeanPointer;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class SpringElBeanVariable
extends JspImplicitVariableImpl {
    private final Icon myIcon;
    private final String myLocation;

    public SpringElBeanVariable(SpringBeanPointer springBeanPointer, PsiFile file, String beanName, PsiElement declaration) {
        super((PsiElement)file, beanName, (PsiType)SpringElBeanVariable.getBeanType(springBeanPointer), declaration, "NESTED");
        this.myIcon = SpringPresentationProvider.getSpringIcon((Object)springBeanPointer);
        this.myLocation = SpringPresentationProvider.getSpringBeanLocation((SpringBeanPointer)springBeanPointer);
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.myIcon;
    }

    public String getLocationString() {
        return this.myLocation;
    }

    private static PsiClassType getBeanType(SpringBeanPointer springBeanPointer) {
        PsiClass[] classes = springBeanPointer.getEffectiveBeanType();
        if (classes.length == 0) {
            PsiManager psiManager = springBeanPointer.getContainingFile().getManager();
            return PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiManager.getProject()));
        }
        return PsiTypesUtil.getClassType((PsiClass)classes[0]);
    }
}

