/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ModelSerializer;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Base64;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataSource
extends SimpleModificationTracker
implements DatabaseSystem {
    @NonNls
    public static final String ELEMENT_NAME = "data-source";
    private String myUUID;
    @NotNull
    private String myName = "";
    private String myComment;
    private boolean myReadOnly;
    private boolean myGlobal;
    private final Info myInfo = new Info();
    protected volatile DasModel myState = DasUtil.emptyModel();

    protected DataSource() {
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    @Override
    public String getUniqueId() {
        return this.myUUID;
    }

    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    public void deserialize(Project project, Reader reader) throws Exception {
        this.deserialize(project, (HierarchicalStreamReader)new XppReader(reader), SaveMode.ALL);
    }

    public void deserialize(@Nullable Project project, @NotNull HierarchicalStreamReader reader, @NotNull SaveMode mode) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/DataSource", "deserialize"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/DataSource", "deserialize"));
        }
        HashSet legacyTags = ContainerUtil.newHashSet((Object[])new String[]{"table", "procedure", "schema"});
        if (ELEMENT_NAME.equals(reader.getNodeName())) {
            this.setName(StringUtil.notNullize((String)reader.getAttribute("name")));
            if (mode.includeConfig()) {
                this.myReadOnly = "true".equals(reader.getAttribute("read-only"));
            }
            this.myUUID = reader.getAttribute("uuid");
            DasModel state = null;
            if (mode.includeDatabaseInfo()) {
                this.deserializeDatabaseInfo(reader, true);
            }
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                boolean skipMoveUp = false;
                String nodeName = reader.getNodeName();
                if (mode.includeDatabaseInfo() && "database-info".equals(nodeName)) {
                    this.deserializeDatabaseInfo(reader, false);
                } else if (mode.includeDatabaseInfo() && "case-sensitivity".equals(nodeName)) {
                    Case plain = Case.fromString(reader.getAttribute("plain-identifiers"), DasUtil.CASING_MIXED.plain);
                    Case quoted = Case.fromString(reader.getAttribute("quoted-identifiers"), DasUtil.CASING_MIXED.quoted);
                    this.myInfo.myCasing = Casing.create(plain, quoted);
                } else if (mode.includeDatabaseInfo() && "extra-name-characters".equals(nodeName)) {
                    this.myInfo.myExtraNameCharacters = reader.getValue();
                } else if (mode.includeDatabaseInfo() && "identifier-quote-string".equals(nodeName)) {
                    this.myInfo.myIdentifierQuoteString = reader.getValue();
                } else if (!this.deserializeHeaderInner(project, reader, mode) && mode.includeSchema()) {
                    ModelSerializer importer;
                    String serializerName = reader.getAttribute("serializer");
                    if (serializerName == null && legacyTags.contains(nodeName)) {
                        serializerName = "legacy";
                        skipMoveUp = true;
                    }
                    ModelSerializer modelSerializer = importer = serializerName == null ? null : (ModelSerializer)ModelSerializer.INSTANCES.findSingle((Object)serializerName);
                    if (importer != null) {
                        state = importer.deserialize(reader);
                    }
                }
                if (skipMoveUp) continue;
                reader.moveUp();
            }
            if (mode.includeSchema() && state != null) {
                this.updateState(state);
            }
        }
    }

    private void deserializeDatabaseInfo(@NotNull HierarchicalStreamReader xmlReader, boolean skipChildren) {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/intellij/database/dataSource/DataSource", "deserializeDatabaseInfo"));
        }
        this.myInfo.myProductName = xmlReader.getAttribute("product");
        this.myInfo.myProductVersion = xmlReader.getAttribute("version");
        this.myInfo.myJDBCVersion = xmlReader.getAttribute("jdbc-version");
        this.myInfo.myDriverName = xmlReader.getAttribute("driver-name");
        this.myInfo.myDriverVersion = xmlReader.getAttribute("driver-version");
        if (skipChildren) {
            return;
        }
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if ("extra-name-characters".equals(nodeName)) {
                this.myInfo.myExtraNameCharacters = xmlReader.getValue();
            } else if ("identifier-quote-string".equals(nodeName)) {
                this.myInfo.myIdentifierQuoteString = xmlReader.getValue();
            }
            xmlReader.moveUp();
        }
    }

    protected boolean deserializeHeaderInner(@Nullable Project project, HierarchicalStreamReader xmlReader, SaveMode mode) {
        return false;
    }

    public void serialize(@Nullable Project project, @NotNull HierarchicalStreamWriter serializer, @NotNull SaveMode mode) {
        ModelSerializer ms;
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/database/dataSource/DataSource", "serialize"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/DataSource", "serialize"));
        }
        serializer.startNode(ELEMENT_NAME);
        this.serializeHeader(project, serializer, mode);
        if (mode.includeSchema() && (ms = DataSource.findSerializer(this.getModel())) != null) {
            ms.serialize(this.getModel(), serializer);
        }
        serializer.endNode();
        serializer.flush();
    }

    @Nullable
    private static ModelSerializer findSerializer(@NotNull DasModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DataSource", "findSerializer"));
        }
        for (KeyedLazyInstance o : (KeyedLazyInstance[])ModelSerializer.EP_NAME.getExtensions()) {
            if (!((ModelSerializer)o.getInstance()).canSerialize(model)) continue;
            return (ModelSerializer)o.getInstance();
        }
        return null;
    }

    public void serializeHeader(Project project, @NotNull HierarchicalStreamWriter serializer, @NotNull SaveMode mode) {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/database/dataSource/DataSource", "serializeHeader"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/DataSource", "serializeHeader"));
        }
        if (mode.includeConfig()) {
            serializer.addAttribute("source", this.getSourceName());
        }
        serializer.addAttribute("name", StringUtil.notNullize((String)this.myName));
        if (mode.includeConfig() && this.myReadOnly) {
            serializer.addAttribute("read-only", String.valueOf(this.myReadOnly));
        }
        serializer.addAttribute("uuid", StringUtil.notNullize((String)this.myUUID));
        if (mode.includeDatabaseInfo()) {
            serializer.startNode("database-info");
            serializer.addAttribute("product", StringUtil.notNullize((String)this.myInfo.myProductName));
            serializer.addAttribute("version", StringUtil.notNullize((String)this.myInfo.myProductVersion));
            serializer.addAttribute("jdbc-version", StringUtil.notNullize((String)this.myInfo.myJDBCVersion));
            serializer.addAttribute("driver-name", StringUtil.notNullize((String)this.myInfo.myDriverName));
            serializer.addAttribute("driver-version", StringUtil.notNullize((String)this.myInfo.myDriverVersion));
            if (this.myInfo.myExtraNameCharacters != null) {
                DataSource.writeTag(serializer, "extra-name-characters", this.myInfo.myExtraNameCharacters);
            }
            if (this.myInfo.myIdentifierQuoteString != null) {
                DataSource.writeTag(serializer, "identifier-quote-string", this.myInfo.myIdentifierQuoteString);
            }
            serializer.endNode();
            if (this.myInfo.myCasing.plain != DasUtil.CASING_MIXED.plain || this.myInfo.myCasing.quoted != DasUtil.CASING_MIXED.quoted) {
                serializer.startNode("case-sensitivity");
                serializer.addAttribute("plain-identifiers", StringUtil.toLowerCase((String)this.myInfo.myCasing.plain.name()));
                serializer.addAttribute("quoted-identifiers", StringUtil.toLowerCase((String)this.myInfo.myCasing.quoted.name()));
                serializer.endNode();
            }
        }
        this.serializeHeaderInner(project, serializer, mode);
    }

    protected void serializeHeaderInner(@Nullable Project project, HierarchicalStreamWriter serializer, SaveMode mode) {
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSource", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.myComment;
    }

    public void setComment(@Nullable String comment) {
        this.myComment = comment;
    }

    @Override
    public String getDatabaseProductName() {
        return this.myInfo.myProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.myInfo.myProductVersion;
    }

    public String getJDBCVersion() {
        return this.myInfo.myJDBCVersion;
    }

    public String getDriverName() {
        return this.myInfo.myDriverName;
    }

    public String getDriverVersion() {
        return this.myInfo.myDriverVersion;
    }

    public Casing getCaseModes() {
        return this.myInfo.myCasing;
    }

    public void init() {
        if (this.myUUID == null) {
            this.myUUID = UUID.randomUUID().toString();
        }
    }

    @Override
    @NotNull
    public DasModel getModel() {
        DasModel dasModel = this.myState;
        if (dasModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSource", "getModel"));
        }
        return dasModel;
    }

    protected void releaseConnection(Project project, @Nullable Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract boolean refreshMetaData(Project var1, @NotNull LoaderContext var2);

    public void updateState(final @NotNull DasModel state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DataSource", "updateState"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                DataSource.this.myState = state;
                DataSource.this.incModificationCount();
                ReflectionHelper.tryInvokeMethod((Object)state, (String)"setCasing", (Class[])new Class[]{Casing.class}, (Object[])new Object[]{((DataSource)DataSource.this).myInfo.myCasing});
            }
        });
    }

    public void refreshDatabaseInfo(@NotNull DatabaseMetaData metaData) throws SQLException {
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/DataSource", "refreshDatabaseInfo"));
        }
        this.myInfo.myProductName = metaData.getDatabaseProductName();
        this.myInfo.myProductVersion = metaData.getDatabaseProductVersion();
        this.myInfo.myDriverName = metaData.getDriverName();
        this.myInfo.myDriverVersion = metaData.getDriverVersion();
        try {
            this.myInfo.myJDBCVersion = metaData.getJDBCMajorVersion() + "." + metaData.getJDBCMinorVersion();
        }
        catch (Throwable e) {
            try {
                metaData.getConnection();
                this.myInfo.myJDBCVersion = "2.1";
            }
            catch (Throwable e1) {
                this.myInfo.myJDBCVersion = "1.2";
            }
        }
        try {
            this.myInfo.myIdentifierQuoteString = metaData.getIdentifierQuoteString();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.myInfo.myExtraNameCharacters = metaData.getExtraNameCharacters();
        }
        catch (SQLException e) {
            // empty catch block
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myInfo.myIdentifierQuoteString)) {
            this.myInfo.myIdentifierQuoteString = null;
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myInfo.myExtraNameCharacters)) {
            this.myInfo.myExtraNameCharacters = null;
        }
        try {
            boolean supportsMixedCase = metaData.supportsMixedCaseIdentifiers();
            boolean storesUpperCase = metaData.storesUpperCaseIdentifiers();
            boolean storesLowerCase = metaData.storesLowerCaseIdentifiers();
            boolean storesMixedCase = metaData.storesMixedCaseIdentifiers();
            boolean supportsMixedCaseQuoted = metaData.supportsMixedCaseQuotedIdentifiers();
            boolean storesUpperCaseQuoted = metaData.storesUpperCaseQuotedIdentifiers();
            boolean storesLowerCaseQuoted = metaData.storesLowerCaseQuotedIdentifiers();
            boolean storesMixedCaseQuoted = metaData.storesMixedCaseQuotedIdentifiers();
            Case plain = this.grokCaseMode(supportsMixedCase, storesLowerCase, storesUpperCase, storesMixedCase);
            Case quoted = this.grokCaseMode(supportsMixedCaseQuoted, storesLowerCaseQuoted, storesUpperCaseQuoted, storesMixedCaseQuoted);
            this.myInfo.myCasing = Casing.create(plain, quoted);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyDatabaseInfo(@NotNull DataSource other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/dataSource/DataSource", "copyDatabaseInfo"));
        }
        this.myInfo.copyFrom(other.myInfo);
    }

    @NotNull
    private Case grokCaseMode(boolean sensitive, boolean forceLower, boolean forceUpper, boolean asIs) {
        DatabaseFamilyId familyId = DatabaseFamilyId.forDataSource(this);
        if (sensitive && asIs) {
            if (familyId.isSqlite() || familyId.isMicrosoft()) {
                Case case_ = Case.MIXED;
                if (case_ == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSource", "grokCaseMode"));
                }
                return case_;
            }
            Case case_ = Case.EXACT;
            if (case_ == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSource", "grokCaseMode"));
            }
            return case_;
        }
        if (asIs && familyId.isSybase()) {
            Case case_ = Case.EXACT;
            if (case_ == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSource", "grokCaseMode"));
            }
            return case_;
        }
        Case case_ = sensitive ? Case.EXACT : (forceLower ? Case.LOWER : (forceUpper ? Case.UPPER : Case.MIXED));
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSource", "grokCaseMode"));
        }
        return case_;
    }

    protected boolean shouldIncludeElement(DasObject element) {
        return true;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DataSource", "setName"));
        }
        this.myName = name;
    }

    public abstract String getSourceName();

    @Nullable
    public String quoteIdentifierIfNeeded(@Nullable String identifier) {
        if (this.myInfo.myIdentifierQuoteString == null || identifier == null) {
            return identifier;
        }
        if (identifier.startsWith(this.myInfo.myIdentifierQuoteString)) {
            return identifier;
        }
        int len = identifier.length();
        for (int i = 0; i < len; ++i) {
            char c = identifier.charAt(i);
            if ((i != 0 || StringUtil.isJavaIdentifierStart((char)c)) && (i <= 0 || StringUtil.isJavaIdentifierPart((char)c)) || this.myInfo.myExtraNameCharacters != null && this.myInfo.myExtraNameCharacters.indexOf(c) != -1) continue;
            return this.quoteIdentifier(identifier);
        }
        return identifier;
    }

    @Nullable
    public String quoteIdentifier(@Nullable String identifier) {
        if (this.myInfo.myIdentifierQuoteString == null || identifier == null) {
            return identifier;
        }
        return this.myInfo.myIdentifierQuoteString + identifier + this.myInfo.myIdentifierQuoteString;
    }

    static void serializeAttribute(@NotNull HierarchicalStreamWriter serializer, String name, @Nullable String value, boolean allowEmpty) {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/database/dataSource/DataSource", "serializeAttribute"));
        }
        if (value != null && (allowEmpty || !value.isEmpty())) {
            try {
                serializer.addAttribute(name, Base64.encode((byte[])value.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public static void writeTag(@NotNull HierarchicalStreamWriter serializer, String name, String value) {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/database/dataSource/DataSource", "writeTag"));
        }
        if (StringUtil.isEmpty((String)value)) {
            return;
        }
        serializer.startNode(name);
        serializer.setValue(value);
        serializer.endNode();
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": " + this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSource", "toString"));
        }
        return string;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }

    static class Info {
        String myProductName;
        String myProductVersion;
        String myJDBCVersion;
        @Nullable
        String myIdentifierQuoteString;
        @Nullable
        String myExtraNameCharacters;
        String myDriverName;
        String myDriverVersion;
        Casing myCasing = DasUtil.CASING_MIXED;

        Info() {
        }

        void copyFrom(@NotNull Info info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dataSource/DataSource$Info", "copyFrom"));
            }
            this.myProductName = info.myProductName;
            this.myProductVersion = info.myProductVersion;
            this.myJDBCVersion = info.myJDBCVersion;
            this.myIdentifierQuoteString = info.myIdentifierQuoteString;
            this.myExtraNameCharacters = info.myExtraNameCharacters;
            this.myDriverName = info.myDriverName;
            this.myDriverVersion = info.myDriverVersion;
            this.myCasing = info.myCasing;
        }
    }

    public static enum SaveMode {
        ALL,
        CONFIG,
        LOCAL_CONFIG,
        SCHEMA;


        public boolean includeSchema() {
            return this == ALL || this == SCHEMA;
        }

        public boolean includeConfig() {
            return this == ALL || this == CONFIG;
        }

        public boolean includeLocalConfig() {
            return this == ALL || this == LOCAL_CONFIG;
        }

        public boolean includeDatabaseInfo() {
            return this.includeSchema();
        }
    }
}

