/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakStringInterner;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbUtil {
    private static final WeakStringInterner INTERNER = new WeakStringInterner();
    public static final Function<DbElement, Object> TO_DELEGATE = new Function<DbElement, Object>(){

        public Object fun(DbElement e) {
            return e.getDelegate();
        }
    };

    private DbUtil() {
    }

    @Contract(value="!null->!null")
    public static String intern2(@Nullable String str) {
        return str == null ? null : INTERNER.intern(str);
    }

    @NotNull
    public static String intern(@Nullable String str) {
        String string = DbUtil.intern(str, "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbUtil", "intern"));
        }
        return string;
    }

    @Contract(value="_, !null->!null")
    public static String intern(@Nullable String str, @Nullable String def) {
        return str == null || str.isEmpty() ? def : INTERNER.intern(str);
    }

    public static Set<String> getExistingDataSourceNames(Project project) {
        THashSet result = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (DbDataSource dataSource : DbPsiFacade.getInstance(project).getDataSources()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)dataSource.getName());
        }
        return result;
    }

    public static String createNewDataSourceName(@NotNull Project project, @NotNull String baseName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/util/DbUtil", "createNewDataSourceName"));
        }
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/database/util/DbUtil", "createNewDataSourceName"));
        }
        return DbUtil.createNewDataSourceName(baseName, DbUtil.getExistingDataSourceNames(project));
    }

    public static String createNewDataSourceName(@NotNull String baseName, Set<String> existingNames) {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/database/util/DbUtil", "createNewDataSourceName"));
        }
        Matcher matcher = Pattern.compile("([^\\[]*)(?:\\[\\d+])?").matcher(baseName);
        String fixedName = matcher.matches() ? matcher.group(1).trim() : baseName;
        return new UniqueNameGenerator(existingNames, FunctionUtil.id()).generateUniqueName(fixedName, "", "", " [", "]");
    }

    public static boolean isCaseSensitive(@Nullable String name, @NotNull DbElement source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/util/DbUtil", "isCaseSensitive"));
        }
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        Casing modes = source.getDataSource().getModel().getCasing(source.getKind(), source);
        return DbUtil.isCaseSensitive(name, modes);
    }

    public static boolean isCaseSensitive(@Nullable String name, Casing modes) {
        return Case.guessForName(name, null, modes.plain, modes.quoted) == Case.EXACT;
    }

    @NotNull
    public static String[] intern(@NotNull String[] arr) {
        if (arr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arr", "com/intellij/database/util/DbUtil", "intern"));
        }
        String[] stringArray = (String[])ContainerUtil.map((Object[])arr, (Function)new Function<String, String>(){

            public String fun(String str) {
                return DbUtil.intern(str, null);
            }
        }, (Object[])ArrayUtil.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbUtil", "intern"));
        }
        return stringArray;
    }
}

