/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.ws.references.WSReference;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.constants.RSConstants;
import com.intellij.ws.rest.references.RestMimePsiElement;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MimeReference
extends WSReference<PsiLiteralExpression> {
    @NonNls
    static final Pattern MIME_PATTERN = Pattern.compile("[^\\p{Cc}^\\s]+/[^\\p{Cc}^\\s]+");

    public MimeReference(@NotNull PsiLiteralExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/rest/references/MimeReference", "<init>"));
        }
        super((PsiElement)element);
    }

    public MimeReference(PsiLiteralExpression element, TextRange range) {
        super((PsiElement)element, range);
    }

    public PsiElement resolve() {
        String value = this.getValue();
        if (!MIME_PATTERN.matcher(value).matches()) {
            return null;
        }
        return new RestMimePsiElement((PsiLiteralExpression)this.getElement());
    }

    @NotNull
    public Object[] getVariants() {
        if (RSConstants.PREDEFINED_MIME_TYPES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/MimeReference", "getVariants"));
        }
        return RSConstants.PREDEFINED_MIME_TYPES;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = RSBundle.message("webservices.inspections.rest.annotation.has.wrong.mime.type.problem", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/references/MimeReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof RestMimePsiElement;
    }
}

