/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.cloud;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentDeployment;
import com.intellij.javaee.heroku.cloud.HerokuBashSessionHelper;
import com.intellij.javaee.heroku.cloud.HerokuDebugConnectionDelegate;
import com.intellij.javaee.heroku.cloud.HerokuDebugConnectionProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class HerokuArtifactDeploymentRuntime
extends CloudDeploymentRuntime
implements HerokuDebugConnectionProvider {
    private File myArtifactFile;
    private final HerokuDebugConnectionDelegate myDebugConnectionDelegate;
    private final HerokuBashSessionHelper myBashSessionHelper;

    public HerokuArtifactDeploymentRuntime(CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentSource source, File artifactFile, DeploymentTask<? extends CloudDeploymentNameConfiguration> task, @Nullable DeploymentLogManager logManager) throws ServerRuntimeException {
        super(serverRuntime, source, task, logManager);
        this.myArtifactFile = artifactFile;
        this.myDebugConnectionDelegate = new HerokuDebugConnectionDelegate(task, this.getDeployment(), this.getAgentTaskExecutor());
        this.myBashSessionHelper = new HerokuBashSessionHelper(this);
    }

    public HerokuCloudAgentDeployment getDeployment() {
        return (HerokuCloudAgentDeployment)super.getDeployment();
    }

    public CloudRemoteApplication deploy() throws ServerRuntimeException {
        UsageTrigger.trigger((String)"heroku.deploy");
        this.myDebugConnectionDelegate.checkDebugMode();
        final HerokuCloudAgentDeployment deployment = this.getDeployment();
        CloudGitApplication result = (CloudGitApplication)this.getAgentTaskExecutor().execute((Computable)new Computable<CloudGitApplication>(){

            public CloudGitApplication compute() {
                deployment.deployWar(HerokuArtifactDeploymentRuntime.this.myArtifactFile);
                return deployment.findApplication();
            }
        });
        if (result == null) {
            throw new ServerRuntimeException("Application not found");
        }
        deployment.startListeningLog(this.getLoggingHandler());
        this.myBashSessionHelper.setupHyperlink();
        return result;
    }

    public void undeploy() throws ServerRuntimeException {
        UsageTrigger.trigger((String)"heroku.undeploy");
        super.undeploy();
        this.getDeployment().stopListeningLog();
    }

    @Override
    public JavaDebugConnectionData getDebugConnectionData() throws ServerRuntimeException {
        return this.myDebugConnectionDelegate.getDebugConnectionData();
    }
}

