/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.cloud;

import com.intellij.javaee.heroku.cloud.HerokuCloudConfiguration;
import com.intellij.javaee.heroku.cloud.HerokuDeploymentConfiguration;
import com.intellij.javaee.heroku.cloud.HerokuServerRuntimeInstance;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryDescription;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import com.intellij.util.ThrowableRunnable;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class HerokuConnector
extends ServerConnector<HerokuDeploymentConfiguration> {
    private static final Logger LOG = Logger.getInstance(HerokuConnector.class);
    public static final ClientLibraryDescription HEROKU = new ClientLibraryDescription("heroku-138", HerokuConnector.class.getResource("/resources/HerokuClientLib.xml"));
    private final RemoteServer<HerokuCloudConfiguration> myServer;
    private final ServerTaskExecutor myTasksExecutor;

    public HerokuConnector(RemoteServer<HerokuCloudConfiguration> server, ServerTaskExecutor tasksExecutor) {
        this.myServer = server;
        this.myTasksExecutor = tasksExecutor;
    }

    public void connect(final @NotNull ServerConnector.ConnectionCallback<HerokuDeploymentConfiguration> callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/heroku/cloud/HerokuConnector", "connect"));
        }
        this.myTasksExecutor.submit((ThrowableRunnable)new ThrowableRunnable<Throwable>(){

            public void run() throws Throwable {
                List clientLibrary;
                try {
                    clientLibrary = ClientLibraryManager.getInstance().download(HEROKU);
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    callback.errorOccurred("Failed to download client libraries: " + e.getMessage());
                    return;
                }
                new HerokuServerRuntimeInstance((RemoteServer<HerokuCloudConfiguration>)HerokuConnector.this.myServer, HerokuConnector.this.myTasksExecutor, clientLibrary).connect(callback);
            }
        }, callback);
    }
}

