/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.beaInstallation;

import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicInstallationBase;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersion;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicModel;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;

public class Weblogic9Installation
extends WeblogicInstallationBase {
    @NonNls
    private static final String REGISTRY_XML = "registry.xml";
    @NonNls
    private static final String HOST_ELEMENT_NAME = "host";
    @NonNls
    private static final String PRODUCT_ELEMENT_NAME = "product";
    @NonNls
    private static final String RELEASE_ELEMENT_NAME = "release";
    @NonNls
    private static final String JAVA_HOME_ATTR = "JavaHome";
    @NonNls
    private static final String INSTALL_DIR_ATTR = "InstallDir";
    @NonNls
    private static final String COMPONENT_ELEMENT_NAME = "component";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String NAME_ATTR = "name";
    @NonNls
    private static final List<String> WEBLOGIC_COMPONENT_NAMES = Arrays.asList("WebLogic Server", "WebLogic Server TP");

    protected Weblogic9Installation(String home) {
        super(home, REGISTRY_XML);
    }

    @Override
    protected List<WeblogicVersion> doGetVersions() throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument((File)this.getStampFile());
        Element rootElement = document.getRootElement();
        ArrayList<WeblogicVersion> result = new ArrayList<WeblogicVersion>();
        ArrayList products = new ArrayList();
        List hosts = JDOMUtil.getChildren((Element)rootElement, (String)HOST_ELEMENT_NAME);
        for (Element host : hosts) {
            products.addAll(JDOMUtil.getChildren((Element)host, (String)PRODUCT_ELEMENT_NAME));
        }
        ArrayList releases = new ArrayList();
        for (Element product : products) {
            releases.addAll(JDOMUtil.getChildren((Element)product, (String)RELEASE_ELEMENT_NAME));
        }
        for (Element release : releases) {
            String version = null;
            String installDir = null;
            List components = JDOMUtil.getChildren((Element)release, (String)COMPONENT_ELEMENT_NAME);
            for (Element component : components) {
                if (!WEBLOGIC_COMPONENT_NAMES.contains(component.getAttributeValue(NAME_ATTR))) continue;
                version = component.getAttributeValue(VERSION_ATTR);
                installDir = component.getAttributeValue(INSTALL_DIR_ATTR);
                break;
            }
            if (version == null || !WeblogicModel.isVersion9OrLater(new Version(version))) continue;
            if (installDir == null) {
                installDir = release.getAttributeValue(INSTALL_DIR_ATTR);
            }
            String javaHome = release.getAttributeValue(JAVA_HOME_ATTR);
            result.add(new WeblogicVersion(version, installDir, javaHome));
        }
        return result;
    }
}

