/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.module;

import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.weblogic.model.WeblogicEjbJar;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsJar;
import com.intellij.javaee.weblogic.module.WLDeploymentDecriptorsConstants;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeblogicEjbFacetUtil {
    @NonNls
    private static final String WL9_NAMESPACE = "http://www.bea.com/ns/weblogic/90";

    private WeblogicEjbFacetUtil() {
    }

    public static boolean isVersion9x(@Nullable EjbFacet ejbFacet) {
        XmlFile xmlFile;
        ConfigFile descriptor;
        if (ejbFacet != null && (descriptor = WeblogicEjbFacetUtil.getCmpRdbmsDescriptor(ejbFacet)) != null && (xmlFile = descriptor.getXmlFile()) != null) {
            return WeblogicEjbFacetUtil.isVersion9x(xmlFile);
        }
        return false;
    }

    public static boolean isVersion9x(XmlFile xmlFile) {
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return false;
        }
        XmlTag rootTag = document.getRootTag();
        return rootTag != null && WL9_NAMESPACE.equals(rootTag.getNamespace());
    }

    @Nullable
    public static ConfigFile getEjbJarDeploymentDescriptor(@NotNull EjbFacet ejbFacet) {
        if (ejbFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ejbFacet", "com/intellij/javaee/weblogic/module/WeblogicEjbFacetUtil", "getEjbJarDeploymentDescriptor"));
        }
        return ejbFacet.getDescriptorsContainer().getConfigFile(WLDeploymentDecriptorsConstants.WL_EJB_JAR_XML_META_DATA);
    }

    @Nullable
    public static ConfigFile getCmpRdbmsDescriptor(@NotNull EjbFacet ejbFacet) {
        if (ejbFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ejbFacet", "com/intellij/javaee/weblogic/module/WeblogicEjbFacetUtil", "getCmpRdbmsDescriptor"));
        }
        return ejbFacet.getDescriptorsContainer().getConfigFile(WLDeploymentDecriptorsConstants.WL_CMP_RDMS_XML_META_DATA);
    }

    @Nullable
    public static WeblogicRdbmsJar getRdbmsRoot(@NotNull EjbFacet ejbFacet) {
        if (ejbFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ejbFacet", "com/intellij/javaee/weblogic/module/WeblogicEjbFacetUtil", "getRdbmsRoot"));
        }
        ConfigFile descriptor = WeblogicEjbFacetUtil.getCmpRdbmsDescriptor(ejbFacet);
        if (descriptor == null) {
            return null;
        }
        XmlFile file = descriptor.getXmlFile();
        if (file == null) {
            return null;
        }
        DomFileElement domFileElement = DomManager.getDomManager((Project)file.getProject()).getFileElement(file, WeblogicRdbmsJar.class);
        if (domFileElement == null) {
            return null;
        }
        return (WeblogicRdbmsJar)domFileElement.getRootElement();
    }

    @Nullable
    public static WeblogicEjbJar getEjbRoot(@NotNull EjbFacet ejbFacet) {
        if (ejbFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ejbFacet", "com/intellij/javaee/weblogic/module/WeblogicEjbFacetUtil", "getEjbRoot"));
        }
        ConfigFile descriptor = WeblogicEjbFacetUtil.getEjbJarDeploymentDescriptor(ejbFacet);
        if (descriptor == null) {
            return null;
        }
        XmlFile file = descriptor.getXmlFile();
        if (file == null) {
            return null;
        }
        DomFileElement domFileElement = DomManager.getDomManager((Project)file.getProject()).getFileElement(file, WeblogicEjbJar.class);
        if (domFileElement == null) {
            return null;
        }
        return (WeblogicEjbJar)domFileElement.getRootElement();
    }
}

