/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.jam;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceItemsConverter
extends JamConverter<Collection<PsiFileSystemItem>> {
    @Nullable
    public Collection<PsiFileSystemItem> fromString(@Nullable String s, JamStringAttributeElement<Collection<PsiFileSystemItem>> context) {
        return SpringResourcesUtil.getInstance().getResourceItems(this.createReferences(context), Conditions.alwaysTrue());
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<Collection<PsiFileSystemItem>> context) {
        PsiLiteral literal = context.getPsiLiteral();
        if (literal == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/jam/ResourceItemsConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String s = context.getStringValue();
        if (s == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/jam/ResourceItemsConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SpringResourcesBuilder resourcesBuilder = SpringResourcesBuilder.create((PsiElement)literal, (String)s).fromRoot(s.startsWith("/")).soft(true);
        PsiReference[] psiReferenceArray = SpringResourcesUtil.getInstance().getReferences(resourcesBuilder);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/jam/ResourceItemsConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

