/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.google.gson.stream.JsonToken;
import com.jetbrains.firefox.FirefoxArray;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxFunction;
import com.jetbrains.firefox.FirefoxObject;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxValueManager$WhenMappings;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Grip;
import com.jetbrains.firefox.rdp.PropertyDescriptor;
import com.jetbrains.firefox.rdp.SafeGetterValue;
import com.jetbrains.firefox.rdp.ValueHolder;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.ObjectPropertyImpl;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.debugger.values.VmAwareValueManager;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016JB\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0011J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J&\u0010\u001d\u001a\u0004\u0018\u00010\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020#J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010\u0014H\u0002J\"\u0010'\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u00142\b\u0010(\u001a\u0004\u0018\u00010)J&\u0010*\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/firefox/FirefoxValueManager;", "Lorg/jetbrains/debugger/values/VmAwareValueManager;", "Lcom/jetbrains/firefox/FirefoxVm;", "vm", "(Lcom/jetbrains/firefox/FirefoxVm;)V", "actorsNotYetPromotedToThreadLifetime", "Ljava/util/ArrayList;", "", "refToValue", "Lgnu/trove/THashMap;", "Lorg/jetbrains/debugger/values/Value;", "clearCaches", "", "createProperties", "", "Lorg/jetbrains/debugger/Variable;", "propertyDescriptors", "", "Lcom/jetbrains/firefox/rdp/PropertyDescriptor;", "prototypeGrip", "Lcom/jetbrains/firefox/rdp/Grip;", "safeGetterValues", "Lcom/jetbrains/firefox/rdp/SafeGetterValue;", "createProperty", "name", "descriptor", "getterValueDescriptor", "createProtoVariable", "Lorg/jetbrains/debugger/VariableImpl;", "createValue", "valueData", "primitiveValue", "primitiveValueType", "Lcom/google/gson/stream/JsonToken;", "valueHolder", "Lcom/jetbrains/firefox/rdp/ValueHolder;", "createValueAccessor", "Lorg/jetbrains/debugger/values/FunctionValue;", "grip", "createVariable", "valueModifier", "Lorg/jetbrains/debugger/ValueModifier;", "doCreateValue", "promoteRecentlyAddedActorsToThreadLifetime", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "release", "FirefoxConnector"})
public final class FirefoxValueManager
extends VmAwareValueManager<FirefoxVm> {
    private final THashMap<String, Value> refToValue;
    private final ArrayList<String> actorsNotYetPromotedToThreadLifetime;

    @NotNull
    public final List<Variable> createProperties(@Nullable Map<String, ? extends PropertyDescriptor> propertyDescriptors, @Nullable Grip prototypeGrip, @Nullable Map<String, ? extends SafeGetterValue> safeGetterValues) {
        VariableImpl prototype;
        VariableImpl variableImpl = prototype = prototypeGrip == null ? (VariableImpl)null : this.createProtoVariable(prototypeGrip);
        if (propertyDescriptors == null || propertyDescriptors.isEmpty()) {
            return prototype == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)prototype);
        }
        Variable[] variables = new Variable[propertyDescriptors.size() + (prototype == null ? 0 : 1)];
        int i = 0;
        for (Map.Entry<String, ? extends PropertyDescriptor> entry : propertyDescriptors.entrySet()) {
            String name = entry.getKey();
            int n = i++;
            Map<String, ? extends SafeGetterValue> map = safeGetterValues;
            variables[n] = this.createProperty(name, entry.getValue(), map != null ? map.get(name) : null);
        }
        if (prototype != null) {
            variables[((Object[])variables).length - 1] = (Variable)prototype;
        }
        List<Variable> list = Arrays.asList(Arrays.copyOf(variables, variables.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList<Variable>(*variables)");
        return list;
    }

    @NotNull
    public final VariableImpl createProtoVariable(@Nullable Grip prototypeGrip) {
        return this.createVariable("__proto__", prototypeGrip, null);
    }

    @NotNull
    public final Variable createProperty(@NotNull String name, @NotNull PropertyDescriptor descriptor, @Nullable SafeGetterValue getterValueDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        int flags = 0;
        if (descriptor.writable()) {
            flags |= 1;
        }
        if (descriptor.configurable()) {
            flags |= 2;
        }
        if (descriptor.enumerable()) {
            flags |= 4;
        }
        SafeGetterValue safeGetterValue = getterValueDescriptor;
        return (Variable)new ObjectPropertyImpl(name, this.createValue(safeGetterValue != null ? (ValueHolder)safeGetterValue : (ValueHolder)descriptor), getterValueDescriptor == null ? this.createValueAccessor(descriptor.get()) : (FunctionValue)null, getterValueDescriptor == null ? this.createValueAccessor(descriptor.set()) : (FunctionValue)null, (ValueModifier)null, flags);
    }

    private final FunctionValue createValueAccessor(Grip grip) {
        if (grip == null || grip.type() == Grip.Type.UNDEFINED) {
            return null;
        }
        Value value = this.createValue(grip, null, null);
        return value instanceof FunctionValue ? (FunctionValue)value : (FunctionValue)null;
    }

    @NotNull
    public final VariableImpl createVariable(@NotNull String name, @Nullable Grip valueData, @Nullable ValueModifier valueModifier) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new VariableImpl(name, this.createValue(valueData, null, null), valueModifier);
    }

    @Nullable
    public final Value createValue(@NotNull ValueHolder valueHolder) {
        Intrinsics.checkParameterIsNotNull((Object)valueHolder, (String)"valueHolder");
        return this.createValue(valueHolder.value(), valueHolder.primitiveValue(), valueHolder.primitiveValueType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final Value createValue(@Nullable Grip valueData, @Nullable String primitiveValue, @Nullable JsonToken primitiveValueType) {
        void lock$iv;
        if (valueData == null && primitiveValue == null) {
            return null;
        }
        Object object = valueData;
        if (object == null || (object = object.actor()) == null) {
            return this.doCreateValue(valueData, primitiveValue, primitiveValueType);
        }
        Object actor = object;
        THashMap<String, Value> tHashMap = this.refToValue;
        synchronized (lock$iv) {
            Value value = (Value)this.refToValue.get(actor);
            if (value == null) {
                value = this.doCreateValue(valueData, primitiveValue, primitiveValueType);
                this.refToValue.put(actor, (Object)value);
                this.actorsNotYetPromotedToThreadLifetime.add((String)actor);
            }
            Value value2 = value;
            return value2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Void> promoteRecentlyAddedActorsToThreadLifetime() {
        THashMap<String, Value> lock$iv = this.refToValue;
        synchronized (lock$iv) {
            void var2_3;
            block5: {
                if (!this.actorsNotYetPromotedToThreadLifetime.isEmpty()) break block5;
                Promise promise = Promise.DONE;
                Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.DONE");
                Promise promise2 = promise;
                return promise2;
            }
            FirefoxCommandProcessor firefoxCommandProcessor = ((FirefoxVm)this.getVm()).getCommandProcessor();
            String string = ((FirefoxVm)this.getVm()).getThreadActor();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.pauseLifetimeGripsToThreadLifetime(string, (List<String>)this.actorsNotYetPromotedToThreadLifetime));
            this.actorsNotYetPromotedToThreadLifetime.clear();
            void var6_4 = var2_3;
            return var6_4;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Value doCreateValue(Grip valueData, String primitiveValue, JsonToken primitiveValueType) {
        Unit unit;
        if (primitiveValue != null) {
            Unit unit2;
            boolean bl = primitiveValueType != null;
            if (_Assertions.ENABLED) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv$iv = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
            JsonToken jsonToken = primitiveValueType;
            if (jsonToken != null) {
                switch (FirefoxValueManager$WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                    case 1: {
                        ValueType valueType = ValueType.STRING;
                        return (Value)new PrimitiveValue(valueType, primitiveValue);
                    }
                    case 2: {
                        ValueType valueType = ValueType.NUMBER;
                        return (Value)new PrimitiveValue(valueType, primitiveValue);
                    }
                    case 3: {
                        Value value = (Value)PrimitiveValue.bool((String)primitiveValue);
                        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"PrimitiveValue.bool(primitiveValue)");
                        return value;
                    }
                    case 4: {
                        Value value = (Value)PrimitiveValue.NULL;
                        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"PrimitiveValue.NULL");
                        return value;
                    }
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append("Unsupported type ");
            JsonToken jsonToken2 = primitiveValueType;
            if (jsonToken2 != null) throw (Throwable)new UnsupportedOperationException(stringBuilder.append(jsonToken2).toString());
            Intrinsics.throwNpe();
            throw (Throwable)new UnsupportedOperationException(stringBuilder.append(jsonToken2).toString());
        }
        boolean valueType = valueData != null;
        if (_Assertions.ENABLED) {
            void value$iv;
            if (value$iv == false) {
                String message$iv$iv = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Grip grip = valueData;
        if (grip == null) {
            Intrinsics.throwNpe();
        }
        Grip.Type type = grip.type();
        if (type == null) {
            throw (Throwable)new UnsupportedOperationException();
        }
        switch (FirefoxValueManager$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                ValueType valueType2 = null;
                Grip.Preview preview = valueData.preview();
                if (preview != null) {
                    if (preview.kind() == Grip.Preview.Kind.DOM_NODE) {
                        valueType2 = ValueType.NODE;
                    } else if (preview.kind() == Grip.Preview.Kind.ARRAY_LIKE) {
                        if (preview.length() != -1) return (Value)new FirefoxArray(preview.length(), valueData, this);
                        valueType2 = ValueType.ARRAY;
                    }
                }
                if (valueType2 != null) return (Value)new FirefoxObject(valueType2, valueData, this);
                if (Intrinsics.areEqual((Object)"Array", (Object)valueData.className())) {
                    valueType2 = ValueType.ARRAY;
                    return (Value)new FirefoxObject(valueType2, valueData, this);
                }
                if (Intrinsics.areEqual((Object)"Function", (Object)valueData.className())) {
                    return (Value)new FirefoxFunction(valueData, this);
                }
                valueType2 = ValueType.OBJECT;
                return (Value)new FirefoxObject(valueType2, valueData, this);
            }
            case 2: {
                Value value = (Value)PrimitiveValue.NAN;
                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"PrimitiveValue.NAN");
                return value;
            }
            case 3: {
                Value value = (Value)PrimitiveValue.INFINITY;
                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"PrimitiveValue.INFINITY");
                return value;
            }
            case 4: {
                Value value = (Value)PrimitiveValue.UNDEFINED;
                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"PrimitiveValue.UNDEFINED");
                return value;
            }
            case 5: {
                Value value = (Value)PrimitiveValue.NULL;
                Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"PrimitiveValue.NULL");
                return value;
            }
        }
        throw (Throwable)new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Void> release() {
        this.markObsolete();
        THashMap<String, Value> lock$iv = this.refToValue;
        synchronized (lock$iv) {
            void var2_3;
            block5: {
                this.actorsNotYetPromotedToThreadLifetime.clear();
                if (!this.refToValue.isEmpty()) break block5;
                Promise promise = Promise.DONE;
                Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.DONE");
                Promise promise2 = promise;
                return promise2;
            }
            FirefoxCommandProcessor firefoxCommandProcessor = ((FirefoxVm)this.getVm()).getCommandProcessor();
            String string = ((FirefoxVm)this.getVm()).getThreadActor();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Collection collection = this.refToValue.keySet();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"refToValue.keys");
            Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.release(string, collection));
            this.refToValue.clear();
            void var6_4 = var2_3;
            return var6_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        super.clearCaches();
        THashMap<String, Value> lock$iv = this.refToValue;
        synchronized (lock$iv) {
            this.refToValue.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public FirefoxValueManager(@NotNull FirefoxVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        super((Vm)vm);
        this.refToValue = new THashMap();
        this.actorsNotYetPromotedToThreadLifetime = new ArrayList();
    }
}

