/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam;

import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.xml.XmlTag;
import com.intellij.seam.highlighting.jam.SeamAnnotationIncorrectSignatureInspection;
import com.intellij.seam.highlighting.jam.SeamAnnotationsInconsistencyInspection;
import com.intellij.seam.highlighting.jam.SeamBijectionIllegalScopeParameterInspection;
import com.intellij.seam.highlighting.jam.SeamBijectionTypeMismatchInspection;
import com.intellij.seam.highlighting.jam.SeamBijectionUndefinedContextVariableInspection;
import com.intellij.seam.highlighting.jam.SeamDuplicateComponentsInspection;
import com.intellij.seam.highlighting.jam.SeamIllegalComponentScopeInspection;
import com.intellij.seam.highlighting.jam.SeamJamComponentInspection;
import com.intellij.seam.highlighting.xml.SeamDomModelInspection;
import com.intellij.seam.model.xml.components.BasicSeamComponent;
import com.intellij.seam.resources.SeamBundle;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomMetaData;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import icons.SeamIcons;
import org.jetbrains.annotations.Nullable;

public class SeamApplicationComponent
implements FileTemplateGroupDescriptorFactory,
MetaDataContributor {
    public void contributeMetaData(MetaDataRegistrar registrar) {
        registrar.registerMetaData(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                if (element instanceof XmlTag) {
                    XmlTag tag = (XmlTag)element;
                    DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
                    return domElement instanceof BasicSeamComponent;
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return XmlTag.class.isAssignableFrom(hintClass);
            }
        }, BasicSeamComponentElementMetaData.class);
    }

    public static Class[] getInspectionClasses() {
        return new Class[]{SeamDomModelInspection.class, SeamAnnotationIncorrectSignatureInspection.class, SeamAnnotationsInconsistencyInspection.class, SeamBijectionUndefinedContextVariableInspection.class, SeamBijectionIllegalScopeParameterInspection.class, SeamBijectionTypeMismatchInspection.class, SeamJamComponentInspection.class, SeamIllegalComponentScopeInspection.class, SeamDuplicateComponentsInspection.class};
    }

    public FileTemplateGroupDescriptor getFileTemplatesDescriptor() {
        FileTemplateGroupDescriptor groupDescriptor = new FileTemplateGroupDescriptor(SeamBundle.message("seam.framework.name", new Object[0]), SeamIcons.Seam);
        groupDescriptor.addTemplate(new FileTemplateDescriptor("components.1_2.xml", SeamIcons.Seam));
        groupDescriptor.addTemplate(new FileTemplateDescriptor("components.2_0.xml", SeamIcons.Seam));
        groupDescriptor.addTemplate(new FileTemplateDescriptor("pages.2_0.xml", SeamIcons.Seam));
        groupDescriptor.addTemplate(new FileTemplateDescriptor("pageflow.2_0.xml", SeamIcons.Seam));
        return groupDescriptor;
    }

    public static class BasicSeamComponentElementMetaData
    extends DomMetaData<BasicSeamComponent> {
        @Nullable
        protected GenericDomValue getNameElement(BasicSeamComponent element) {
            GenericAttributeValue<String> id = element.getName();
            if (DomUtil.hasXml(id)) {
                return id;
            }
            return null;
        }

        public void setName(String name) throws IncorrectOperationException {
            ((BasicSeamComponent)this.getElement()).getName().setStringValue(name);
        }
    }
}

