/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.impl.model.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.SeamDomModelFactory;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.model.xml.components.SeamComponents;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamDomModelManagerImpl
extends SeamDomModelManager {
    private final SeamDomModelFactory myModelFactory;
    private final GenericDomValueConvertersRegistry myValueProvidersRegistry;
    private final DomManager myDomManager;

    public SeamDomModelManagerImpl(Project project) {
        this.myDomManager = DomManager.getDomManager((Project)project);
        this.myModelFactory = new SeamDomModelFactory(project);
        this.myValueProvidersRegistry = new GenericDomValueConvertersRegistry();
        this.myValueProvidersRegistry.registerDefaultConverters();
    }

    @Override
    public boolean isSeamComponents(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/seam/impl/model/xml/SeamDomModelManagerImpl", "isSeamComponents"));
        }
        return this.myDomManager.getFileElement(file, SeamComponents.class) != null;
    }

    @Override
    @Nullable
    public SeamDomModel getSeamModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/seam/impl/model/xml/SeamDomModelManagerImpl", "getSeamModel"));
        }
        return (SeamDomModel)this.myModelFactory.getModelByConfigFile(file);
    }

    @Override
    @Nullable
    public SeamDomModel getCombinedSeamModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/seam/impl/model/xml/SeamDomModelManagerImpl", "getCombinedSeamModel"));
        }
        return (SeamDomModel)this.myModelFactory.getCombinedModel((UserDataHolder)module);
    }

    @Override
    public List<SeamDomModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/seam/impl/model/xml/SeamDomModelManagerImpl", "getAllModels"));
        }
        return this.myModelFactory.getAllModels((UserDataHolder)module);
    }

    @Override
    public GenericDomValueConvertersRegistry getValueConvertersRegistry() {
        return this.myValueProvidersRegistry;
    }
}

