/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.watcher;

import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.stylus.StylusFileType;
import org.jetbrains.plugins.stylus.psi.StylusFile;

public class StylusTaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(PsiFile file) {
        return file instanceof StylusFile;
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName(StylusFileType.STYLUS.getName());
        options.setDescription("Compiles .styl files into .css files");
        options.setFileExtension("styl");
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        options.setArguments("$" + new FileNameMacro().getName() + "$");
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        options.setTrackOnlyRoot(true);
        options.setOutput("$" + new FileNameWithoutExtension().getName() + "$.css");
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/watcher/StylusTaskConsumer", "getOptionsTemplate"));
        }
        return taskOptions;
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/stylus/watcher/StylusTaskConsumer", "additionalConfiguration"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "org/jetbrains/plugins/stylus/watcher/StylusTaskConsumer", "additionalConfiguration"));
        }
        super.additionalConfiguration(project, file, options);
        options.setProgram(StylusTaskConsumer.findExecutableInPath((String)(SystemInfo.isWindows ? "stylus.cmd" : "stylus")));
    }
}

