/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.j2ee.webSphere.WebSphereBundle;
import com.intellij.j2ee.webSphere.configuration.WebSphereCell;
import com.intellij.j2ee.webSphere.configuration.WebSphereNode;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfile;
import com.intellij.j2ee.webSphere.configuration.WebSphereServerConfiguration;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSphereProfileUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.webSphere.configuration.WebSphereProfileUtil");
    @NonNls
    private static final String CONFIG_DIR = "config";
    @NonNls
    private static final String CELLS_DIR = "cells";
    @NonNls
    private static final String NODES_DIR = "nodes";
    @NonNls
    private static final String LOGS_DIR = "logs";
    @NonNls
    private static final String SERVER_INDEX_XML = "serverindex.xml";
    @NonNls
    private static final String START_SERVER_FILE_NAME_BAT = "startServer.bat";
    @NonNls
    private static final String STOP_SERVER_FILE_NAME_BAT = "stopServer.bat";
    @NonNls
    private static final String START_SERVER_FILE_NAME_SH = "startServer.sh";
    @NonNls
    private static final String STOP_SERVER_FILE_NAME_SH = "stopServer.sh";
    @NonNls
    private static final String SYSTEM_OUT_LOG_NAME = "SystemOut.log";
    @NonNls
    private static final String SPECIAL_ENDPOINTS_ELEMENT_NAME = "specialEndpoints";
    @NonNls
    private static final String SERVER_ENTRIES_ELEMENT_NAME = "serverEntries";
    @NonNls
    private static final String SERVER_NAME_ATTRIBUTE_NAME = "serverName";
    @NonNls
    private static final String DEFAULT_HOST_ENDPOINT = "WC_defaulthost";
    @NonNls
    private static final String SOAP_PORT_ENDPOINT = "SOAP_CONNECTOR_ADDRESS";
    @NonNls
    private static final String ENDPOINT_ATTRIBUTE_NAME = "endPointName";
    @NonNls
    private static final String ENDPOINT_ELEMENT_NAME = "endPoint";
    @NonNls
    private static final String PORT_ATTRIBUTE_NAME = "port";
    @NonNls
    private static final String CELL_NAMESPACE_URI = "http://www.ibm.com/websphere/appserver/schemas/5.0/topology.cell.xmi";
    @NonNls
    private static final String CELL_XML_FILE = "cell.xml";
    @NonNls
    private static final String CELL_ELEMENT_NAME = "Cell";
    @NonNls
    private static final String CELL_NAME_ATTRIBUTE = "name";
    private static final Namespace CELL_NAMESPACE = Namespace.getNamespace((String)"http://www.ibm.com/websphere/appserver/schemas/5.0/topology.cell.xmi");
    @NonNls
    private static final String DEFAULT_PROFILE_NAME = "default";
    @NonNls
    private static final String NODE_XML_FILE = "node.xml";
    @NonNls
    private static final String NODE_NAMESPACE_URI = "http://www.ibm.com/websphere/appserver/schemas/5.0/topology.node.xmi";
    private static final Namespace NODE_NAMESPACE = Namespace.getNamespace((String)"http://www.ibm.com/websphere/appserver/schemas/5.0/topology.node.xmi");
    @NonNls
    private static final String NODE_NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String NODE_ELEMENT_NAME = "Node";
    @NonNls
    private static final String VIRTUALHOSTS_FILE_NAME = "virtualhosts.xml";
    @NonNls
    private static final String HOST_NAMESPACE_URI = "http://www.ibm.com/websphere/appserver/schemas/5.0/host.xmi";
    private static final Namespace HOST_NAMESPACE = Namespace.getNamespace((String)"http://www.ibm.com/websphere/appserver/schemas/5.0/host.xmi");
    @NonNls
    private static final String VIRTUAL_HOST_ELEMENT_NAME = "VirtualHost";
    @NonNls
    private static final String HOST_NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String DEFAULT_HOST_NAME = "default_host";
    @NonNls
    private static final String ALIASES_ELEMENT_NAME = "aliases";
    @NonNls
    private static final String VIRTUAL_HOST_PORT_ATTRIBUTE = "port";
    @NonNls
    public static final String SSL_CONFIG_URL_PROPERTY = "com.ibm.SSL.ConfigURL";
    @NonNls
    private static final String SSL_PROPERTIES_PATH = File.separator + "properties" + File.separator + "ssl.client.props";
    private static final String BIN_DIR = "bin";

    @NotNull
    public static WebSphereProfile[] getProfiles(WebSphereVersion version) {
        if (version.isProfilesSupported()) {
            File[] dirs;
            File profilesDir = version.getProfilesDir();
            ArrayList<WebSphereProfile> profiles = new ArrayList<WebSphereProfile>();
            for (File profileDir : dirs = WebSphereProfileUtil.getChildDirectories(profilesDir)) {
                WebSphereProfile profile = WebSphereProfileUtil.createProfile(version, profileDir);
                if (profile == null) continue;
                profiles.add(profile);
            }
            WebSphereProfile[] webSphereProfileArray = profiles.toArray(new WebSphereProfile[profiles.size()]);
            if (webSphereProfileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereProfileUtil", "getProfiles"));
            }
            return webSphereProfileArray;
        }
        WebSphereProfile profile = WebSphereProfileUtil.createProfile(version, version.getServerHome());
        if (profile != null) {
            WebSphereProfile[] webSphereProfileArray = new WebSphereProfile[]{profile};
            if (webSphereProfileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereProfileUtil", "getProfiles"));
            }
            return webSphereProfileArray;
        }
        if (WebSphereProfile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereProfileUtil", "getProfiles"));
        }
        return WebSphereProfile.EMPTY_ARRAY;
    }

    @Nullable
    public static WebSphereProfile createProfile(WebSphereVersion version, File profileDir) {
        File soapProperties;
        if (!profileDir.exists()) {
            return null;
        }
        File startupScript = new File(profileDir, BIN_DIR + File.separator + WebSphereProfileUtil.getStartServerScriptFile());
        File shutdownScriptFile = new File(profileDir, BIN_DIR + File.separator + WebSphereProfileUtil.getStopServerScriptFile());
        String profileName = version.isProfilesSupported() ? profileDir.getName() : DEFAULT_PROFILE_NAME;
        HashMap<String, String> properties = new HashMap<String, String>();
        if (version.getPresentableName().startsWith("6.1")) {
            try {
                properties.put(SSL_CONFIG_URL_PROPERTY, new File(profileDir.getAbsolutePath() + SSL_PROPERTIES_PATH).toURL().toString());
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        if ((soapProperties = new File(profileDir.getAbsolutePath() + File.separator + "properties" + File.separator + "soap.client.props")).exists()) {
            try {
                properties.put("com.ibm.SOAP.ConfigURL", soapProperties.toURL().toString());
            }
            catch (MalformedURLException e) {
                LOG.info((Throwable)e);
            }
        }
        return new WebSphereProfile(version, profileDir, profileName, startupScript, shutdownScriptFile, properties);
    }

    private static String getStopServerScriptFile() {
        return SystemInfo.isWindows ? STOP_SERVER_FILE_NAME_BAT : STOP_SERVER_FILE_NAME_SH;
    }

    private static String getStartServerScriptFile() {
        return SystemInfo.isWindows ? START_SERVER_FILE_NAME_BAT : START_SERVER_FILE_NAME_SH;
    }

    @NotNull
    private static String getNodeName(File nodeDir) {
        String string = WebSphereProfileUtil.getCellOrNodeName(nodeDir, NODE_XML_FILE, NODE_NAMESPACE, NODE_ELEMENT_NAME, "name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereProfileUtil", "getNodeName"));
        }
        return string;
    }

    @NotNull
    private static String getCellName(File cellDir) {
        String string = WebSphereProfileUtil.getCellOrNodeName(cellDir, CELL_XML_FILE, CELL_NAMESPACE, CELL_ELEMENT_NAME, "name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereProfileUtil", "getCellName"));
        }
        return string;
    }

    @NotNull
    private static String getCellOrNodeName(File dir, String xmlFile, Namespace namespace, String elementName, String nameAttribute) {
        String name = dir.getName();
        try {
            Document document = JDOMUtil.loadDocument((File)new File(dir, xmlFile));
            Element root = document.getRootElement();
            name = root.getChild(elementName, namespace).getAttributeValue(nameAttribute);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereProfileUtil", "getCellOrNodeName"));
        }
        return string;
    }

    @NotNull
    private static File[] getChildDirectories(File dir) {
        File[] dirs = dir.listFiles(FileUtilRt.ALL_DIRECTORIES);
        if (dirs == null) {
            File[] fileArray = new File[]{};
            if (fileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereProfileUtil", "getChildDirectories"));
            }
            return fileArray;
        }
        if (dirs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereProfileUtil", "getChildDirectories"));
        }
        return dirs;
    }

    public static WebSphereServerConfiguration[] getServerConfigurations(WebSphereNode node) {
        WebSphereCell cell = node.getCell();
        WebSphereVersion version = cell.getProfile().getVersion();
        File serverIndex = new File(node.getNodeDirectory(), SERVER_INDEX_XML);
        ArrayList<WebSphereServerConfiguration> servers = new ArrayList<WebSphereServerConfiguration>();
        try {
            Document document = JDOMUtil.loadDocument((File)serverIndex);
            Element root = document.getRootElement();
            List serverEntries = root.getChildren(SERVER_ENTRIES_ELEMENT_NAME);
            for (Element serverEntry : serverEntries) {
                String serverName = serverEntry.getAttributeValue(SERVER_NAME_ATTRIBUTE_NAME);
                if (serverName == null) continue;
                int soapPort = version.getDefaultSOAPPort();
                int httpPort = WebSphereProfileUtil.getDefaultHttpPort(cell);
                List endpoints = serverEntry.getChildren(SPECIAL_ENDPOINTS_ELEMENT_NAME);
                for (Element specialEndpoint : endpoints) {
                    Element endpoint;
                    if (DEFAULT_HOST_ENDPOINT.equals(specialEndpoint.getAttributeValue(ENDPOINT_ATTRIBUTE_NAME))) {
                        endpoint = specialEndpoint.getChild(ENDPOINT_ELEMENT_NAME);
                        httpPort = Integer.parseInt(endpoint.getAttributeValue("port"));
                        continue;
                    }
                    if (!SOAP_PORT_ENDPOINT.equals(specialEndpoint.getAttributeValue(ENDPOINT_ATTRIBUTE_NAME))) continue;
                    endpoint = specialEndpoint.getChild(ENDPOINT_ELEMENT_NAME);
                    soapPort = Integer.parseInt(endpoint.getAttributeValue("port"));
                }
                File systemOutLogFile = new File(cell.getProfile().getLocation(), LOGS_DIR + File.separator + serverName + File.separator + SYSTEM_OUT_LOG_NAME);
                servers.add(new WebSphereServerConfiguration(node, serverName, httpPort, soapPort, systemOutLogFile));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return servers.toArray(new WebSphereServerConfiguration[servers.size()]);
    }

    private static int getDefaultHttpPort(WebSphereCell cell) {
        int port = cell.getProfile().getVersion().getDefaultHttpPort();
        File hostsFile = new File(cell.getCellDirectory(), VIRTUALHOSTS_FILE_NAME);
        try {
            Document document = JDOMUtil.loadDocument((File)hostsFile);
            Element root = document.getRootElement();
            List hostsList = root.getChildren(VIRTUAL_HOST_ELEMENT_NAME, HOST_NAMESPACE);
            for (Element hostElement : hostsList) {
                if (!DEFAULT_HOST_NAME.equals(hostElement.getAttributeValue("name"))) continue;
                Element alias = hostElement.getChild(ALIASES_ELEMENT_NAME);
                if (alias != null) {
                    try {
                        port = Integer.parseInt(alias.getAttributeValue("port"));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public static WebSphereNode[] getNodes(WebSphereCell cell) {
        File nodesDir = new File(cell.getCellDirectory(), NODES_DIR);
        File[] nodeDirs = WebSphereProfileUtil.getChildDirectories(nodesDir);
        ArrayList<WebSphereNode> nodes = new ArrayList<WebSphereNode>();
        for (File nodeDir : nodeDirs) {
            String nodeName = WebSphereProfileUtil.getNodeName(nodeDir);
            nodes.add(new WebSphereNode(cell, nodeDir, nodeName));
        }
        return nodes.toArray(new WebSphereNode[nodes.size()]);
    }

    public static WebSphereCell[] getCells(WebSphereProfile profile) {
        File configDir = new File(profile.getLocation(), CONFIG_DIR);
        if (!configDir.exists()) {
            return WebSphereCell.EMPTY_ARRAY;
        }
        File cellsDir = new File(configDir, CELLS_DIR);
        File[] cellDirs = WebSphereProfileUtil.getChildDirectories(cellsDir);
        ArrayList<WebSphereCell> cells = new ArrayList<WebSphereCell>();
        for (File cellDir : cellDirs) {
            String cellName = WebSphereProfileUtil.getCellName(cellDir);
            cells.add(new WebSphereCell(profile, cellDir, cellName));
        }
        return cells.toArray(new WebSphereCell[cells.size()]);
    }

    @NotNull
    public static WebSphereServerConfiguration createValidServerConfiguration(WebSphereVersion version, File profileDir, String cellName, String nodeName, String serverName) throws RuntimeConfigurationException {
        WebSphereProfile profile = WebSphereProfileUtil.createProfile(version, profileDir);
        if (profile == null) {
            throw new RuntimeConfigurationError(WebSphereBundle.message("error.profile.is.not.correct.text", new Object[0]));
        }
        WebSphereCell cell = WebSphereProfileUtil.getCellByName(profile, cellName);
        if (cell == null) {
            throw new RuntimeConfigurationError(WebSphereBundle.message("error.cannot.find.cell.in.profile.text", cellName, profile.getName()));
        }
        WebSphereNode node = WebSphereProfileUtil.getNodeByName(cell, nodeName);
        if (node == null) {
            throw new RuntimeConfigurationError(WebSphereBundle.message("error.cannot.find.node.in.cell.text", nodeName, cell.getCellName()));
        }
        WebSphereServerConfiguration server = WebSphereProfileUtil.getServerByName(node, serverName);
        if (server == null) {
            throw new RuntimeConfigurationError(WebSphereBundle.message("error.cannot.find.server.in.node.text", serverName, node.getNodeName()));
        }
        WebSphereServerConfiguration webSphereServerConfiguration = server;
        if (webSphereServerConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/configuration/WebSphereProfileUtil", "createValidServerConfiguration"));
        }
        return webSphereServerConfiguration;
    }

    @Nullable
    public static WebSphereCell getCellByName(WebSphereProfile profile, String cellName) {
        WebSphereCell[] cells;
        for (WebSphereCell cell : cells = profile.getCells()) {
            if (!cell.getCellName().equals(cellName)) continue;
            return cell;
        }
        return null;
    }

    @Nullable
    public static WebSphereNode getNodeByName(WebSphereCell cell, String nodeName) {
        WebSphereNode[] nodes;
        for (WebSphereNode node : nodes = cell.getNodes()) {
            if (!node.getNodeName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public static WebSphereServerConfiguration getServerByName(WebSphereNode node, String serverName) {
        WebSphereServerConfiguration[] servers;
        for (WebSphereServerConfiguration server : servers = node.getServers()) {
            if (!server.getServerName().equals(serverName)) continue;
            return server;
        }
        return null;
    }
}

