/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.j2ee.webSphere.configuration.WebSphereNode;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfile;
import java.io.File;

public class WebSphereServerConfiguration {
    private final WebSphereNode myNode;
    private final String myServerName;
    private final int myHttpPort;
    private final int mySOAPPort;
    private final File mySystemOutLogFile;

    public WebSphereServerConfiguration(WebSphereNode node, String serverName, int httpPort, int SOAPPort, File systemOutLogFile) {
        this.myNode = node;
        this.myServerName = serverName;
        this.myHttpPort = httpPort;
        this.mySOAPPort = SOAPPort;
        this.mySystemOutLogFile = systemOutLogFile;
    }

    public WebSphereNode getNode() {
        return this.myNode;
    }

    public String getServerName() {
        return this.myServerName;
    }

    public int getHttpPort() {
        return this.myHttpPort;
    }

    public int getSOAPPort() {
        return this.mySOAPPort;
    }

    public String toString() {
        return this.myServerName;
    }

    public File getSystemOutLogFile() {
        return this.mySystemOutLogFile;
    }

    public WebSphereProfile getProfile() {
        return this.getNode().getCell().getProfile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSphereServerConfiguration that = (WebSphereServerConfiguration)o;
        return this.myNode.equals(that.myNode) && this.myServerName.equals(that.myServerName);
    }

    public int hashCode() {
        int result = this.myNode.hashCode();
        result = 29 * result + this.myServerName.hashCode();
        return result;
    }
}

