/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestEnvironment {
    public static final String CONNECTION_STRING_VAR = "test-db";
    public static final String CONNECTION_STRINGS_VAR_PREFIX = "test-db-";
    public static final String CONNECTION_STRINGS_FILE = "test-db.properties";
    private static final Properties mySystemProperties = System.getProperties();
    private static final Properties myLocalProperties = TestEnvironment.readLocalProperties();
    private static final Map<String, String> myEnv = System.getenv();

    @NotNull
    public static String obtainConnectionString() {
        String connectionString = TestEnvironment.getPossibleConnectionString(TestEnvironment.getVar(CONNECTION_STRING_VAR, null));
        if (connectionString == null) {
            System.err.println("Failed to obtain Test DB connection string.\nThe connection string is searched in the following locations:\n1) 'test-db' property in ./test-db.properties;\n2) 'test-db' environment variable;\n3) 'test-db' system property.");
            System.exit(-128);
        }
        return connectionString;
    }

    @Nullable
    protected static String getPossibleConnectionString(@Nullable String cs) {
        if (cs != null) {
            String[] f = cs.split(":", 2);
            if (f.length == 1) {
                String anotherPropertyName = CONNECTION_STRINGS_VAR_PREFIX + f[0];
                String anotherChance = TestEnvironment.getVar(anotherPropertyName, null);
                return TestEnvironment.getPossibleConnectionString(anotherChance);
            }
            return cs;
        }
        return null;
    }

    @Contract(value="_,null->_; _,!null->!null")
    public static String getVar(@NotNull String name, @Nullable String defaultValue) {
        String value = mySystemProperties.getProperty(name);
        if (value == null) {
            value = myLocalProperties.getProperty(name);
        }
        if (value == null) {
            value = myEnv.get(name);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static Properties readLocalProperties() {
        Properties p = new Properties();
        for (File dir = TestEnvironment.getCurrentDirectory(); dir != null && dir.isDirectory(); dir = dir.getParentFile()) {
            File file = new File(dir, CONNECTION_STRINGS_FILE);
            if (!file.exists() || file.isDirectory()) continue;
            TestEnvironment.readLocalPropertiesFromFile(p, file);
            break;
        }
        return p;
    }

    @NotNull
    private static File getCurrentDirectory() {
        File dir = new File(".");
        try {
            dir = dir.getCanonicalFile();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readLocalPropertiesFromFile(Properties p, File localPropertiesFile) {
        try {
            FileInputStream is = new FileInputStream(localPropertiesFile);
            try {
                p.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException io) {
            System.err.println("Failed to read file " + localPropertiesFile.getPath() + ": " + io.getMessage());
        }
    }
}

