/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.BaseTestHelper;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.InSessionNoResult;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.TextFileFragment;

public class MssqlTestHelper
extends BaseTestHelper<DBFacade> {
    public MssqlTestHelper(@NotNull DBFacade db) {
        super(db, Scriptum.of(MssqlTestHelper.class));
        this.schemasNotToZap.add("sys");
    }

    @Override
    public void prepareX1() {
        final TextFileFragment x1 = this.scriptum.getText("X1");
        this.db.inSession(new InSessionNoResult(){

            @Override
            public void run(@NotNull DBSession session) {
                Connection conn = session.getSpecificService(Connection.class, "jdbc-connection");
                assert (conn != null);
                try {
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    stmt.execute(x1.text);
                    stmt.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void prepareX1000() {
        this.performCommand(this.scriptum, "X10");
        this.performCommand(this.scriptum, "X1000");
    }

    @Override
    public void prepareX1000000() {
        this.prepareX1000();
        this.performCommand(this.scriptum, "X1000000");
    }
}

