/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.converters.WebflowConverterUtil;
import com.intellij.spring.webflow.model.converters.WebflowLookupUtil;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.DelimitedListConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentFlowsConverter
extends DelimitedListConverter<Flow> {
    private static final Function<Flow, PsiFile> FILE_FUNCTION = new Function<Flow, PsiFile>(){

        public PsiFile fun(Flow flow) {
            return DomUtil.getFile((DomElement)flow);
        }
    };

    public ParentFlowsConverter() {
        super(",");
    }

    protected Flow convertString(@Nullable String string, ConvertContext context) {
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        return WebflowDomModelManager.getInstance(context.getProject()).findFlowByName(module, string);
    }

    protected String toString(@Nullable Flow flow) {
        return flow == null ? null : WebflowUtil.getFlowName(flow);
    }

    protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<List<Flow>> listGenericDomValue) {
        List flows = (List)listGenericDomValue.getValue();
        if (flows == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        List exceptedFiles = ContainerUtil.mapNotNull((Collection)flows, FILE_FUNCTION);
        Module module = context.getModule();
        List<Flow> all = WebflowUtil.getAllFlows(module, ContainerUtil.concat((List)exceptedFiles, Collections.singletonList(context.getFile().getOriginalFile())));
        return WebflowLookupUtil.forFlows(all);
    }

    protected PsiElement resolveReference(@Nullable Flow flow, ConvertContext context) {
        return flow == null ? null : WebflowUtil.resolveFlow(flow);
    }

    protected String getUnresolvedMessage(String value) {
        return WebflowBundle.message("parent.flows.converter.cannot.find.flow", value);
    }

    @NotNull
    protected PsiReference createPsiReference(PsiElement element, int start, int end, ConvertContext context, GenericDomValue<List<Flow>> genericDomValue, boolean delimitersOnly) {
        DelimitedListConverter.MyPsiReference myPsiReference = new DelimitedListConverter.MyPsiReference(element, new TextRange(start, end), context, genericDomValue, delimitersOnly){

            public boolean isReferenceTo(PsiElement element) {
                return super.isReferenceTo(element) || WebflowConverterUtil.isCustomFlowIdReference(element);
            }
        };
        if (myPsiReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ParentFlowsConverter", "createPsiReference"));
        }
        return myPsiReference;
    }

    protected PsiElement referenceBindToElement(PsiReference psiReference, PsiElement element, Function<PsiElement, PsiElement> superBindToElementFunction, Function<String, PsiElement> superElementRenameFunction) throws IncorrectOperationException {
        VirtualFile file;
        if (element instanceof XmlFile && (file = ((XmlFile)element).getVirtualFile()) != null) {
            return this.referenceHandleElementRename(psiReference, file.getNameWithoutExtension(), superElementRenameFunction);
        }
        return psiReference.getElement();
    }

    protected PsiElement referenceHandleElementRename(PsiReference psiReference, String newName, Function<String, PsiElement> superHandleElementRename) throws IncorrectOperationException {
        if (psiReference.resolve() instanceof XmlFile) {
            String name = FileUtil.getNameWithoutExtension((String)newName);
            return (PsiElement)superHandleElementRename.fun((Object)name);
        }
        return (PsiElement)superHandleElementRename.fun((Object)newName);
    }
}

