/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.webflow.config.model.xml.version1_0.Registry;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowRegistry;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebflowConfigUtil {
    private WebflowConfigUtil() {
    }

    @NotNull
    public static List<FlowRegistry> getFlowRegistries(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/util/WebflowConfigUtil", "getFlowRegistries"));
        }
        List<FlowRegistry> list = WebflowConfigUtil.doGetFlowRegistries(module, FlowRegistry.class, "Spring Webflow Config namespace key");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/util/WebflowConfigUtil", "getFlowRegistries"));
        }
        return list;
    }

    @NotNull
    public static List<Registry> getFlowRegistries10(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/util/WebflowConfigUtil", "getFlowRegistries10"));
        }
        List<Registry> list = WebflowConfigUtil.doGetFlowRegistries(module, Registry.class, "Spring Webflow 1 Config namespace key");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/util/WebflowConfigUtil", "getFlowRegistries10"));
        }
        return list;
    }

    @NotNull
    public static List<SpringProperty> getAdditionalConfigProperties(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/util/WebflowConfigUtil", "getAdditionalConfigProperties"));
        }
        PsiClass flowRegistrar = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.webflow.engine.builder.xml.XmlFlowRegistrar");
        if (flowRegistrar == null) {
            List<SpringProperty> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/util/WebflowConfigUtil", "getAdditionalConfigProperties"));
            }
            return list;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)flowRegistrar).effectiveBeanTypes();
        SmartList configProperties = new SmartList();
        Set models = SpringManager.getInstance((Project)module.getProject()).getAllModels(module);
        for (SpringModel model : models) {
            List flowRegistrarBeans = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
            for (SpringBeanPointer beanPointer : flowRegistrarBeans) {
                CommonSpringBean bean = beanPointer.getSpringBean();
                SpringPropertyDefinition locations = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)"flowLocations");
                if (!(locations instanceof SpringProperty)) continue;
                configProperties.add((SpringProperty)locations);
            }
        }
        SmartList smartList = configProperties;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/util/WebflowConfigUtil", "getAdditionalConfigProperties"));
        }
        return smartList;
    }

    @NotNull
    private static <T extends DomElement> List<T> doGetFlowRegistries(@NotNull Module module, Class<T> configElementClazz, String configElementNamespaceKey) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/util/WebflowConfigUtil", "doGetFlowRegistries"));
        }
        SmartList flowRegistries = new SmartList();
        Set models = SpringManager.getInstance((Project)module.getProject()).getAllModels(module);
        for (SpringModel model : models) {
            if (!(model instanceof XmlSpringModel)) continue;
            Set roots = ((XmlSpringModel)model).getLocalModelsRoots();
            for (DomFileElement domFileElement : roots) {
                if (!SpringDomUtils.hasNamespace((DomFileElement)domFileElement, (String)configElementNamespaceKey)) continue;
                List registries = DomUtil.getDefinedChildrenOfType((DomElement)domFileElement.getRootElement(), configElementClazz, (boolean)true, (boolean)false);
                flowRegistries.addAll(registries);
            }
        }
        SmartList smartList = flowRegistries;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/util/WebflowConfigUtil", "doGetFlowRegistries"));
        }
        return smartList;
    }
}

