/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.artifacts.ManifestManagerListener;
import com.intellij.dmserver.artifacts.ManifestUpdater;
import com.intellij.dmserver.artifacts.PsiConfigManagerBase;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.facet.DMBundleFacetConfiguration;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.DMCompositeFacetConfiguration;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.dmserver.facet.DMFacetConfigurationBase;
import com.intellij.dmserver.util.ManifestUtils;
import com.intellij.dmserver.util.ModuleUtils;
import com.intellij.dmserver.util.PathUtils;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.EventListener;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.osgi.framework.Version;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;

public abstract class ManifestManager<C extends DMFacetConfigurationBase<C>, F extends DMFacetBase<C>, P>
extends PsiConfigManagerBase<ManifestFile, C, F> {
    private static final Logger LOG = Logger.getInstance((String)("#" + ManifestManager.class.getName()));
    @NonNls
    public static final String META_INF_DIR = "META-INF";
    @NonNls
    public static final String MANIFEST_FILE = "MANIFEST.MF";
    private static final ManifestManager<DMBundleFacetConfiguration, DMBundleFacet, OsmorcFacet> ourBundleInstance = new ManifestManager<DMBundleFacetConfiguration, DMBundleFacet, OsmorcFacet>("Bundle-Name", "Bundle-SymbolicName", "Bundle-Version"){

        @Override
        protected String getManifestPathFromSource(@NotNull OsmorcFacet osmorcFacet, @NotNull VirtualFile contentRoot) {
            if (osmorcFacet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "osmorcFacet", "com/intellij/dmserver/artifacts/ManifestManager$1", "getManifestPathFromSource"));
            }
            if (contentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/intellij/dmserver/artifacts/ManifestManager$1", "getManifestPathFromSource"));
            }
            String result = osmorcFacet.getManifestLocation();
            if (!((OsmorcFacetConfiguration)osmorcFacet.getConfiguration()).isUseProjectDefaultManifestFileLocation()) {
                String fullPath = this.getManifestFullPath(contentRoot, result);
                VirtualFile locationFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
                if (locationFile != null && locationFile.isDirectory()) {
                    result = PathUtils.concatPaths(result, ManifestManager.MANIFEST_FILE);
                    ((OsmorcFacetConfiguration)osmorcFacet.getConfiguration()).setManifestLocation(FileUtil.toSystemDependentName((String)result));
                }
            }
            return result;
        }

        @Override
        protected String getManifestPathFromModule(@NotNull Module module, @NotNull VirtualFile contentRoot) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/ManifestManager$1", "getManifestPathFromModule"));
            }
            if (contentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/intellij/dmserver/artifacts/ManifestManager$1", "getManifestPathFromModule"));
            }
            return this.getManifestPathFromSource(OsmorcFacet.getInstance((Module)module), contentRoot);
        }

        @Override
        protected boolean onConfigFileChanged(DMBundleFacetConfiguration configuration2update, ManifestFile configFile) {
            return false;
        }
    };
    private static final String PAR_MANIFEST_PATH = PathUtils.concatPaths("META-INF", "MANIFEST.MF");
    private static final ManifestManager<DMCompositeFacetConfiguration, DMCompositeFacet, Module> ourParInstance = new ManifestManager<DMCompositeFacetConfiguration, DMCompositeFacet, Module>("Application-Name", "Application-SymbolicName", "Application-Version"){

        @Override
        protected String getManifestPathFromSource(@NotNull Module module, @NotNull VirtualFile contentRoot) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/ManifestManager$2", "getManifestPathFromSource"));
            }
            if (contentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/intellij/dmserver/artifacts/ManifestManager$2", "getManifestPathFromSource"));
            }
            return PAR_MANIFEST_PATH;
        }

        @Override
        protected String getManifestPathFromModule(@NotNull Module module, @NotNull VirtualFile contentRoot) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/ManifestManager$2", "getManifestPathFromModule"));
            }
            if (contentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRoot", "com/intellij/dmserver/artifacts/ManifestManager$2", "getManifestPathFromModule"));
            }
            return this.getManifestPathFromSource(module, contentRoot);
        }

        @Override
        protected boolean onConfigFileChanged(DMCompositeFacetConfiguration configuration2update, ManifestFile configFile) {
            if (this.isInFileUpdate()) {
                return false;
            }
            FileWrapper fileWrapper = new FileWrapper(configFile);
            configuration2update.setName(2.safeValue(fileWrapper.getSymbolicName(), ""));
            configuration2update.setVersion(2.safeValue(fileWrapper.getVersion(), ""));
            return true;
        }
    };
    private final String myNameHeader;
    private final String mySymbolicNameHeader;
    private final String myVersionHeader;
    private boolean myInFileUpdate = false;
    private final EventDispatcher<ManifestManagerListener> myEventDispatcher = EventDispatcher.create(ManifestManagerListener.class);

    public static ManifestManager<DMBundleFacetConfiguration, DMBundleFacet, OsmorcFacet> getBundleInstance() {
        return ourBundleInstance;
    }

    public static ManifestManager<DMCompositeFacetConfiguration, DMCompositeFacet, Module> getParInstance() {
        return ourParInstance;
    }

    private ManifestManager(@NonNls String nameHeader, @NonNls String symbolicNameHeader, @NonNls String versionHeader) {
        this.myNameHeader = nameHeader;
        this.mySymbolicNameHeader = symbolicNameHeader;
        this.myVersionHeader = versionHeader;
    }

    protected final boolean isInFileUpdate() {
        return this.myInFileUpdate;
    }

    protected final String getManifestFullPath(VirtualFile contentRoot, String manifestPath) {
        return PathUtils.concatPaths(contentRoot.getPath(), manifestPath);
    }

    public VirtualFile createManifest(final @NotNull Module module, final @NotNull P manifestPathSource, final @NotNull ModuleRootModel rootModel, final @Nullable String symbolicName, final @Nullable String version) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/ManifestManager", "createManifest"));
        }
        if (manifestPathSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestPathSource", "com/intellij/dmserver/artifacts/ManifestManager", "createManifest"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/ManifestManager", "createManifest"));
        }
        return (VirtualFile)WriteCommandAction.runWriteCommandAction((Project)module.getProject(), (Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    return ManifestManager.this.doCreateManifest(module, manifestPathSource, rootModel, symbolicName, version);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        });
    }

    private VirtualFile doCreateManifest(final @NotNull Module module, @NotNull P manifestPathSource, @NotNull ModuleRootModel rootModel, @Nullable String symbolicName, @Nullable String version) throws IOException {
        String versionValue;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/ManifestManager", "doCreateManifest"));
        }
        if (manifestPathSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestPathSource", "com/intellij/dmserver/artifacts/ManifestManager", "doCreateManifest"));
        }
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/dmserver/artifacts/ManifestManager", "doCreateManifest"));
        }
        VirtualFile contentRoot = ModuleUtils.getModuleRoot(rootModel);
        String fullPath = this.getManifestFullPath(contentRoot, this.getManifestPathFromSource(manifestPathSource, contentRoot));
        String parentPath = PathUtil.getParentPath((String)fullPath);
        String filename = PathUtil.getFileName((String)fullPath);
        VirtualFile parentFolder = VfsUtil.createDirectories((String)parentPath);
        VirtualFile manifestVirtualFile = parentFolder.findChild(filename);
        if (manifestVirtualFile == null) {
            manifestVirtualFile = parentFolder.createChildData((Object)this, filename);
        }
        String moduleName = module.getName();
        if (version == null) {
            Version moduleVersion = null;
            int nextDotPos = moduleName.indexOf(46);
            while (moduleVersion == null && nextDotPos >= 0) {
                try {
                    moduleVersion = new Version(moduleName.substring(nextDotPos + 1));
                    moduleName = moduleName.substring(0, nextDotPos);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                nextDotPos = moduleName.indexOf(46, nextDotPos + 1);
            }
            versionValue = moduleVersion == null ? "1.0.0" : moduleVersion.toString();
        } else {
            versionValue = version;
        }
        final String symbolicNameValue = symbolicName == null ? moduleName : symbolicName;
        final VirtualFile finalManifestVirtualFile = manifestVirtualFile;
        final String finalModuleName = moduleName;
        final boolean keepSymbolicName = symbolicName == null;
        final boolean keepVersion = version == null;
        Runnable updateRunnable = new Runnable(){

            @Override
            public void run() {
                ManifestManager.this.myInFileUpdate = true;
                try {
                    ManifestFile manifestFile = (ManifestFile)PsiManager.getInstance((Project)module.getProject()).findFile(finalManifestVirtualFile);
                    if (manifestFile == null) {
                        LOG.error("Can't find manifest PSI file");
                        return;
                    }
                    ManifestUpdater manifestUpdater = new ManifestUpdater(manifestFile);
                    manifestUpdater.updateHeader(Attributes.Name.MANIFEST_VERSION.toString(), "1.0.0", true);
                    manifestUpdater.updateHeader("Bundle-ManifestVersion", "2", true);
                    manifestUpdater.updateHeader(ManifestManager.this.myNameHeader, finalModuleName, true);
                    manifestUpdater.updateHeader(ManifestManager.this.mySymbolicNameHeader, symbolicNameValue, keepSymbolicName);
                    manifestUpdater.updateHeader(ManifestManager.this.myVersionHeader, versionValue, keepVersion);
                    ((ManifestManagerListener)ManifestManager.this.myEventDispatcher.getMulticaster()).manifestCreated(module, new FileWrapper(manifestFile));
                }
                finally {
                    ManifestManager.this.myInFileUpdate = false;
                }
            }
        };
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(updateRunnable);
        return manifestVirtualFile;
    }

    @Nullable
    public FileWrapper findManifest(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/ManifestManager", "findManifest"));
        }
        ManifestFile manifestPsiFile = this.findManifestFile(module);
        if (manifestPsiFile == null) {
            return null;
        }
        return new FileWrapper(manifestPsiFile);
    }

    private VirtualFile findManifestVirtualFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/ManifestManager", "findManifestVirtualFile"));
        }
        VirtualFile contentRoot = ModuleUtils.getModuleRoot(module);
        return contentRoot.findFileByRelativePath(this.getManifestPathFromModule(module, contentRoot));
    }

    @Nullable
    public VirtualFile findManifestFolder(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/ManifestManager", "findManifestFolder"));
        }
        VirtualFile manifestVirtualFile = this.findManifestVirtualFile(module);
        if (manifestVirtualFile == null) {
            return null;
        }
        return manifestVirtualFile.getParent();
    }

    private ManifestFile findManifestFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/artifacts/ManifestManager", "findManifestFile"));
        }
        VirtualFile manifestVirtualFile = this.findManifestVirtualFile(module);
        if (manifestVirtualFile == null) {
            return null;
        }
        return (ManifestFile)PsiManager.getInstance((Project)module.getProject()).findFile(manifestVirtualFile);
    }

    @Override
    protected ManifestFile findConfigFile(Module module) {
        return this.findManifestFile(module);
    }

    public void addListener(ManifestManagerListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(ManifestManagerListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    protected abstract String getManifestPathFromSource(@NotNull P var1, @NotNull VirtualFile var2);

    protected abstract String getManifestPathFromModule(@NotNull Module var1, @NotNull VirtualFile var2);

    public class FileWrapper {
        private final ManifestFile myFile;

        private FileWrapper(ManifestFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dmserver/artifacts/ManifestManager$FileWrapper", "<init>"));
            }
            this.myFile = file;
        }

        public String getVersion() {
            return ManifestUtils.getInstance().getHeaderValue((PsiFile)this.myFile, ManifestManager.this.myVersionHeader);
        }

        public String getSymbolicName() {
            return ManifestUtils.getInstance().getHeaderValue((PsiFile)this.myFile, ManifestManager.this.mySymbolicNameHeader);
        }

        public ManifestFile getFile() {
            return this.myFile;
        }
    }
}

