/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.dmserver.editor.ImportedBundlesPanel;
import com.intellij.dmserver.editor.ImportedLibrariesPanel;
import com.intellij.dmserver.editor.ImportedPackagesPanel;
import com.intellij.dmserver.editor.ImportedUnitsPanel;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.dmserver.util.PsiTreeChangedAdapter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.psi.ManifestFile;

public class ManifestFileEditor
extends UserDataHolderBase
implements FileEditor {
    private JPanel myMainPanel;
    private ImportedUnitsPanel myImportedPackagesPanel;
    private ImportedUnitsPanel myImportedBundlesPanel;
    private ImportedUnitsPanel myImportedLibrariesPanel;
    private final List<ImportedUnitsPanel> myImportedUnitsPanels;
    private final ManifestFile myManifestFile;

    public ManifestFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/editor/ManifestFileEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dmserver/editor/ManifestFileEditor", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myManifestFile = (ManifestFile)PsiManager.getInstance((Project)project).findFile(file);
        this.myImportedUnitsPanels = Arrays.asList(this.myImportedPackagesPanel, this.myImportedBundlesPanel, this.myImportedLibrariesPanel);
        for (ImportedUnitsPanel importedUnitsPanel : this.myImportedUnitsPanels) {
            importedUnitsPanel.init(project, this.myManifestFile);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiTreeChangedAdapter psiTreeChangeListener = new PsiTreeChangedAdapter(){

            @Override
            protected void treeChanged(PsiTreeChangeEvent event) {
                if (ManifestFileEditor.this.myManifestFile != event.getFile()) {
                    return;
                }
                for (ImportedUnitsPanel importedUnitsPanel : ManifestFileEditor.this.myImportedUnitsPanels) {
                    importedUnitsPanel.notifyFileChanged();
                }
            }
        };
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)psiTreeChangeListener, (Disposable)this);
    }

    private void createUIComponents() {
        this.myImportedPackagesPanel = new ImportedPackagesPanel();
        this.myImportedBundlesPanel = new ImportedBundlesPanel();
        this.myImportedLibrariesPanel = new ImportedLibrariesPanel();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/editor/ManifestFileEditor", "getComponent"));
        }
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMainPanel;
    }

    @NotNull
    public String getName() {
        String string = DmServerBundle.message("ManifestFileEditor.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/editor/ManifestFileEditor", "getName"));
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/dmserver/editor/ManifestFileEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/editor/ManifestFileEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/dmserver/editor/ManifestFileEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/dmserver/editor/ManifestFileEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/dmserver/editor/ManifestFileEditor", "removePropertyChangeListener"));
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return new FileEditorLocation(){

            @NotNull
            public FileEditor getEditor() {
                ManifestFileEditor manifestFileEditor = ManifestFileEditor.this;
                if (manifestFileEditor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/editor/ManifestFileEditor$2", "getEditor"));
                }
                return manifestFileEditor;
            }

            public int compareTo(FileEditorLocation fileEditorLocation) {
                return 0;
            }
        };
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(4, 4, 4, 4), -1, -1, true, true));
        ImportedUnitsPanel importedUnitsPanel = this.myImportedPackagesPanel;
        JComponent jComponent = importedUnitsPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        ImportedUnitsPanel importedUnitsPanel2 = this.myImportedBundlesPanel;
        JComponent jComponent2 = importedUnitsPanel2.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        ImportedUnitsPanel importedUnitsPanel3 = this.myImportedLibrariesPanel;
        JComponent jComponent3 = importedUnitsPanel3.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent3, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

