/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.facet;

import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.facet.DMCompositeFacet;
import com.intellij.dmserver.facet.DMConfigFacet;
import com.intellij.dmserver.facet.DMFacetBase;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DMFacetsSwitch<T> {
    @Nullable
    public T processModule(@NotNull Module module) {
        DMConfigFacet configFacet;
        DMCompositeFacet compositeFacet;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/dmserver/facet/DMFacetsSwitch", "processModule"));
        }
        ArrayList<DMFacetBase> dmFacets = new ArrayList<DMFacetBase>();
        DMBundleFacet bundleFacet = DMBundleFacet.getInstance(module);
        if (bundleFacet != null) {
            dmFacets.add(bundleFacet);
        }
        if ((compositeFacet = DMCompositeFacet.getInstance(module)) != null) {
            dmFacets.add(compositeFacet);
        }
        if ((configFacet = DMConfigFacet.getInstance(module)) != null) {
            dmFacets.add(configFacet);
        }
        if (dmFacets.size() != 1) {
            return null;
        }
        if (bundleFacet != null) {
            return this.doProcessBundleFacet(bundleFacet);
        }
        if (compositeFacet != null) {
            return this.doProcessCompositeFacet(compositeFacet);
        }
        if (configFacet != null) {
            return this.doProcessConfigFacet(configFacet);
        }
        return null;
    }

    protected abstract T doProcessBundleFacet(DMBundleFacet var1);

    protected abstract T doProcessCompositeFacet(DMCompositeFacet var1);

    protected abstract T doProcessConfigFacet(DMConfigFacet var1);
}

