/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.install.impl;

import com.intellij.dmserver.install.DMServerConfigSupport;
import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.ServerVersionHandler;
import com.intellij.dmserver.install.impl.DMServerLibraryFinder;
import com.intellij.dmserver.install.impl.PropertiesUtil;
import com.intellij.dmserver.install.impl.ServerVersion10;
import com.intellij.dmserver.install.impl.ServerVersion20;
import com.intellij.dmserver.install.impl.ServerVersion21Virgo;
import com.intellij.dmserver.install.impl.ServerVersionVirgo3;
import com.intellij.dmserver.install.impl.ServerVersionVirgo35;
import com.intellij.dmserver.install.impl.ServerVersionVirgo36;
import com.intellij.dmserver.integration.DMServerHelper;
import com.intellij.dmserver.integration.DMServerIntegration;
import com.intellij.dmserver.integration.DMServerIntegrationData;
import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.PathResolver;
import com.intellij.dmserver.integration.RepositoryPattern;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServerInfo;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerInstallationImpl
implements DMServerInstallation {
    private static final Logger LOG = Logger.getInstance((String)("#" + DMServerInstallationImpl.class.getName()));
    private final VirtualFile myHome;
    private final VirtualFile myStartup;
    private final VirtualFile myShutdown;
    private final VirtualFile myTempFolder;
    private final ServerVersionHandler myServerVersion;
    private final DMServerConfigSupport myConfigSupport;
    @NonNls
    private static final String SPRINGSOURCE_JAVAX_PREFIX = "com.springsource.javax.";
    @NonNls
    private static final String DM_VERSION_PROPERTY_NAME = "dm.server.version";
    @NonNls
    private static final String VIRGO_VERSION_PROPERTY_NAME = "virgo.server.version";
    private boolean myVersionValid;
    private String myVersionText;

    public DMServerInstallationImpl(VirtualFile home) {
        this.myHome = home;
        this.myStartup = home.findFileByRelativePath("bin/startup." + DMServerInstallationImpl.getScriptExtension());
        this.myShutdown = home.findFileByRelativePath("bin/shutdown." + DMServerInstallationImpl.getScriptExtension());
        this.myTempFolder = home.findFileByRelativePath("work/temp");
        VirtualFile versionFile = home.findFileByRelativePath("lib/.version");
        this.myServerVersion = this.detectVersion(versionFile);
        this.myConfigSupport = this.myServerVersion.createConfigSupport(home);
    }

    @Override
    public DMServerConfigSupport getConfigSupport() {
        return this.myConfigSupport;
    }

    @Override
    public VirtualFile getHome() {
        return this.myHome;
    }

    @Override
    public VirtualFile getTempFolder() {
        return this.myTempFolder;
    }

    @Override
    public VirtualFile[] getSharedLibraries() {
        if (!this.isValid()) {
            return VirtualFile.EMPTY_ARRAY;
        }
        ApplicationServer existingServer = this.getExistingApplicationServer();
        List<RepositoryPattern> repositoryPatterns = this.doCollectRepositoryPatterns(existingServer == null ? this.createServerData() : (DMServerIntegrationData)existingServer.getPersistentData());
        ArrayList<VirtualFile> jars = new ArrayList<VirtualFile>();
        DMServerLibraryFinder sourceBundlesFilter = new DMServerLibraryFinder();
        for (RepositoryPattern repositoryPattern : repositoryPatterns) {
            for (VirtualFile repositoryFile : repositoryPattern.collectFiles()) {
                if (!"jar".equals(repositoryFile.getExtension()) || sourceBundlesFilter.isSourcesBundle(repositoryFile) || !repositoryFile.getName().startsWith(SPRINGSOURCE_JAVAX_PREFIX)) continue;
                jars.add(repositoryFile);
            }
        }
        return VfsUtil.toVirtualFileArray(jars);
    }

    @Override
    @Nullable
    public VirtualFile getSystemLibraryFolder() {
        return this.myHome.findFileByRelativePath("lib");
    }

    @Override
    public boolean isValid() {
        return DMServerInstallationImpl.isValidFile(this.myStartup) && DMServerInstallationImpl.isValidFile(this.myShutdown) && this.myVersionValid && this.myConfigSupport.isValid();
    }

    @Nullable
    private ApplicationServer getExistingApplicationServer() {
        if (!this.isValid()) {
            return null;
        }
        List<ApplicationServer> servers = DMServerIntegration.getInstance().getDMServers();
        File sdkHomeFile = new File(FileUtil.toSystemDependentName((String)this.myHome.getPath()));
        for (ApplicationServer next : servers) {
            String nextPath = ((DMServerIntegrationData)next.getPersistentData()).getInstallationHome();
            if (!sdkHomeFile.equals(new File(FileUtil.toSystemDependentName((String)nextPath)))) continue;
            return next;
        }
        return null;
    }

    private DMServerIntegrationData createServerData() {
        DMServerIntegrationData result = new DMServerIntegrationData(this.myHome.getPath());
        this.getConfigSupport().readFromServer(result);
        return result;
    }

    @Override
    public ApplicationServer getOrCreateApplicationServer() {
        ApplicationServer existingServer = this.getExistingApplicationServer();
        if (existingServer != null) {
            return existingServer;
        }
        ApplicationServersManager serversManager = ApplicationServersManager.getInstance();
        final ApplicationServersManager.ApplicationServersManagerModifiableModel model = serversManager.createModifiableModel();
        final DMServerIntegrationData serverData = this.createServerData();
        final ApplicationServerInfo serverInfo = DMServerHelper.createApplicationServerInfo(this);
        UniqueNameGenerator generator = new UniqueNameGenerator((Collection)serversManager.getApplicationServers(), (Function)new NullableFunction<ApplicationServer, String>(){

            public String fun(ApplicationServer o) {
                return o.getName();
            }
        });
        String nameBase = serverInfo.getDefaultName();
        final String name = generator.generateUniqueName(nameBase);
        RunResult runResult = new WriteAction<ApplicationServer>(){

            protected void run(@NotNull Result<ApplicationServer> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/install/impl/DMServerInstallationImpl$2", "run"));
                }
                ApplicationServer server = model.createNewApplicationServer(name, serverInfo.getDefaultLibraries(), (ApplicationServerPersistentData)serverData);
                server.setSourceIntegrationName(DMServerIntegration.getInstance().getPresentableName());
                model.commit();
                result.setResult((Object)server);
            }
        }.execute();
        return (ApplicationServer)runResult.getResultObject();
    }

    public static boolean isValidFile(VirtualFile file) {
        return file != null && file.isValid() && file.exists() && !file.isDirectory();
    }

    @NonNls
    private static String getScriptExtension() {
        return SystemInfo.isWindows ? "bat" : "sh";
    }

    public ValidationResult validate() {
        if (!this.myHome.isDirectory()) {
            return new ValidationResult(DmServerBundle.message("DMServerInstallationImpl.error.not.a.folder", this.myHome.getPath()));
        }
        if (!DMServerInstallationImpl.isValidFile(this.myStartup)) {
            return new ValidationResult(DmServerBundle.message("DMServerInstallationImpl.error.no.startup.script", this.myHome.getPath()));
        }
        if (!DMServerInstallationImpl.isValidFile(this.myShutdown)) {
            return new ValidationResult(DmServerBundle.message("DMServerInstallationImpl.error.no.shutdown.script", this.myHome.getPath()));
        }
        if (!this.myVersionValid) {
            return new ValidationResult(DmServerBundle.message("DMServerInstallationImpl.error.detect.version.script", this.myHome.getPath()));
        }
        if (!this.myConfigSupport.isValid()) {
            return new ValidationResult(DmServerBundle.message("DMServerInstallationImpl.error.no.config.file", this.myHome.getPath()));
        }
        return ValidationResult.OK;
    }

    @Override
    public ServerVersionHandler getServerVersion() {
        return this.myServerVersion;
    }

    private ServerVersionHandler detectVersion(VirtualFile version) {
        Properties versionProperties;
        this.myVersionValid = true;
        if (version == null || !version.exists()) {
            return new ServerVersion10();
        }
        VersionHandlerFactory defaultHandlerFactory = new VersionHandlerFactory(){

            @Override
            public String getPropertyName() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ServerVersionHandler createHandler() {
                DMServerInstallationImpl.this.myVersionValid = false;
                return new ServerVersionVirgo35();
            }
        };
        VersionHandlerFactory[] detectableFactories = new VersionHandlerFactory[]{new VersionHandlerFactory(){

            @Override
            public String getPropertyName() {
                return DMServerInstallationImpl.DM_VERSION_PROPERTY_NAME;
            }

            @Override
            public ServerVersionHandler createHandler() {
                return new ServerVersion20();
            }
        }, new VersionHandlerFactory(){

            @Override
            public String getPropertyName() {
                return DMServerInstallationImpl.VIRGO_VERSION_PROPERTY_NAME;
            }

            @Override
            public ServerVersionHandler createHandler() {
                Version parsedVersion = new Version(DMServerInstallationImpl.this.myVersionText);
                if (parsedVersion.compare(3, 6, 0) >= 0) {
                    return new ServerVersionVirgo36();
                }
                if (parsedVersion.compare(3, 5, 0) >= 0) {
                    return new ServerVersionVirgo35();
                }
                if (parsedVersion.compare(3, 0, 0) >= 0) {
                    return new ServerVersionVirgo3();
                }
                return new ServerVersion21Virgo();
            }
        }};
        try {
            versionProperties = PropertiesUtil.loadProperties(version);
        }
        catch (IOException e) {
            LOG.debug("Error reading version properties file", (Throwable)e);
            return defaultHandlerFactory.createHandler();
        }
        for (VersionHandlerFactory factory : detectableFactories) {
            String propertyName = factory.getPropertyName();
            if (!versionProperties.containsKey(propertyName)) continue;
            this.myVersionText = versionProperties.getProperty(propertyName);
            return factory.createHandler();
        }
        return defaultHandlerFactory.createHandler();
    }

    @Override
    public String getVersionName() {
        return this.myVersionText != null ? this.myVersionText : this.myServerVersion.getFamilyName();
    }

    @Override
    public List<RepositoryPattern> collectRepositoryPatterns() {
        if (!this.isValid()) {
            return Collections.emptyList();
        }
        return this.doCollectRepositoryPatterns((DMServerIntegrationData)this.getOrCreateApplicationServer().getPersistentData());
    }

    private List<RepositoryPattern> doCollectRepositoryPatterns(DMServerIntegrationData serverData) {
        PathResolver pathResolver = new PathResolver(){

            @Override
            protected VirtualFile getBaseDir() {
                return DMServerInstallationImpl.this.myHome;
            }
        };
        ArrayList<RepositoryPattern> result = new ArrayList<RepositoryPattern>();
        for (DMServerRepositoryItem repositoryItem : serverData.getRepositoryItems()) {
            result.add(repositoryItem.createPattern(pathResolver));
        }
        return result;
    }

    private static interface VersionHandlerFactory {
        public String getPropertyName();

        public ServerVersionHandler createHandler();
    }
}

