/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.install.impl;

import com.intellij.dmserver.common.MBeanUtil;
import com.intellij.dmserver.deploy.DeploymentIdentity;
import com.intellij.dmserver.deploy.jmx.ConnectorKernelStatusCommand;
import com.intellij.dmserver.deploy.jmx.QueryDeploymentStatusCommand;
import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.ServerVersionHandler;
import com.intellij.dmserver.install.impl.ServerVersion10;
import com.intellij.dmserver.run.DMServerInstance;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.management.ObjectName;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerVersion2Base
extends ServerVersion10 {
    private final String myRootPackage;
    private final ObjectName myMBeanDeployer;
    private final ObjectName myMBeanRecoveryMonitor;
    private final ObjectName myMBeanBundleAdmin;
    private final ObjectName myMBeanKernelStatus;

    protected ServerVersion2Base(@NonNls String rootPackage) {
        this.myRootPackage = rootPackage;
        this.myMBeanDeployer = MBeanUtil.newObjectName(rootPackage + ".kernel:category=Control,type=Deployer");
        this.myMBeanRecoveryMonitor = MBeanUtil.newObjectName(rootPackage + ".kernel:category=Control,type=RecoveryMonitor");
        this.myMBeanBundleAdmin = MBeanUtil.newObjectName(rootPackage + ".server:type=BundleAdmin");
        this.myMBeanKernelStatus = MBeanUtil.newObjectName(rootPackage + ".kernel:type=KernelStatus");
    }

    @Override
    @NotNull
    public ServerVersionHandler.DMVersion getVersion() {
        ServerVersionHandler.DMVersion dMVersion = ServerVersionHandler.DMVersion.DM_20;
        if (dMVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/install/impl/ServerVersion2Base", "getVersion"));
        }
        return dMVersion;
    }

    @Override
    public ObjectName getDeployerMBean() {
        return this.myMBeanDeployer;
    }

    @Override
    public ObjectName getModelMBean(DeploymentIdentity identity) {
        StringBuilder nameBuilder = new StringBuilder(this.myRootPackage + ".kernel:type=" + this.getDeploymentMBeanType() + "," + "artifact-type=" + identity.getType() + "," + "name=" + identity.getSymbolicName() + "," + "version=" + identity.getVersion());
        String region = identity.getRegion();
        if (region == null) {
            region = this.getDeploymentMBeanRegion();
        }
        if (region != null) {
            nameBuilder.append(",region=");
            nameBuilder.append(region);
        }
        return MBeanUtil.newObjectName(nameBuilder.toString());
    }

    protected String getDeploymentMBeanType() {
        return "Model";
    }

    @Nullable
    protected String getDeploymentMBeanRegion() {
        return null;
    }

    @Override
    public ObjectName getBundleAdminMBean() {
        return this.myMBeanBundleAdmin;
    }

    @Override
    public ObjectName getRecoveryMonitorMBean() {
        return this.myMBeanRecoveryMonitor;
    }

    @Override
    public ObjectName getKernelStatusMBean() {
        return this.myMBeanKernelStatus;
    }

    @Override
    public ObjectName getRepositoryMBean(String repositoryName) {
        return MBeanUtil.newObjectName(this.myRootPackage + ".kernel:type=Repository,name=" + repositoryName);
    }

    @Override
    public VirtualFile getRuntimeBaseFolder(DMServerInstallation installation) {
        return installation.getHome();
    }

    @Override
    public String getJmxScriptName() {
        return "dmk";
    }

    @Override
    public String getJmxPortEnvVar() {
        return "JMX_PORT";
    }

    @Override
    public boolean pingServerInstance(DMServerInstance serverInstance) throws ExecutionException, TimeoutException {
        Boolean result = (Boolean)new ConnectorKernelStatusCommand(serverInstance).execute();
        if (!Boolean.TRUE.equals(result)) {
            return false;
        }
        if (!ServerVersion2Base.isDeploymentReady(serverInstance, this.createAdminIdentity())) {
            return false;
        }
        DeploymentIdentity needForRepositoryIdentity = this.createNeedForRepositoryIdentity();
        if (needForRepositoryIdentity != null && !ServerVersion2Base.isDeploymentReady(serverInstance, needForRepositoryIdentity)) {
            return true;
        }
        return ServerVersion2Base.isDeploymentReady(serverInstance, this.createRepositoryIdentity());
    }

    private static boolean isDeploymentReady(DMServerInstance serverInstance, final DeploymentIdentity identity) throws TimeoutException, ExecutionException {
        Boolean ready = (Boolean)new QueryDeploymentStatusCommand(serverInstance, null){

            @Override
            protected DeploymentIdentity getIdentity() {
                return identity;
            }
        }.execute();
        return Boolean.TRUE.equals(ready);
    }

    @Nullable
    protected DeploymentIdentity createNeedForRepositoryIdentity() {
        return null;
    }

    protected abstract DeploymentIdentity createAdminIdentity();

    protected abstract DeploymentIdentity createRepositoryIdentity();

    @Override
    public String getFamilyName() {
        return DmServerBundle.message("DMServerHelper.server.family.name.2_0", new Object[0]);
    }
}

