/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.obr;

import com.intellij.dmserver.editor.AvailableBundlesProvider;
import com.intellij.dmserver.libraries.BundleDefinition;
import com.intellij.dmserver.libraries.EnableBehavior;
import com.intellij.dmserver.libraries.EnableStateEvaluator;
import com.intellij.dmserver.libraries.LibraryDefinition;
import com.intellij.dmserver.libraries.ProgressListener;
import com.intellij.dmserver.libraries.ServerLibrariesContext;
import com.intellij.dmserver.libraries.obr.Column;
import com.intellij.dmserver.libraries.obr.DownloadTargetEditor;
import com.intellij.dmserver.libraries.obr.GrayableTableWrapper;
import com.intellij.dmserver.libraries.obr.HttpRetriever;
import com.intellij.dmserver.libraries.obr.JTableWrapper;
import com.intellij.dmserver.libraries.obr.XPathUtils;
import com.intellij.dmserver.libraries.obr.data.AbstractCodeData;
import com.intellij.dmserver.libraries.obr.data.AbstractCodeDataDetails;
import com.intellij.dmserver.libraries.obr.data.AbstractCodeDownloadData;
import com.intellij.dmserver.libraries.obr.data.BundleData;
import com.intellij.dmserver.libraries.obr.data.BundleDetails;
import com.intellij.dmserver.libraries.obr.data.BundleDownloadData;
import com.intellij.dmserver.libraries.obr.data.LibraryBundleData;
import com.intellij.dmserver.libraries.obr.data.LibraryData;
import com.intellij.dmserver.libraries.obr.data.LibraryDetails;
import com.intellij.dmserver.libraries.obr.data.LibraryDownloadData;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DownloadBundlesEditor {
    @NonNls
    private static final String UTF8 = "UTF-8";
    @NonNls
    public static final String URL_BASE = "http://www.springsource.com";
    private static final String SEARCH_PROGRESS_TEXT = DmServerBundle.message("DownloadBundlesEditor.label.progress.searching", new Object[0]);
    private static final String DOWNLOAD_PROGRESS_TEXT = DmServerBundle.message("DownloadBundlesEditor.label.progress.downloading", new Object[0]);
    private static final String TO_RESULTS_PROGRESS_TEXT = DmServerBundle.message("DownloadBundlesEditor.label.progress.adding", new Object[0]);
    private JButton mySearchButton;
    private JTextField mySearchText;
    private JButton myDownloadButton;
    private JCheckBox myIncludeDependenciesCheckbox;
    private JButton myBundleDepsToResultsButton;
    private JButton myLibraryDepsToResultsButton;
    private JButton myClearButton;
    private JPanel myLibrariesGroup;
    private JPanel myBundlesGroup;
    private JPanel myMainPanel;
    private JScrollPane myLibrariesPane;
    private JScrollPane myLibraryDepsPane;
    private JScrollPane myBundlesPane;
    private JScrollPane myBundleDepsPane;
    private JLabel myStatusLabel;
    private JTable myLibrariesTable;
    private JTable myLibraryDepsTable;
    private JTable myBundlesTable;
    private JTable myBundleDepsTable;
    private DownloadTargetEditor myBundleTargetEditor;
    private DownloadTargetEditor myLibraryTargetEditor;
    private BundlesProcessor myBundlesProcessor;
    private LibrariesProcessor myLibrariesProcessor;
    private final ServerLibrariesContext myContext;
    private EnableBehavior myEnableBehavior;

    public DownloadBundlesEditor(ServerLibrariesContext context) {
        this.myContext = context;
        this.$$$setupUI$$$();
        this.getBundlesProcessor().init();
        this.getLibrariesProcessor().init();
        this.setupComponents();
        this.setupEnableBehavior();
    }

    private BundlesProcessor getBundlesProcessor() {
        if (this.myBundlesProcessor == null) {
            this.myBundlesProcessor = new BundlesProcessor();
        }
        return this.myBundlesProcessor;
    }

    private LibrariesProcessor getLibrariesProcessor() {
        if (this.myLibrariesProcessor == null) {
            this.myLibrariesProcessor = new LibrariesProcessor();
        }
        return this.myLibrariesProcessor;
    }

    private boolean isBundleDownloaded(BundleData bundleData) {
        return this.getBundlesProcessor().isComponentDownloaded(bundleData);
    }

    private void createUIComponents() {
        this.myLibrariesTable = this.getLibrariesProcessor().getTable();
        this.myLibraryDepsTable = this.getLibrariesProcessor().getDependencyTable();
        this.myBundlesTable = this.getBundlesProcessor().getTable();
        this.myBundleDepsTable = this.getBundlesProcessor().getDependencyTable();
    }

    private void setupComponents() {
        this.mySearchText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadBundlesEditor.this.doSearch();
            }
        });
        this.mySearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadBundlesEditor.this.doSearch();
            }
        });
        this.getBundlesProcessor().setupDepsToResultsButton(this.myBundleDepsToResultsButton);
        this.getLibrariesProcessor().setupDepsToResultsButton(this.myLibraryDepsToResultsButton);
        this.myDownloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadBundlesEditor.this.doDownload();
            }
        });
        this.myClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadBundlesEditor.this.doClear();
            }
        });
        this.myBundleTargetEditor.init(this.myContext.getInstallation());
        this.myLibraryTargetEditor.init(this.myContext.getInstallation());
    }

    private void setupEnableBehavior() {
        this.myEnableBehavior = new EnableBehavior();
        this.myEnableBehavior.addComponent(this.mySearchButton, new EnableStateEvaluator(){

            @Override
            public boolean isEnabled() {
                return DownloadBundlesEditor.this.mySearchText.getDocument().getLength() > 0;
            }
        });
        this.myEnableBehavior.addComponent(this.myDownloadButton, new EnableStateEvaluator(){

            @Override
            public boolean isEnabled() {
                return DownloadBundlesEditor.this.getBundlesProcessor().hasComponentsToDownload() || DownloadBundlesEditor.this.getLibrariesProcessor().hasComponentsToDownload();
            }
        });
        this.myEnableBehavior.addComponent(this.myClearButton, new EnableStateEvaluator(){

            @Override
            public boolean isEnabled() {
                return DownloadBundlesEditor.this.getBundlesProcessor().hasFoundComponents() || DownloadBundlesEditor.this.getLibrariesProcessor().hasFoundComponents();
            }
        });
        this.getBundlesProcessor().setupEnableBehavior();
        this.getLibrariesProcessor().setupEnableBehavior();
        this.mySearchText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DownloadBundlesEditor.this.myEnableBehavior.updateEnableState(DownloadBundlesEditor.this.mySearchButton);
            }
        });
        this.myEnableBehavior.updateAllEnableStates();
    }

    private void doClear() {
        this.myBundlesProcessor.clearComponents();
        this.myLibrariesProcessor.clearComponents();
    }

    private void setStatusText(String statusText) {
        this.myStatusLabel.setText(statusText);
    }

    private void startTask(String title, final DownloadTask task) {
        this.setStatusText("");
        new Task.Modal(this.myContext.getProject(), title, true){

            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dmserver/libraries/obr/DownloadBundlesEditor$9", "run"));
                }
                indicator.setIndeterminate(true);
                task.run(new DownloadTaskIndicator(){

                    @Override
                    public void setProgressText(String progressText) {
                        indicator.setText(progressText);
                    }

                    @Override
                    public boolean isCancelled() {
                        return indicator.isCanceled();
                    }
                });
            }

            protected void onFinished() {
                task.postRun();
                DownloadBundlesEditor.this.myBundlesProcessor.refreshTable();
                DownloadBundlesEditor.this.myLibrariesProcessor.refreshTable();
            }
        }.queue();
    }

    private void doSearch() {
        if (StringUtil.isEmpty((String)this.mySearchText.getText())) {
            return;
        }
        this.startTask(SEARCH_PROGRESS_TEXT, new DownloadTaskBase(){

            @Override
            public void run(DownloadTaskIndicator indicator) {
                try {
                    String searchText;
                    try {
                        searchText = URLEncoder.encode(DownloadBundlesEditor.this.mySearchText.getText(), DownloadBundlesEditor.UTF8);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException(ex);
                    }
                    int[] refLibrariesCount = new int[1];
                    int[] refBundlesCount = new int[1];
                    if (!DownloadBundlesEditor.this.getLibrariesProcessor().search(searchText, refLibrariesCount, DmServerBundle.message("DownloadBundlesEditor.status.searching.for.libraries", new Object[0]), "DownloadBundlesEditor.status.collecting.library.details", indicator)) {
                        this.setResultText(DmServerBundle.message("DownloadBundlesEditor.result.details.collecting.interrupted.libs-only", refLibrariesCount[0]));
                    } else if (!DownloadBundlesEditor.this.getBundlesProcessor().search(searchText, refBundlesCount, DmServerBundle.message("DownloadBundlesEditor.status.searching.for.bundles", new Object[0]), "DownloadBundlesEditor.status.collecting.bundle.details", indicator)) {
                        this.setResultText(DmServerBundle.message("DownloadBundlesEditor.result.details.collecting.interrupted.libs-and-bundles", refLibrariesCount[0], refBundlesCount[0]));
                    } else {
                        this.setResultText(refLibrariesCount[0] == 0 && refBundlesCount[0] == 0 ? DmServerBundle.message("DownloadBundlesEditor.result.nothing", new Object[0]) : DmServerBundle.message("DownloadBundlesEditor.result.ok.libs-and-bundles", refLibrariesCount[0], refBundlesCount[0]));
                    }
                }
                catch (IOException e) {
                    this.setResultException(e);
                }
                catch (XPathExpressionException e) {
                    this.setResultException(e);
                }
            }
        });
    }

    private void doDownload() {
        final HashMap librariesToDownload = new HashMap();
        final HashMap<String, BundleData> bundlesToDownload = new HashMap<String, BundleData>();
        this.getLibrariesProcessor().collectComponentsToDownload(librariesToDownload, bundlesToDownload);
        this.getBundlesProcessor().collectComponentsToDownload(bundlesToDownload, bundlesToDownload);
        if (librariesToDownload.isEmpty() && bundlesToDownload.isEmpty()) {
            return;
        }
        this.startTask(DOWNLOAD_PROGRESS_TEXT, new DownloadTaskBase(){
            private final ArrayList<File> myBundleJars = new ArrayList();
            private final ArrayList<File> myLibraryDefs = new ArrayList();

            @Override
            public void run(DownloadTaskIndicator indicator) {
                try {
                    if (DownloadBundlesEditor.this.getBundlesProcessor().download(bundlesToDownload.values(), this.myBundleJars, "DownloadBundlesEditor.status.downloading.bundles", indicator) && DownloadBundlesEditor.this.getLibrariesProcessor().download(librariesToDownload.values(), this.myLibraryDefs, "DownloadBundlesEditor.status.downloading.libraries", indicator)) {
                        new ChainIndicator(indicator, DmServerBundle.message("DownloadBundlesEditor.status.updating.index", new Object[0]));
                        AvailableBundlesProvider.getInstance(DownloadBundlesEditor.this.myContext.getProject()).resetRepositoryIndex();
                        this.setResultText(DmServerBundle.message("DownloadBundlesEditor.result.download.successful", new Object[0]));
                    } else {
                        this.setResultText(DmServerBundle.message("DownloadBundlesEditor.result.download.interrupted", new Object[0]));
                    }
                }
                catch (IOException e) {
                    this.setResultException(e);
                }
                catch (XPathExpressionException e) {
                    this.setResultException(e);
                }
                finally {
                    DownloadBundlesEditor.this.getBundlesProcessor().updateDownloadedRows();
                    DownloadBundlesEditor.this.getLibrariesProcessor().updateDownloadedRows();
                }
            }
        });
    }

    public void initSearch(String packageName) {
        this.mySearchText.setText(packageName);
    }

    public Component getMainPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        DownloadTargetEditor downloadTargetEditor;
        JButton jButton;
        JPanel jPanel;
        DownloadTargetEditor downloadTargetEditor2;
        JButton jButton2;
        JPanel jPanel2;
        JButton jButton3;
        JCheckBox jCheckBox;
        JButton jButton4;
        JTextField jTextField;
        JButton jButton5;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.mySearchButton = jButton5 = new JButton();
        this.$$$loadButtonText$$$(jButton5, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.search"));
        jPanel4.add((Component)jButton5, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.mySearchText = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myDownloadButton = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.download"));
        jPanel5.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myIncludeDependenciesCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.include.dependencies"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myClearButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.clear"));
        jPanel5.add((Component)jButton3, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, true));
        jPanel3.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLibrariesGroup = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setEnabled(true);
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.libraries"), (int)0, (int)0, null, null));
        this.myLibraryDepsToResultsButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.add.to.search.results"));
        jButton2.setActionCommand("");
        jPanel2.add((Component)jButton2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.search.results"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.dependencies"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 2, 1, 0, 3, 7, 7, null, null, null));
        JTable jTable = this.myLibrariesTable;
        jBScrollPane.setViewportView(jTable);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane2, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        JTable jTable2 = this.myLibraryDepsTable;
        jBScrollPane2.setViewportView(jTable2);
        this.myLibraryTargetEditor = downloadTargetEditor2 = new DownloadTargetEditor();
        JComponent jComponent = downloadTargetEditor2.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myBundlesGroup = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel6.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.bundles"), (int)0, (int)0, null, null));
        this.myBundleDepsToResultsButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.add.to.search.results"));
        jPanel.add((Component)jButton, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.dependencies"));
        jPanel.add((Component)jLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/intellij/dmserver/util/DmServer").getString("Form.DownloadBundlesEditor.search.results"));
        jPanel.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane3 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane3, new GridConstraints(1, 0, 2, 1, 0, 3, 7, 7, null, null, null));
        JTable jTable3 = this.myBundlesTable;
        jBScrollPane3.setViewportView(jTable3);
        JBScrollPane jBScrollPane4 = new JBScrollPane();
        jPanel.add((Component)jBScrollPane4, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        JTable jTable4 = this.myBundleDepsTable;
        jBScrollPane4.setViewportView(jTable4);
        this.myBundleTargetEditor = downloadTargetEditor = new DownloadTargetEditor();
        JComponent jComponent2 = downloadTargetEditor.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myStatusLabel = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setText("");
        jPanel3.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class LibrariesProcessor
    extends CodeComponentProcessor<LibraryBundleData, LibraryBundleColumn, LibraryData, LibraryDownloadData, LibraryDownloadColumn> {
        private LibrariesProcessor() {
        }

        protected LibraryDownloadColumn[] createTableColumns() {
            return new LibraryDownloadColumn[]{new LibraryDownloadColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.add", new Object[0])){

                @Override
                public Object getColumnValue(LibraryDownloadData row) {
                    return row.getDownload();
                }

                @Override
                public Class<?> getValueClass() {
                    return Boolean.class;
                }

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setColumnValue(int iRow, Object value) {
                    ((LibraryDownloadData)LibrariesProcessor.this.getRows().get(iRow)).setDownload((Boolean)value);
                }

                @Override
                public boolean needPack() {
                    return true;
                }
            }, new LibraryDownloadColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.name", new Object[0])){

                @Override
                public Object getColumnValue(LibraryDownloadData row) {
                    return ((LibraryData)row.getCodeData()).getName();
                }
            }, new LibraryDownloadColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.version", new Object[0])){

                @Override
                public Object getColumnValue(LibraryDownloadData row) {
                    return ((LibraryData)row.getCodeData()).getVersion();
                }

                @Override
                public boolean needPack() {
                    return true;
                }
            }};
        }

        protected LibraryBundleColumn[] createDependencyTableColumns() {
            return new LibraryBundleColumn[]{new LibraryBundleColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.in-library", new Object[0])){

                @Override
                public Object getColumnValue(LibraryBundleData row) {
                    return row.isIncluded();
                }

                @Override
                public Class<?> getValueClass() {
                    return Boolean.class;
                }

                @Override
                public boolean needPack() {
                    return true;
                }
            }, new LibraryBundleColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.name", new Object[0])){

                public String getColumnValue(LibraryBundleData row) {
                    return row.getName();
                }
            }, new LibraryBundleColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.version", new Object[0])){

                public String getColumnValue(LibraryBundleData row) {
                    return row.getVersion();
                }

                @Override
                public boolean needPack() {
                    return true;
                }
            }};
        }

        @Override
        protected LibraryDownloadData createRow(String name, String version, String link) {
            return new LibraryDownloadData(name, version, link);
        }

        @Override
        @NonNls
        protected String getParamPrefix() {
            return "libraries";
        }

        @Override
        protected boolean downloadComponent(LibraryData componentToDownload, List<File> componentFiles, DownloadTaskIndicator indicator) throws IOException, XPathExpressionException {
            componentFiles.add(this.downloadCodeElement(((LibraryDetails)componentToDownload.getDetails()).getLibraryDefLink(), new ChainIndicator(indicator, DmServerBundle.message("DownloadBundlesEditor.status.downloading.library.definition", new Object[0]))));
            return true;
        }

        @Override
        protected boolean shouldDownloadDependency(LibraryBundleData dependency) {
            return super.shouldDownloadDependency(dependency) || dependency.isIncluded() != false;
        }

        @Override
        protected List<LibraryData> getDownloadedComponents() {
            ArrayList<LibraryData> result = new ArrayList<LibraryData>();
            for (LibraryDefinition libraryDef : AvailableBundlesProvider.getInstance(DownloadBundlesEditor.this.myContext.getProject()).getAllRepositoryLibraries()) {
                if (!this.areLibraryBundlesDownloaded(libraryDef)) continue;
                result.add(new LibraryData(libraryDef.getSymbolicName(), libraryDef.getVersion(), null));
            }
            return result;
        }

        private boolean areLibraryBundlesDownloaded(LibraryDefinition libraryDef) {
            for (BundleDefinition bundleDef : libraryDef.getBundleDefs()) {
                if (DownloadBundlesEditor.this.getBundlesProcessor().isComponentDownloaded(new BundleData(bundleDef))) continue;
                return false;
            }
            return true;
        }

        @Override
        @Nullable
        protected VirtualFile getDestinationFolder() {
            return DownloadBundlesEditor.this.myLibraryTargetEditor.getTargetDir();
        }
    }

    private class BundlesProcessor
    extends CodeComponentProcessor<BundleData, BundleColumn, BundleData, BundleDownloadData, BundleDownloadColumn> {
        private BundlesProcessor() {
        }

        protected BundleDownloadColumn[] createTableColumns() {
            return new BundleDownloadColumn[]{new BundleDownloadColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.add", new Object[0])){

                @Override
                public Object getColumnValue(BundleDownloadData row) {
                    return row.getDownload();
                }

                @Override
                public Class<?> getValueClass() {
                    return Boolean.class;
                }

                @Override
                public boolean isEditable() {
                    return true;
                }

                @Override
                public void setColumnValue(int iRow, Object value) {
                    ((BundleDownloadData)BundlesProcessor.this.getRows().get(iRow)).setDownload((Boolean)value);
                }

                @Override
                public boolean needPack() {
                    return true;
                }
            }, new BundleDownloadColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.name", new Object[0])){

                @Override
                public Object getColumnValue(BundleDownloadData row) {
                    return ((BundleData)row.getCodeData()).getName();
                }
            }, new BundleDownloadColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.version", new Object[0])){

                @Override
                public Object getColumnValue(BundleDownloadData row) {
                    return ((BundleData)row.getCodeData()).getVersion();
                }

                @Override
                public boolean needPack() {
                    return true;
                }
            }};
        }

        protected BundleColumn[] createDependencyTableColumns() {
            return new BundleColumn[]{new BundleColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.name", new Object[0])){

                public String getColumnValue(BundleData row) {
                    return row.getName();
                }
            }, new BundleColumn(DmServerBundle.message("DownloadBundlesEditor.BundlesProcessor.column.version", new Object[0])){

                public String getColumnValue(BundleData row) {
                    return row.getVersion();
                }

                @Override
                public boolean needPack() {
                    return true;
                }
            }};
        }

        @Override
        protected BundleDownloadData createRow(String name, String version, String link) {
            return new BundleDownloadData(name, version, link);
        }

        @Override
        @NonNls
        protected String getParamPrefix() {
            return "bundles";
        }

        public void addRow(BundleDownloadData row) {
            this.getRows().add(row);
        }

        @Override
        protected boolean downloadComponent(BundleData componentToDownload, List<File> componentFiles, DownloadTaskIndicator indicator) throws IOException, XPathExpressionException {
            componentToDownload.loadDetails(new ChainIndicator(indicator, DmServerBundle.message("DownloadBundlesEditor.status.collecting.details", new Object[0])));
            if (indicator.isCancelled()) {
                return false;
            }
            componentFiles.add(this.downloadCodeElement(((BundleDetails)componentToDownload.getDetails()).getBinaryJarLink(), new ChainIndicator(indicator, DmServerBundle.message("DownloadBundlesEditor.status.downloading.binary.jar", new Object[0]))));
            if (indicator.isCancelled()) {
                return false;
            }
            if (((BundleDetails)componentToDownload.getDetails()).getSourceJarLink() != null) {
                componentFiles.add(this.downloadCodeElement(((BundleDetails)componentToDownload.getDetails()).getSourceJarLink(), new ChainIndicator(indicator, DmServerBundle.message("DownloadBundlesEditor.status.downloading.source.jar", new Object[0]))));
            }
            return true;
        }

        @Override
        protected List<BundleData> getDownloadedComponents() {
            ArrayList<BundleData> result = new ArrayList<BundleData>();
            for (BundleDefinition bundleDefinition : AvailableBundlesProvider.getInstance(DownloadBundlesEditor.this.myContext.getProject()).getAllRepositoryBundles()) {
                result.add(new BundleData(bundleDefinition));
            }
            return result;
        }

        @Override
        @Nullable
        protected VirtualFile getDestinationFolder() {
            return DownloadBundlesEditor.this.myBundleTargetEditor.getTargetDir();
        }
    }

    private abstract class CodeComponentProcessor<DR extends BundleData, DC extends Column<DR>, D extends AbstractCodeData<? extends AbstractCodeDataDetails<DR>>, SR extends AbstractCodeDownloadData<D>, SC extends Column<SR>> {
        protected final XPathUtils XPATH = XPathUtils.getInstance();
        private Set<String> myDownloadedComponentIDs;
        private JTableWrapper<SR, SC> myTableWrapper;
        private ArrayList<SR> myComponentRows = new ArrayList();
        private JTableWrapper<DR, DC> myDependencyTableWrapper;
        private JButton myDepsToResultsButton;

        private CodeComponentProcessor() {
        }

        public void init() {
            this.initDownloadedComponents(this.getDownloadedComponents());
        }

        @Nullable
        protected abstract VirtualFile getDestinationFolder();

        protected abstract List<D> getDownloadedComponents();

        private void initDownloadedComponents(List<D> downloadedCodeComponents) {
            this.myDownloadedComponentIDs = new HashSet<String>();
            for (AbstractCodeData downloadedCodeComponent : downloadedCodeComponents) {
                this.myDownloadedComponentIDs.add(downloadedCodeComponent.getID());
            }
        }

        public JBTable getTable() {
            if (this.myTableWrapper == null) {
                this.myTableWrapper = new GrayableTableWrapper<SR, SC>(this.createTableColumns()){

                    @Override
                    public GrayableTableWrapper.GrayableTableModelBase createTableModel() {
                        return new GrayableTableWrapper.GrayableTableModelBase(){

                            @Override
                            public boolean isCellEditable(int row, int column) {
                                return super.isCellEditable(row, column) && !CodeComponentProcessor.this.isComponentDownloaded(((AbstractCodeDownloadData)CodeComponentProcessor.this.getRows().get(row)).getCodeData());
                            }

                            @Override
                            public boolean isCellEnabled(int row, int column) {
                                return !CodeComponentProcessor.this.isComponentDownloaded(((AbstractCodeDownloadData)CodeComponentProcessor.this.getRows().get(row)).getCodeData());
                            }
                        };
                    }
                };
                ListSelectionModel selectionModel = this.myTableWrapper.getTable().getSelectionModel();
                selectionModel.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent event) {
                        CodeComponentProcessor.this.refreshDependencyTable();
                    }
                });
            }
            return this.myTableWrapper.getTable();
        }

        public boolean isComponentDownloaded(D codeComponent) {
            return this.myDownloadedComponentIDs.contains(((AbstractCodeData)codeComponent).getID());
        }

        protected final List<SR> getRows() {
            return this.myComponentRows;
        }

        public boolean hasComponentsToDownload() {
            for (AbstractCodeDownloadData row : this.getRows()) {
                if (!row.getDownload().booleanValue()) continue;
                return true;
            }
            return false;
        }

        public boolean hasFoundComponents() {
            return !this.getRows().isEmpty();
        }

        public void setupEnableBehavior() {
            DownloadBundlesEditor.this.myEnableBehavior.addComponent(this.myDepsToResultsButton, new EnableStateEvaluator(){

                @Override
                public boolean isEnabled() {
                    return CodeComponentProcessor.this.myDependencyTableWrapper.getTable().getSelectedRowCount() > 0;
                }
            });
            this.myDependencyTableWrapper.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    DownloadBundlesEditor.this.myEnableBehavior.updateEnableState(CodeComponentProcessor.this.myDepsToResultsButton);
                }
            });
            this.myTableWrapper.getTable().getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    DownloadBundlesEditor.this.myEnableBehavior.updateEnableState(DownloadBundlesEditor.this.myDownloadButton);
                    DownloadBundlesEditor.this.myEnableBehavior.updateEnableState(DownloadBundlesEditor.this.myClearButton);
                }
            });
        }

        public void clearComponents() {
            this.getRows().clear();
            this.refreshTable();
        }

        public void refreshTable() {
            this.myTableWrapper.setInputRows(this.getRows());
        }

        public JBTable getDependencyTable() {
            if (this.myDependencyTableWrapper == null) {
                this.myDependencyTableWrapper = new GrayableTableWrapper<DR, DC>(this.createDependencyTableColumns()){

                    @Override
                    public GrayableTableWrapper.GrayableTableModelBase createTableModel() {
                        return new GrayableTableWrapper.GrayableTableModelBase(){

                            @Override
                            public boolean isCellEnabled(int row, int column) {
                                return !DownloadBundlesEditor.this.isBundleDownloaded(CodeComponentProcessor.this.getDependency(row));
                            }
                        };
                    }
                };
                this.myDependencyTableWrapper.getTable().getSelectionModel().setSelectionMode(2);
                this.myDependencyTableWrapper.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent event) {
                        int clickedRow;
                        JTable table = (JTable)event.getSource();
                        Point point = event.getPoint();
                        if (event.getClickCount() == 2 && (clickedRow = table.rowAtPoint(point)) != -1) {
                            CodeComponentProcessor.this.doMoveToResults(new int[]{clickedRow});
                        }
                    }
                });
            }
            return this.myDependencyTableWrapper.getTable();
        }

        private void refreshDependencyTable() {
            int selectedRow = this.myTableWrapper.getTable().getSelectedRow();
            this.myDependencyTableWrapper.setInputRows(selectedRow == -1 ? Collections.emptyList() : ((AbstractCodeDataDetails)((AbstractCodeData)((AbstractCodeDownloadData)this.getRows().get(selectedRow)).getCodeData()).getDetails()).getDependencies());
        }

        public boolean search(String searchText, int[] refResultLength, @Nls String searchStatusText, @NonNls @PropertyKey(resourceBundle="com.intellij.dmserver.util.DmServer") String detailsStatusBundleKey, DownloadTaskIndicator indicator) throws XPathExpressionException, IOException {
            indicator.setProgressText(searchStatusText);
            String lowerParamPrefix = this.getParamPrefix().toLowerCase();
            char[] chars = lowerParamPrefix.toCharArray();
            chars[0] = new String(new char[]{chars[0]}).toUpperCase(Locale.ENGLISH).charAt(0);
            String upperParamPrefix = new String(chars);
            String searchUrlFormat = "{0}/repository/app/search?query={1}&include{2}=true&_include{2}=on&version=&pageSize={3,number,0}&page=1&type={4}BySymbolicName";
            int PAGE_SIZE = 1000;
            String searchUrl = MessageFormat.format(searchUrlFormat, DownloadBundlesEditor.URL_BASE, searchText, upperParamPrefix, PAGE_SIZE, lowerParamPrefix);
            NodeList componentNodeList = (NodeList)this.XPATH.evaluateXPath("//div[@id='results-fragment']/ul[1]/li", this.XPATH.createHtmlRoot(HttpRetriever.retrievePage(searchUrl)), XPathConstants.NODESET);
            refResultLength[0] = componentNodeList.getLength();
            if (componentNodeList.getLength() != 0) {
                for (int iComponent = 0; iComponent < componentNodeList.getLength(); ++iComponent) {
                    if (indicator.isCancelled()) {
                        return false;
                    }
                    ChainIndicator childIndicator = new ChainIndicator(indicator, DmServerBundle.message(detailsStatusBundleKey, iComponent + 1, componentNodeList.getLength()));
                    Node componentNode = componentNodeList.item(iComponent);
                    SR row = this.createRow(this.XPATH.evaluateXPath("a/text()", componentNode).trim(), this.XPATH.evaluateXPath("text()[2]", componentNode).trim(), DownloadBundlesEditor.URL_BASE + this.XPATH.evaluateXPath("a/@href", componentNode).trim());
                    ((AbstractCodeData)((AbstractCodeDownloadData)row).getCodeData()).loadDetails(childIndicator);
                    this.getRows().add(row);
                }
            }
            return true;
        }

        private BundleData getDependency(int iRow) {
            int selectedBundleRow = this.myTableWrapper.getTable().getSelectedRow();
            if (selectedBundleRow == -1) {
                return null;
            }
            return (BundleData)((AbstractCodeDataDetails)((AbstractCodeData)((AbstractCodeDownloadData)this.getRows().get(selectedBundleRow)).getCodeData()).getDetails()).getDependencies().get(iRow);
        }

        private void markDownloaded(D component) {
            this.myDownloadedComponentIDs.add(((AbstractCodeData)component).getID());
        }

        public void updateDownloadedRows() {
            for (AbstractCodeDownloadData row : this.getRows()) {
                if (!this.myDownloadedComponentIDs.contains(((AbstractCodeData)row.getCodeData()).getID())) continue;
                row.setDownload(false);
            }
        }

        private void doMoveToResults(int[] selectedDependencyRows) {
            final ArrayList<BundleData> dependencies = new ArrayList<BundleData>();
            for (int selectedDependencyRow : selectedDependencyRows) {
                BundleData dependency = this.getDependency(selectedDependencyRow);
                if (dependency == null) continue;
                dependencies.add(dependency);
            }
            if (dependencies.isEmpty()) {
                return;
            }
            DownloadBundlesEditor.this.startTask(TO_RESULTS_PROGRESS_TEXT, new DownloadTaskBase(){

                @Override
                public void run(DownloadTaskIndicator indicator) {
                    try {
                        int iBundle = 0;
                        for (BundleData dependency : dependencies) {
                            ChainIndicator childIndicator = new ChainIndicator(indicator, DmServerBundle.message("DownloadBundlesEditor.status.collecting.details.for.dependencies", ++iBundle, dependencies.size()));
                            BundleDownloadData bundleRow = new BundleDownloadData(dependency.getName(), dependency.getVersion(), dependency.getLink());
                            ((BundleData)bundleRow.getCodeData()).loadDetails(childIndicator);
                            DownloadBundlesEditor.this.getBundlesProcessor().addRow(bundleRow);
                            if (!indicator.isCancelled()) continue;
                            this.setResultText(DmServerBundle.message("DownloadBundlesEditor.result.details.collecting.interrupted", new Object[0]));
                            return;
                        }
                        this.setResultText(DmServerBundle.message("DownloadBundlesEditor.result.details.collecting.successful", new Object[0]));
                    }
                    catch (XPathExpressionException e) {
                        this.setResultException(e);
                    }
                    catch (IOException e) {
                        this.setResultException(e);
                    }
                }
            });
        }

        public void setupDepsToResultsButton(JButton depsToResultsButton) {
            this.myDepsToResultsButton = depsToResultsButton;
            depsToResultsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeComponentProcessor.this.doMoveToResults(CodeComponentProcessor.this.myDependencyTableWrapper.getTable().getSelectedRows());
                }
            });
        }

        public void collectComponentsToDownload(Map<String, D> componentsToDownload, Map<String, BundleData> dependenciesToDownload) {
            for (AbstractCodeDownloadData row : this.getRows()) {
                if (!row.getDownload().booleanValue()) continue;
                componentsToDownload.put(((AbstractCodeData)row.getCodeData()).getID(), row.getCodeData());
                for (BundleData dependency : ((AbstractCodeDataDetails)((AbstractCodeData)row.getCodeData()).getDetails()).getDependencies()) {
                    if (!this.shouldDownloadDependency(dependency)) continue;
                    dependenciesToDownload.put(dependency.getID(), dependency);
                }
            }
        }

        protected boolean shouldDownloadDependency(DR dependency) {
            return DownloadBundlesEditor.this.myIncludeDependenciesCheckbox.isSelected();
        }

        public boolean download(Collection<D> components2download, List<File> componentFiles, @NonNls @PropertyKey(resourceBundle="com.intellij.dmserver.util.DmServer") String downloadingStatusText, DownloadTaskIndicator indicator) throws IOException, XPathExpressionException {
            int iComponent = 0;
            for (AbstractCodeData componentToDownload : components2download) {
                ChainIndicator childIndicator = new ChainIndicator(indicator, DmServerBundle.message(downloadingStatusText, ++iComponent, components2download.size()));
                if (indicator.isCancelled()) {
                    return false;
                }
                if (!this.downloadComponent(componentToDownload, componentFiles, childIndicator)) {
                    return false;
                }
                this.markDownloaded(componentToDownload);
            }
            return true;
        }

        protected final File downloadCodeElement(String link, ProgressListener progressListener) throws IOException {
            VirtualFile destinationFolder = this.getDestinationFolder();
            if (destinationFolder == null) {
                throw new IOException("Destination folder does not exist");
            }
            return HttpRetriever.downloadFile(link, VfsUtilCore.virtualToIoFile((VirtualFile)destinationFolder), progressListener);
        }

        protected abstract boolean downloadComponent(D var1, List<File> var2, DownloadTaskIndicator var3) throws IOException, XPathExpressionException;

        protected abstract SC[] createTableColumns();

        protected abstract DC[] createDependencyTableColumns();

        protected abstract SR createRow(String var1, String var2, String var3);

        @NonNls
        protected abstract String getParamPrefix();
    }

    private abstract class DownloadTaskBase
    implements DownloadTask {
        private Exception myThrownException = null;
        private String myStatusText = null;

        private DownloadTaskBase() {
        }

        @Override
        public void postRun() {
            if (this.myThrownException != null) {
                DownloadBundlesEditor.this.setStatusText(DmServerBundle.message("DownloadBundlesEditor.RunnableTaskBase.error.generic-error", this.myThrownException.getMessage()));
            } else if (this.myStatusText != null) {
                DownloadBundlesEditor.this.setStatusText(this.myStatusText);
            }
        }

        public void setResultText(String statusText) {
            this.myStatusText = statusText;
        }

        public void setResultException(Exception thrownException) {
            this.myThrownException = thrownException;
        }
    }

    private static interface DownloadTask {
        public void run(DownloadTaskIndicator var1);

        public void postRun();
    }

    private static class ChainIndicator
    implements DownloadTaskIndicator {
        private final DownloadTaskIndicator myParent;
        private final String myPrefix;

        public ChainIndicator(DownloadTaskIndicator parent, String prefix) {
            this.myParent = parent;
            this.myPrefix = prefix;
            this.myParent.setProgressText(this.myPrefix);
        }

        @Override
        public void setProgressText(String progressText) {
            this.myParent.setProgressText(DmServerBundle.message("DownloadBundlesEditor.status.chain", this.myPrefix, progressText));
        }

        @Override
        public boolean isCancelled() {
            return this.myParent.isCancelled();
        }
    }

    private static interface DownloadTaskIndicator
    extends ProgressListener {
        public boolean isCancelled();
    }

    public static abstract class LibraryDownloadColumn
    extends Column<LibraryDownloadData> {
        public LibraryDownloadColumn(String name) {
            super(name);
        }
    }

    public static abstract class BundleDownloadColumn
    extends Column<BundleDownloadData> {
        public BundleDownloadColumn(String name) {
            super(name);
        }
    }

    public static abstract class LibraryBundleColumn
    extends Column<LibraryBundleData> {
        public LibraryBundleColumn(String name) {
            super(name);
        }
    }

    public static abstract class BundleColumn
    extends Column<BundleData> {
        public BundleColumn(String name) {
            super(name);
        }
    }
}

