/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.obr;

import java.io.StringReader;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jetbrains.annotations.NonNls;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XPathUtils {
    @NonNls
    private static final Pattern JS_PATTERN = Pattern.compile("<script.*?>.*?</script>", 32);
    private static final XPathUtils ourInstance = new XPathUtils();
    private final XPath myXPath = XPathFactory.newInstance().newXPath();

    public static XPathUtils getInstance() {
        return ourInstance;
    }

    private XPathUtils() {
    }

    public XPath getXPath() {
        return this.myXPath;
    }

    public Object evaluateXPath(@NonNls String xPath, Object item, QName returnType) throws XPathExpressionException {
        return this.getXPath().evaluate(xPath, item, returnType);
    }

    public String evaluateXPath(@NonNls String xPath, Object item) throws XPathExpressionException {
        return this.getXPath().evaluate(xPath, item);
    }

    public Node createHtmlRoot(@NonNls String source) throws XPathExpressionException {
        source = source.replace("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">", "");
        source = source.replace("&nbsp;", " ");
        source = source.replace("&copy;", " ");
        source = JS_PATTERN.matcher(source).replaceAll("");
        source = source.replace("<html xmlns=\"http://www.w3.org/1999/xhtml\">", "<html>");
        InputSource inputSource = new InputSource(new StringReader(source));
        String html = "/html";
        return (Node)this.getXPath().evaluate(html, inputSource, XPathConstants.NODE);
    }
}

