/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.run;

import com.intellij.dmserver.install.DMServerInstallation;
import com.intellij.dmserver.install.impl.DMServerConfigSupport2Base;
import com.intellij.dmserver.integration.DMServerIntegration;
import com.intellij.dmserver.integration.DMServerRepositoryItem;
import com.intellij.dmserver.integration.DMServerRepositoryWatchedItem;
import com.intellij.dmserver.integration.RepositoryPattern;
import com.intellij.dmserver.run.DMLocalRunConfigurationEditor;
import com.intellij.dmserver.run.DMServerModelBase;
import com.intellij.dmserver.util.UrlUtils;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerModel
extends DMServerModelBase {
    private static final Logger LOG = Logger.getInstance(DMServerModel.class);
    private String myTargetRepositoryFolder;

    @Override
    public boolean addToRepository(final List<VirtualFile> filesToDeploy) {
        final VirtualFile repositoryFolder = this.getRepositoryFolder();
        if (repositoryFolder == null) {
            return false;
        }
        RunResult result = new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/run/DMServerModel$1", "run"));
                }
                DMServerModel.this.doAddToRepository(filesToDeploy, repositoryFolder);
            }
        }.executeSilently();
        result.logException(LOG);
        return !result.hasException();
    }

    @Nullable
    private VirtualFile getRepositoryFolder() {
        Pair<DMServerRepositoryWatchedItem, RepositoryPattern> repositoryTarget = this.getRepositoryTarget();
        return repositoryTarget == null ? null : ((RepositoryPattern)repositoryTarget.getSecond()).findBaseDir();
    }

    @Nullable
    private Pair<DMServerRepositoryWatchedItem, RepositoryPattern> getRepositoryTarget() {
        if (this.myTargetRepositoryFolder == null) {
            return null;
        }
        DMServerInstallation serverInstallation = this.getServerInstallation();
        if (serverInstallation == null) {
            return null;
        }
        for (RepositoryPattern repositoryPattern : serverInstallation.collectRepositoryPatterns()) {
            DMServerRepositoryItem repositoryItem = repositoryPattern.getSource();
            if (!(repositoryItem instanceof DMServerRepositoryWatchedItem) || !this.myTargetRepositoryFolder.equals(repositoryItem.getPath())) continue;
            return Pair.create((Object)((DMServerRepositoryWatchedItem)repositoryItem), (Object)repositoryPattern);
        }
        return null;
    }

    private void doAddToRepository(List<VirtualFile> filesToDeploy, VirtualFile repositoryFolder) throws IOException {
        for (VirtualFile fileToDeploy : filesToDeploy) {
            fileToDeploy.copy((Object)this, repositoryFolder, fileToDeploy.getName());
        }
    }

    @Override
    public boolean removeFromRepository(final List<VirtualFile> filesToUndeploy) {
        final VirtualFile repositoryFolder = this.getRepositoryFolder();
        if (repositoryFolder == null) {
            return false;
        }
        RunResult result = new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/dmserver/run/DMServerModel$2", "run"));
                }
                DMServerModel.this.doRemoveFromRepository(filesToUndeploy, repositoryFolder);
            }
        }.executeSilently();
        result.logException(LOG);
        return !result.hasException();
    }

    private void doRemoveFromRepository(List<VirtualFile> filesToUndeploy, VirtualFile repositoryFolder) throws IOException {
        repositoryFolder.refresh(false, false);
        for (VirtualFile fileToUndeploy : filesToUndeploy) {
            VirtualFile repositoryFileToUndeploy = repositoryFolder.findChild(fileToUndeploy.getName());
            if (repositoryFileToUndeploy == null) continue;
            repositoryFileToUndeploy.delete((Object)this);
        }
    }

    @Override
    @Nullable
    public String getRepositoryName() {
        Pair<DMServerRepositoryWatchedItem, RepositoryPattern> repositoryTarget = this.getRepositoryTarget();
        return repositoryTarget == null ? null : ((DMServerRepositoryWatchedItem)repositoryTarget.getFirst()).getName();
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new DMLocalRunConfigurationEditor(this.getCommonModel().getProject(), this);
    }

    public List<Pair<String, Integer>> getAddressesToCheck() {
        return Collections.singletonList(Pair.create((Object)this.getCommonModel().getHost(), (Object)this.getLocalPort()));
    }

    public void readExternal(Element element) throws InvalidDataException {
        DMServerModelSettings settings = new DMServerModelSettings();
        XmlSerializer.deserializeInto((Object)settings, (Element)element);
        this.readFromSettingsBase(settings);
        this.myTargetRepositoryFolder = settings.getTargetRepositoryFolder();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DMServerModelSettings settings = new DMServerModelSettings();
        this.writeToSettingsBase(settings);
        settings.setTargetRepositoryFolder(this.myTargetRepositoryFolder);
        XmlSerializer.serializeInto((Object)settings, (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }

    private DMServerInstallation getServerInstallation() {
        return DMServerIntegration.getInstance().getServerInstallation(this.getCommonModel());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.getServerInstallation().getConfigSupport() instanceof DMServerConfigSupport2Base && this.myTargetRepositoryFolder == null) {
            throw new RuntimeConfigurationError("Target repository folder is not configured");
        }
    }

    @Override
    public URL computeServerAccessibleStagingURL(String deploymentSourcePath) throws MalformedURLException {
        return UrlUtils.path2url(deploymentSourcePath);
    }

    @Override
    public boolean prepareDeploy(VirtualFile fileToDeploy) {
        return true;
    }

    public String getTargetRepositoryFolder() {
        return this.myTargetRepositoryFolder;
    }

    public void setTargetRepositoryFolder(String targetRepositoryFolder) {
        this.myTargetRepositoryFolder = targetRepositoryFolder;
    }

    public static class DMServerModelSettings
    extends DMServerModelBase.DMServerModelSettingsBase {
        @Tag(value="target-repository")
        private String myTargetRepositoryFolder;

        public String getTargetRepositoryFolder() {
            return this.myTargetRepositoryFolder;
        }

        public void setTargetRepositoryFolder(String targetRepositoryFolder) {
            this.myTargetRepositoryFolder = targetRepositoryFolder;
        }
    }
}

