/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.ws.converters.SoapFaultReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionMappingsValueConverter
extends Converter<String>
implements CustomReferenceConverter,
GenericDomValueConvertersRegistry.Provider,
Condition<Pair<PsiType, GenericDomValue>> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        TextRange textRange = this.getTextRange(element);
        PsiReference[] psiReferenceArray = new PsiReference[1];
        SoapFaultReference soapFaultReference = psiReferenceArray[0] = textRange == null ? new SoapFaultReference(element) : new SoapFaultReference(element, textRange);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/ExceptionMappingsValueConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    private TextRange getTextRange(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/ws/converters/ExceptionMappingsValueConverter", "getTextRange"));
        }
        String text = ElementManipulators.getValueText((PsiElement)element);
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        int start = text.indexOf(",");
        if (start >= 0) {
            return new TextRange(offset, offset + start);
        }
        return null;
    }

    public Converter getConverter() {
        return this;
    }

    public Condition<Pair<PsiType, GenericDomValue>> getCondition() {
        return this;
    }

    public boolean value(Pair<PsiType, GenericDomValue> pair) {
        GenericDomValue value = (GenericDomValue)pair.getSecond();
        if (value instanceof Prop) {
            return SpringPropertyUtils.isSpecificProperty((GenericDomValue)value, (String)"exceptionMappings", (String[])new String[]{"org.springframework.ws.soap.server.endpoint.SoapFaultMappingExceptionResolver"});
        }
        return SpringPropertyUtils.isSpecificProperty((GenericDomValue)value, (String)"defaultFault", (String[])new String[]{"org.springframework.ws.soap.server.endpoint.SoapFaultMappingExceptionResolver"});
    }
}

