/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.util;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.ws.jam.SpringWebServiceEndpoint;
import com.intellij.spring.ws.model.ws.Namespace;
import com.intellij.spring.ws.model.ws.XpathEndpoints;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebServiceJamUtil {
    private static final Key<CachedValue<Map<String, VirtualFile>>> SCHEMAS_KEY = Key.create((String)"spring ws schemas");
    private static final CachedValueProvider.Result<Map<String, VirtualFile>> EMPTY_MAP_RESULT = new CachedValueProvider.Result(Collections.emptyMap(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});

    private SpringWebServiceJamUtil() {
    }

    @Nullable
    public static SpringWebServiceEndpoint getEndpoint(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/ws/util/SpringWebServiceJamUtil", "getEndpoint"));
        }
        return (SpringWebServiceEndpoint)JamService.getJamService((Project)aClass.getProject()).getJamElement((PsiElement)aClass, new JamMemberMeta[]{SpringWebServiceEndpoint.META});
    }

    public static boolean isEndpoint(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/ws/util/SpringWebServiceJamUtil", "isEndpoint"));
        }
        return SpringWebServiceJamUtil.getEndpoint(aClass) != null;
    }

    @NotNull
    public static Map<String, VirtualFile> getSchemas(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServiceJamUtil", "getSchemas"));
        }
        Project project = module.getProject();
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        Map bundle = (Map)manager.getCachedValue((UserDataHolder)module, SCHEMAS_KEY, (CachedValueProvider)new CachedValueProvider<Map<String, VirtualFile>>(){

            public CachedValueProvider.Result<Map<String, VirtualFile>> compute() {
                return SpringWebServiceJamUtil.computeSchemas(module);
            }
        }, false);
        Map map = bundle == null ? Collections.emptyMap() : bundle;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServiceJamUtil", "getSchemas"));
        }
        return map;
    }

    @NotNull
    private static CachedValueProvider.Result<Map<String, VirtualFile>> computeSchemas(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServiceJamUtil", "computeSchemas"));
        }
        HashMap<String, VirtualFile> map = new HashMap<String, VirtualFile>();
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(ProjectRootManager.getInstance((Project)module.getProject()));
        dependencies.add(VirtualFileManager.getInstance());
        List resources = XmlNamespaceIndex.getAllResources((Module)module, (Project)module.getProject(), null);
        for (IndexedRelevantResource resource : resources) {
            VirtualFile file = resource.getFile();
            String namespace = ((XsdNamespaceBuilder)resource.getValue()).getNamespace();
            if (file == null || StringUtil.isEmptyOrSpaces((String)namespace)) continue;
            map.put(namespace, file);
            PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
            if (psiFile == null) continue;
            dependencies.add(psiFile);
        }
        CachedValueProvider.Result result = new CachedValueProvider.Result(map, dependencies.toArray());
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/util/SpringWebServiceJamUtil", "computeSchemas"));
        }
        return result;
    }

    public static Map<String, GenericAttributeValue<String>> getXPathNamespacePrefixes(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/ws/util/SpringWebServiceJamUtil", "getXPathNamespacePrefixes"));
        }
        com.intellij.util.containers.hash.HashMap prefixes = new com.intellij.util.containers.hash.HashMap();
        PsiClass xPathParamEndPointAdapter = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.ws.server.endpoint.adapter.XPathParamAnnotationMethodEndpointAdapter");
        if (xPathParamEndPointAdapter == null) {
            return prefixes;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)xPathParamEndPointAdapter).withInheritors();
        Set models = SpringManager.getInstance((Project)module.getProject()).getAllModels(module);
        for (SpringModel model : models) {
            List pointers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
            for (SpringBeanPointer pointer : pointers) {
                CommonSpringBean bean = pointer.getSpringBean();
                if (bean instanceof SpringBean) {
                    SpringPropertyDefinition springProperty = SpringPropertyUtils.findPropertyByName((CommonSpringBean)bean, (String)"namespaces");
                    if (!(springProperty instanceof SpringProperty)) continue;
                    for (Prop prop : ((SpringProperty)springProperty).getProps().getProps()) {
                        String prefix = prop.getKey().getStringValue();
                        String uri = prop.getStringValue();
                        if (StringUtil.isEmptyOrSpaces((String)prefix) || StringUtil.isEmptyOrSpaces((String)uri)) continue;
                        prefixes.put(uri, prop.getKey());
                    }
                    continue;
                }
                if (!(bean instanceof XpathEndpoints)) continue;
                for (Namespace namespace : ((XpathEndpoints)bean).getNamespaces()) {
                    String prefix = namespace.getPrefix().getStringValue();
                    String uri = namespace.getUri().getStringValue();
                    if (StringUtil.isEmptyOrSpaces((String)prefix) || StringUtil.isEmptyOrSpaces((String)uri)) continue;
                    prefixes.put(uri, namespace.getPrefix());
                }
            }
        }
        return prefixes;
    }
}

