/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.model.impl;

import com.intellij.batch.model.BatchJobXmlModel;
import com.intellij.batch.model.BatchXmlDomModelManager;
import com.intellij.batch.model.BatchXmlModel;
import com.intellij.batch.model.batch.BatchArtifacts;
import com.intellij.batch.model.impl.BatchJobXmlModelFactory;
import com.intellij.batch.model.impl.BatchXmlModelFactory;
import com.intellij.batch.model.job.Job;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatchXmlDomModelManagerImpl
extends BatchXmlDomModelManager {
    private final BatchJobXmlModelFactory myModelFactory;
    private final BatchXmlModelFactory myBatchXmlModelFactory;
    private final DomManager myDomManager;

    public BatchXmlDomModelManagerImpl(Project project, DomManager domManager) {
        this.myDomManager = domManager;
        this.myModelFactory = new BatchJobXmlModelFactory(project);
        this.myBatchXmlModelFactory = new BatchXmlModelFactory(project);
    }

    @Override
    public boolean isBatchJobXml(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/batch/model/impl/BatchXmlDomModelManagerImpl", "isBatchJobXml"));
        }
        return this.myDomManager.getFileElement(file, Job.class) != null;
    }

    @Override
    @Nullable
    public BatchJobXmlModel getBatchJobXmlModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/batch/model/impl/BatchXmlDomModelManagerImpl", "getBatchJobXmlModel"));
        }
        return this.myModelFactory.getModelByConfigFile(file);
    }

    @Override
    @NotNull
    public List<BatchJobXmlModel> getAllBatchJobModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/batch/model/impl/BatchXmlDomModelManagerImpl", "getAllBatchJobModels"));
        }
        List list = this.myModelFactory.getAllModels((UserDataHolder)module);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/impl/BatchXmlDomModelManagerImpl", "getAllBatchJobModels"));
        }
        return list;
    }

    @Override
    public boolean isBatchXml(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/batch/model/impl/BatchXmlDomModelManagerImpl", "isBatchXml"));
        }
        return this.myDomManager.getFileElement(file, BatchArtifacts.class) != null;
    }

    @Override
    @Nullable
    public BatchXmlModel getBatchXmlModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/batch/model/impl/BatchXmlDomModelManagerImpl", "getBatchXmlModel"));
        }
        return this.myBatchXmlModelFactory.getModelByConfigFile(file);
    }

    @Override
    @NotNull
    public List<BatchXmlModel> getAllBatchXmlModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/batch/model/impl/BatchXmlDomModelManagerImpl", "getAllBatchXmlModels"));
        }
        List list = this.myBatchXmlModelFactory.getAllModels((UserDataHolder)module);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/model/impl/BatchXmlDomModelManagerImpl", "getAllBatchXmlModels"));
        }
        return list;
    }
}

