/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ejb;

import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.visibility.VisibilityExtension;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import org.jetbrains.annotations.NotNull;

public class EjbVisibilityExtension
implements VisibilityExtension {
    public void fillIgnoreList(final @NotNull RefManager refManager, final @NotNull ProblemDescriptionsProcessor processor) {
        if (refManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refManager", "com/intellij/codeInspection/ejb/EjbVisibilityExtension", "fillIgnoreList"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/ejb/EjbVisibilityExtension", "fillIgnoreList"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                for (EjbRootElement ejbRootElement : EjbModuleUtil.getEjbModels((Project)refManager.getProject())) {
                    for (EntityBean entityBean : ejbRootElement.getEnterpriseBeans().getEntities()) {
                        PsiClass primaryKeyClass = (PsiClass)entityBean.getPrimKeyClass().getValue();
                        if (primaryKeyClass == null) continue;
                        for (PsiField psiField : primaryKeyClass.getFields()) {
                            RefField refField = (RefField)refManager.getReference((PsiElement)psiField);
                            if (refField == null) continue;
                            processor.ignoreElement((RefEntity)refField);
                        }
                        for (PsiField psiField : primaryKeyClass.getConstructors()) {
                            RefMethod refConstructor;
                            if (psiField.getParameterList().getParametersCount() != 0 || (refConstructor = (RefMethod)refManager.getReference((PsiElement)psiField)) == null) continue;
                            processor.ignoreElement((RefEntity)refConstructor);
                        }
                    }
                }
            }
        });
    }
}

