/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.appServerIntegrations.impl;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.impl.FrameworkTypeUtil;
import com.intellij.j2ee.appServerIntegrations.ApplicationServersConfigurable;
import com.intellij.j2ee.appServerIntegrations.impl.AppServersLibraryTable;
import com.intellij.j2ee.appServerIntegrations.impl.ApplicationServerImpl;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServerIntegrations.ApplicationServerInfo;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServerIntegrations.CantFindApplicationServerJarsException;
import com.intellij.javaee.appServers.library.AppServerFrameworkLibraryProperties;
import com.intellij.javaee.appServers.library.AppServerFrameworkLibraryType;
import com.intellij.javaee.serverInstances.ApplicationServersManager;
import com.intellij.javaee.serverInstances.ApplicationServersManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AppserversManager", storages={@Storage(value="javaeeAppServers.xml", roamingType=RoamingType.DISABLED), @Storage(value="other.xml", deprecated=true)})
public class ApplicationServersManagerImpl
extends ApplicationServersManager
implements ApplicationComponent,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ApplicationServersManagerImpl.class);
    private static final String LIBRARY_TABLE_ELEMENT_NAME = "LibraryTable";
    private static final String ATTRIBUTE_NAME = "NAME";
    private static final String SERVER_DK_ELEMENT = "ServerDK";
    public static final LibraryTablePresentation APP_SERVER_LIBRARY_TABLE_PRESENTATION = new LibraryTablePresentation(){

        public String getDisplayName(boolean plural) {
            return J2EEBundle.message((String)"appserver.library.display.name", (Object[])new Object[]{plural ? 2 : 1});
        }

        public String getDescription() {
            return J2EEBundle.message((String)"libraries.node.text.application.server", (Object[])new Object[0]);
        }

        public String getLibraryTableEditorTitle() {
            return J2EEBundle.message((String)"library.configure.appserver.title", (Object[])new Object[0]);
        }
    };
    private final List<ApplicationServer> myServerDKs = new ArrayList<ApplicationServer>();
    private final EventDispatcher<ApplicationServersManagerListener> myDispatcher = EventDispatcher.create(ApplicationServersManagerListener.class);
    private final AppServersLibraryTable myLibraryTable = new AppServersLibraryTable();
    private final LibraryTable.Listener myLibraryTableListener;
    private final List<Element> myUnresolvedServerElements = new ArrayList<Element>();

    public ApplicationServersManagerImpl(LibraryTablesRegistrar libraryTablesRegistrar) {
        libraryTablesRegistrar.registerLibraryTable((LibraryTable)this.myLibraryTable);
        this.myLibraryTableListener = new ApplicationServersLibraryTableListener();
    }

    public ApplicationServer createServer(AppServerIntegration integration, ApplicationServerPersistentData serverData) {
        ApplicationServersManager serversManager = ApplicationServersManagerImpl.getInstance();
        final ApplicationServersManager.ApplicationServersManagerModifiableModel model = serversManager.createModifiableModel();
        ApplicationServerInfo serverInfo = null;
        try {
            ApplicationServerHelper helper = integration.getApplicationServerHelper();
            if (helper != null) {
                serverInfo = helper.getApplicationServerInfo(serverData);
            }
        }
        catch (CantFindApplicationServerJarsException e) {
            LOG.info((Throwable)e);
        }
        UniqueNameGenerator generator = new UniqueNameGenerator((Collection)serversManager.getApplicationServers(), (Function)new NullableFunction<ApplicationServer, String>(){

            public String fun(ApplicationServer o) {
                return o.getName();
            }
        });
        String defaultName = serverInfo != null ? serverInfo.getDefaultName() : integration.getPresentableName();
        String name = generator.generateUniqueName(defaultName);
        File[] libraries = serverInfo != null ? serverInfo.getDefaultLibraries() : new File[]{};
        ApplicationServer server = model.createNewApplicationServer(name, libraries, serverData);
        server.setSourceIntegrationName(integration.getPresentableName());
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$3", "run"));
                }
                model.commit();
            }
        }.execute();
        return server;
    }

    public void initComponent() {
        this.myLibraryTable.addListener(this.myLibraryTableListener);
    }

    @NotNull
    public String getComponentName() {
        if ("AppserversManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl", "getComponentName"));
        }
        return "AppserversManager";
    }

    public void disposeComponent() {
        this.myLibraryTable.removeListener(this.myLibraryTableListener);
        Disposer.dispose((Disposable)this.myLibraryTable);
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        Element libraryTableElement = new Element(LIBRARY_TABLE_ELEMENT_NAME);
        try {
            this.myLibraryTable.writeExternal(libraryTableElement);
            for (ApplicationServer applicationServer : this.getApplicationServers()) {
                Element serverDKElement = new Element(SERVER_DK_ELEMENT);
                serverDKElement.setAttribute(ATTRIBUTE_NAME, applicationServer.getName());
                ((JDOMExternalizable)applicationServer).writeExternal(serverDKElement);
                element.addContent(serverDKElement);
            }
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return null;
        }
        if (!JDOMUtil.isEmpty((Element)libraryTableElement)) {
            element.addContent(libraryTableElement);
        }
        for (Element serverElement : this.myUnresolvedServerElements) {
            element.addContent(serverElement.clone());
        }
        return element;
    }

    public void loadState(Element element) {
        this.myServerDKs.clear();
        Element libraryTableElement = element.getChild(LIBRARY_TABLE_ELEMENT_NAME);
        if (libraryTableElement != null) {
            Disposer.dispose((Disposable)this.myLibraryTable);
            try {
                this.myLibraryTable.readExternal(libraryTableElement);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
        List serverDKElements = element.getChildren(SERVER_DK_ELEMENT);
        ArrayList<Library> unknownLibraries = new ArrayList<Library>(Arrays.asList(this.myLibraryTable.getLibraries()));
        Map frameworkTypes = FrameworkTypeUtil.computeFrameworkTypeByIdMap();
        for (Element serverElement : serverDKElements) {
            Library library;
            String name = serverElement.getAttributeValue(ATTRIBUTE_NAME);
            if (name == null || (library = this.myLibraryTable.getLibraryByName(name)) == null) continue;
            unknownLibraries.remove(library);
            ApplicationServerImpl server = new ApplicationServerImpl(library, null);
            List<Pair<Library, AppServerFrameworkLibraryProperties>> frameworkLibraries = this.myLibraryTable.getApplicationServerFrameworkLibraries(name);
            for (Pair<Library, AppServerFrameworkLibraryProperties> pair : frameworkLibraries) {
                FrameworkType type = (FrameworkType)frameworkTypes.get(((AppServerFrameworkLibraryProperties)((Object)pair.getSecond())).getFrameworkTypeId());
                if (type == null) continue;
                Library frameworkLibrary = (Library)pair.getFirst();
                unknownLibraries.remove(frameworkLibrary);
                server.addFrameworkLibrary(type, frameworkLibrary);
            }
            try {
                server.readExternal(serverElement);
                this.myServerDKs.add(server);
            }
            catch (InvalidDataException ignored) {
                this.myUnresolvedServerElements.add(serverElement.clone());
            }
        }
    }

    public List<ApplicationServer> getApplicationServers() {
        return this.myServerDKs;
    }

    public List<ApplicationServer> getApplicationServers(AppServerIntegration[] integrations) {
        return this.filter(integrations, this.getApplicationServers());
    }

    private List<ApplicationServer> filter(AppServerIntegration[] integrations, List<ApplicationServer> servers) {
        ArrayList<ApplicationServer> result = new ArrayList<ApplicationServer>();
        for (AppServerIntegration integration : integrations) {
            result.addAll(ApplicationServersManagerImpl.filter(integration, servers));
        }
        return this.resort(result);
    }

    private List<ApplicationServer> resort(List<ApplicationServer> result) {
        Collections.sort(result, new Comparator<ApplicationServer>(){

            @Override
            public int compare(@NotNull ApplicationServer applicationServer, @NotNull ApplicationServer applicationServer1) {
                if (applicationServer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationServer", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$4", "compare"));
                }
                if (applicationServer1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationServer1", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$4", "compare"));
                }
                return ApplicationServersManagerImpl.this.myServerDKs.indexOf(applicationServer1) - ApplicationServersManagerImpl.this.myServerDKs.indexOf(applicationServer);
            }
        });
        return result;
    }

    private static List<ApplicationServer> filter(AppServerIntegration integration, List<ApplicationServer> servers) {
        ArrayList<ApplicationServer> result = new ArrayList<ApplicationServer>();
        for (ApplicationServer server : servers) {
            if (server.getSourceIntegration() != integration) continue;
            result.add(server);
        }
        return result;
    }

    @Nullable
    public ApplicationServer findByName(String name) {
        if (name == null) {
            return null;
        }
        List<ApplicationServer> serverDKs = this.getApplicationServers();
        for (ApplicationServer applicationServer : serverDKs) {
            if (!Comparing.equal((String)name, (String)applicationServer.getName())) continue;
            return applicationServer;
        }
        return null;
    }

    public ApplicationServer findByName(String name, @NotNull AppServerIntegration integration) {
        if (integration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "integration", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl", "findByName"));
        }
        if (name == null) {
            return null;
        }
        for (ApplicationServer server : this.getApplicationServers()) {
            if (server.getSourceIntegration() != integration || !name.equals(server.getName())) continue;
            return server;
        }
        return null;
    }

    @Nullable
    public ApplicationServer editApplicationServers(JPanel panel, AppServerIntegration integration, ApplicationServer current) {
        ApplicationServersConfigurable configurable = ApplicationServersConfigurable.createConfigurable(integration, current);
        if (ShowSettingsUtil.getInstance().editConfigurable((Component)panel, configurable.getDimensionServiceKey(), (Configurable)configurable)) {
            return configurable.getSelectedApplicationServer();
        }
        return null;
    }

    @Nullable
    public ApplicationServer getDefaultFor(AppServerIntegration integration) {
        List<ApplicationServer> servers = this.getApplicationServers();
        for (ApplicationServer server : servers) {
            if (server.getSourceIntegration() != integration) continue;
            return server;
        }
        return null;
    }

    public void addServersListener(ApplicationServersManagerListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeServersListener(ApplicationServersManagerListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public LibraryTable getLibraryTable() {
        return this.myLibraryTable;
    }

    public ApplicationServersManager.ApplicationServersManagerModifiableModel createModifiableModel() {
        return new ApplicationServersManagerModifiableModelImpl();
    }

    @Nullable
    private ApplicationServer findServerByLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl", "findServerByLibrary"));
        }
        ApplicationServer server = this.findByName(library.getName());
        if (server != null && library.equals(server.getLibrary())) {
            return server;
        }
        return null;
    }

    public static String getFrameworkLibraryName(ApplicationServer server, FrameworkType type) {
        return server.getName() + " - " + type.getPresentableName();
    }

    private class ApplicationServersLibraryTableListener
    implements LibraryTable.Listener {
        private ApplicationServersLibraryTableListener() {
        }

        public void afterLibraryAdded(Library newLibrary) {
            ApplicationServer server = ApplicationServersManagerImpl.this.findServerByLibrary(newLibrary);
            if (server != null) {
                ((ApplicationServersManagerListener)ApplicationServersManagerImpl.this.myDispatcher.getMulticaster()).serverAdded(server);
            }
        }

        public void afterLibraryRenamed(Library library) {
            ApplicationServer server = ApplicationServersManagerImpl.this.findServerByLibrary(library);
            if (server != null) {
                ((ApplicationServersManagerListener)ApplicationServersManagerImpl.this.myDispatcher.getMulticaster()).serverRenamed(server);
            }
        }

        public void beforeLibraryRemoved(Library library) {
        }

        public void afterLibraryRemoved(Library library) {
            ApplicationServer server = ApplicationServersManagerImpl.this.findServerByLibrary(library);
            if (server != null) {
                ((ApplicationServersManagerListener)ApplicationServersManagerImpl.this.myDispatcher.getMulticaster()).serverRemoved(server);
            }
        }
    }

    class ApplicationServersManagerModifiableModelImpl
    implements ApplicationServersManager.ApplicationServersManagerModifiableModel {
        private final LibraryTable.ModifiableModel myModifiableModel;
        private final List<ApplicationServer> myAdded = new ArrayList<ApplicationServer>();
        private final List<ApplicationServer> myDeleted = new ArrayList<ApplicationServer>();

        public ApplicationServersManagerModifiableModelImpl() {
            this.myModifiableModel = ApplicationServersManagerImpl.this.myLibraryTable.getModifiableModel();
        }

        public List<ApplicationServer> getCurrentList(AppServerIntegration[] integrations) {
            ArrayList<ApplicationServer> result = new ArrayList<ApplicationServer>(ApplicationServersManagerImpl.this.myServerDKs);
            result.removeAll(this.myDeleted);
            result.addAll(this.myAdded);
            return ApplicationServersManagerImpl.this.filter(integrations, result);
        }

        public ApplicationServerImpl createNewApplicationServer(String name, File[] defaultLibraries, ApplicationServerPersistentData persistentData) {
            Library library = this.myModifiableModel.createLibrary(name);
            if (defaultLibraries != null && defaultLibraries.length > 0) {
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                for (File defaultLibrary : defaultLibraries) {
                    String url = VfsUtil.getUrlForLibraryRoot((File)defaultLibrary);
                    if (!defaultLibrary.isDirectory() && !"jar".equals(VirtualFileManager.extractProtocol((String)url))) continue;
                    modifiableModel.addRoot(url, OrderRootType.CLASSES);
                }
                modifiableModel.commit();
            }
            ApplicationServerImpl result = new ApplicationServerImpl(library, persistentData);
            this.myAdded.add(result);
            return result;
        }

        public void deleteApplicationServer(ApplicationServer applicationServer) {
            if (this.myAdded.contains(applicationServer)) {
                this.myAdded.remove(applicationServer);
            } else {
                this.myDeleted.add(applicationServer);
            }
            this.myModifiableModel.removeLibrary(applicationServer.getLibrary());
            for (Library library : applicationServer.getFrameworkLibraries()) {
                this.myModifiableModel.removeLibrary(library);
            }
        }

        public void dispose() {
            for (ApplicationServer server : this.myAdded) {
                Disposer.dispose((Disposable)server.getLibrary());
                for (Library library : server.getFrameworkLibraries()) {
                    Disposer.dispose((Disposable)library);
                }
            }
        }

        public Library addFrameworkLibrary(@NotNull ApplicationServer server, @NotNull FrameworkType type, @NotNull List<File> files) {
            if (server == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$ApplicationServersManagerModifiableModelImpl", "addFrameworkLibrary"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$ApplicationServersManagerModifiableModelImpl", "addFrameworkLibrary"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$ApplicationServersManagerModifiableModelImpl", "addFrameworkLibrary"));
            }
            if (!this.getFrameworkLibraries(server, type).isEmpty()) {
                return null;
            }
            Library library = this.myModifiableModel.createLibrary(ApplicationServersManagerImpl.getFrameworkLibraryName(server, type), AppServerFrameworkLibraryType.LIBRARY_KIND);
            LibraryEx.ModifiableModelEx modifiableModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
            modifiableModel.setProperties((LibraryProperties)new AppServerFrameworkLibraryProperties(type.getId(), server.getName()));
            for (File file : files) {
                modifiableModel.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
            modifiableModel.commit();
            ((ApplicationServerImpl)server).addFrameworkLibrary(type, library);
            return library;
        }

        public void removeFrameworkLibrary(@NotNull ApplicationServer server, @NotNull FrameworkType type) {
            if (server == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$ApplicationServersManagerModifiableModelImpl", "removeFrameworkLibrary"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/j2ee/appServerIntegrations/impl/ApplicationServersManagerImpl$ApplicationServersManagerModifiableModelImpl", "removeFrameworkLibrary"));
            }
            for (Library library : this.getFrameworkLibraries(server, type)) {
                this.myModifiableModel.removeLibrary(library);
                ((ApplicationServerImpl)server).removeFrameworkLibrary(type);
            }
        }

        private List<Library> getFrameworkLibraries(ApplicationServer server, FrameworkType type) {
            ArrayList<Library> toRemove = new ArrayList<Library>();
            List<Pair<Library, AppServerFrameworkLibraryProperties>> libraries = AppServersLibraryTable.getApplicationServerFrameworkLibraries(server.getName(), this.myModifiableModel.getLibraryIterator());
            for (Pair<Library, AppServerFrameworkLibraryProperties> pair : libraries) {
                if (!((AppServerFrameworkLibraryProperties)((Object)pair.getSecond())).getFrameworkTypeId().equals(type.getId())) continue;
                toRemove.add((Library)pair.getFirst());
            }
            return toRemove;
        }

        public void commit() {
            ApplicationServersManagerImpl.this.myServerDKs.removeAll(this.myDeleted);
            ApplicationServersManagerImpl.this.myServerDKs.addAll(this.myAdded);
            this.myModifiableModel.commit();
        }

        public Library getLibrary(ApplicationServer applicationServer) {
            return applicationServer.getLibrary();
        }
    }
}

