/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.converting.artifacts;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectConverter;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

public abstract class AbstractPackagingConverter
extends ProjectConverter {
    protected final ConversionContext myContext;
    private final List<File> myCreatedFiles = new ArrayList<File>();

    public AbstractPackagingConverter(ConversionContext context) {
        this.myContext = context;
    }

    protected void saveArtifacts(Collection<ArtifactState> states) throws CannotConvertException {
        if (this.myContext.getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
            File artifactsBaseDir = new File(this.myContext.getSettingsBaseDir(), "artifacts");
            artifactsBaseDir.mkdirs();
            for (ArtifactState state : states) {
                Element element = XmlSerializer.serialize((Object)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
                File outputFile = new File(artifactsBaseDir, FileUtil.sanitizeFileName((String)state.getName()) + ".xml");
                Element root = JDomSerializationUtil.createComponentElement((String)"ArtifactManager");
                root.addContent(element);
                try {
                    JDOMUtil.writeDocument((Document)new Document(root), (File)outputFile, (String)SystemProperties.getLineSeparator());
                }
                catch (IOException e) {
                    throw new CannotConvertException("Cannot save artifacts: " + e.getMessage(), (Throwable)e);
                }
                this.myCreatedFiles.add(outputFile);
            }
        } else {
            Element root = this.myContext.getProjectSettings().getRootElement();
            Element component = JDomSerializationUtil.findOrCreateComponentElement((Element)root, (String)"ArtifactManager");
            final HashSet<String> artifactNames = new HashSet<String>();
            for (ArtifactState state : states) {
                artifactNames.add(state.getName());
            }
            JDomConvertingUtil.removeChildren((Element)component, (Condition)new Condition<Element>(){

                public boolean value(Element element) {
                    return artifactNames.contains(element.getAttributeValue("name"));
                }
            });
            for (ArtifactState state : states) {
                component.addContent(XmlSerializer.serialize((Object)state, (SerializationFilter)new SkipDefaultValuesSerializationFilters()));
            }
        }
    }

    public Collection<File> getCreatedFiles() {
        return this.myCreatedFiles;
    }

    public String expandModuleMacros(String path, ModuleSettings moduleSettings) {
        String expandedPath = moduleSettings.expandPath(path);
        String canonicalPath = PathUtil.getCanonicalPath((String)expandedPath);
        return this.myContext.collapsePath(canonicalPath != null ? canonicalPath : expandedPath);
    }

    public ConversionContext getContext() {
        return this.myContext;
    }

    public Collection<File> getAdditionalAffectedFiles() {
        if (this.myContext.getStorageScheme() == StorageScheme.DEFAULT) {
            return Collections.singletonList(this.myContext.getProjectFile());
        }
        return Collections.emptyList();
    }
}

