/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment.ui;

import com.intellij.ide.DataManager;
import com.intellij.javaee.deployment.ArtifactDeploymentSource;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSettings;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.ExternalFileDeploymentProvider;
import com.intellij.javaee.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.deployment.ModuleDeploymentSource;
import com.intellij.javaee.deployment.ui.DeploymentModelSettingsPanel;
import com.intellij.javaee.deployment.ui.actions.AddArtifactToDeployAction;
import com.intellij.javaee.deployment.ui.actions.AddArtifactToDeployActionRunnable;
import com.intellij.javaee.deployment.ui.actions.AddExternalFileToDeployAction;
import com.intellij.javaee.deployment.ui.actions.AddModuleToDeployAction;
import com.intellij.javaee.deployment.ui.actions.OpenArtifactEditorAction;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.DeploymentSettingsImpl;
import com.intellij.javaee.run.configuration.view.JavaeeRunConfigurationEditorContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class DeploymentSettingsPanel
extends SettingsEditor<CommonStrategy> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.deployment.DeploymentSettingsPanel");
    private static final Comparator<DeploymentSource> DEPLOYMENT_SOURCE_COMPARATOR = new Comparator<DeploymentSource>(){

        @Override
        public int compare(DeploymentSource o1, DeploymentSource o2) {
            return o1.getPresentableName().compareTo(o2.getPresentableName());
        }
    };
    private JPanel myMainPanel;
    private JPanel myPropertiesPanel;
    private JPanel myDeploymentModelsListPanel;
    private JBList myDeploymentModelsList;
    private final CommonStrategy myCommonModel;
    private final DeploymentProvider myDeploymentProvider;
    private final JavaeeRunConfigurationEditorContext myEditorContext;
    private final Map<DeploymentSource, DeploymentModelSettingsPanel> myPanels;
    private final Project myProject;
    private final DeployOrderHandler myDeployOrderHandler;

    public DeploymentSettingsPanel(@NotNull CommonStrategy commonModel, @NotNull DeploymentProvider deploymentProvider, @NotNull JavaeeRunConfigurationEditorContext editorContext) {
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "com/intellij/javaee/deployment/ui/DeploymentSettingsPanel", "<init>"));
        }
        if (deploymentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentProvider", "com/intellij/javaee/deployment/ui/DeploymentSettingsPanel", "<init>"));
        }
        if (editorContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorContext", "com/intellij/javaee/deployment/ui/DeploymentSettingsPanel", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myPanels = new HashMap<DeploymentSource, DeploymentModelSettingsPanel>();
        this.myCommonModel = commonModel;
        this.myProject = commonModel.getProject();
        this.myDeploymentProvider = deploymentProvider;
        this.myEditorContext = editorContext;
        this.myPropertiesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myDeployOrderHandler = deploymentProvider.isDeployOrderMatter() ? new CustomDeployOrderHandler() : new SortedDeployOrderHandler();
        this.myDeploymentModelsList = new JBList((ListModel)this.myDeployOrderHandler.createListModel());
        this.myDeploymentModelsList.getEmptyText().setText("Nothing to deploy");
        new ListSpeedSearch((JList)this.myDeploymentModelsList, (Function)new Function<Object, String>(){

            public String fun(Object o) {
                return ((DeploymentSource)o).getPresentableName();
            }
        });
        this.myDeploymentModelsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeploymentSettingsPanel.this.updateArtifactPropertiesPanel();
            }
        });
        this.myDeploymentModelsList.setCellRenderer((ListCellRenderer)new DeploymentModelListCellRenderer());
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)this.myDeploymentModelsList);
        final ExternalFileDeploymentProvider externalFileDeploymentProvider = this.myDeploymentProvider.getExternalFileDeploymentProvider();
        final boolean hasExternalProvider = externalFileDeploymentProvider != null;
        final boolean moduleDeployAllowed = this.myDeploymentProvider.isModuleDeployAllowed();
        if (!moduleDeployAllowed && !hasExternalProvider) {
            toolbarDecorator.setAddActionName("Add Artifact to Deploy");
            toolbarDecorator.setAddAction((AnActionButtonRunnable)new AddArtifactToDeployActionRunnable(this));
        } else {
            toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton anActionButton) {
                    DefaultActionGroup addGroup = new DefaultActionGroup(null, true);
                    addGroup.add((AnAction)new AddArtifactToDeployAction(DeploymentSettingsPanel.this));
                    if (hasExternalProvider) {
                        addGroup.add((AnAction)new AddExternalFileToDeployAction(DeploymentSettingsPanel.this, externalFileDeploymentProvider));
                    }
                    if (moduleDeployAllowed) {
                        addGroup.add((AnAction)new AddModuleToDeployAction(DeploymentSettingsPanel.this));
                    }
                    ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)addGroup, DataManager.getInstance().getDataContext((Component)anActionButton.getContextComponent()), JBPopupFactory.ActionSelectionAid.MNEMONICS, false);
                    listPopup.show(anActionButton.getPreferredPopupPoint());
                }
            });
        }
        toolbarDecorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                DeploymentSettingsPanel.this.removeModels(DeploymentSettingsPanel.this.getSelectedSources());
            }
        });
        OpenArtifactEditorAction openArtifactEditorAction = new OpenArtifactEditorAction(this);
        openArtifactEditorAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this.myDeploymentModelsListPanel, (Disposable)this);
        toolbarDecorator.addExtraAction((AnActionButton)openArtifactEditorAction);
        this.myDeployOrderHandler.customizeToolbarDecorator(toolbarDecorator);
        this.myDeploymentModelsListPanel.add((Component)toolbarDecorator.createPanel(), "Center");
        this.updateArtifactPropertiesPanel();
    }

    public void updateDeploymentModels() {
        HashSet<Artifact> artifacts = new HashSet<Artifact>(Arrays.asList(ArtifactManager.getInstance((Project)this.myProject).getArtifacts()));
        ArrayList<DeploymentSource> toRemove = new ArrayList<DeploymentSource>();
        for (DeploymentSource source : this.myDeployOrderHandler.getItems()) {
            if (!(source instanceof ArtifactDeploymentSource) || artifacts.contains(((ArtifactDeploymentSource)source).getArtifact())) continue;
            toRemove.add(source);
        }
        this.removeModels(toRemove);
        this.myMainPanel.revalidate();
    }

    private void updateArtifactPropertiesPanel() {
        List<DeploymentSource> selected = this.getSelectedSources();
        if (selected.size() == 1) {
            this.showCard(DeploymentSettingsPanel.getCardName(selected.get(0)));
        } else {
            this.showCard("empty");
        }
    }

    public List<DeploymentSource> getSelectedSources() {
        ArrayList<DeploymentSource> models = new ArrayList<DeploymentSource>();
        for (Object value : this.myDeploymentModelsList.getSelectedValues()) {
            models.add((DeploymentSource)value);
        }
        return models;
    }

    private static String getCardName(@NotNull DeploymentSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/deployment/ui/DeploymentSettingsPanel", "getCardName"));
        }
        return "source:" + source.getPresentableName();
    }

    private void showCard(String name) {
        ((CardLayout)this.myPropertiesPanel.getLayout()).show(this.myPropertiesPanel, name);
    }

    protected void resetEditorFrom(CommonStrategy s) {
        DeploymentSettings settings = s.getDeploymentSettings();
        List<DeploymentSource> selected = this.getSelectedSources();
        this.myDeployOrderHandler.clearItems();
        this.myPanels.clear();
        LOG.assertTrue(settings != null, (Object)this.myDeploymentProvider);
        for (DeploymentModel model : settings.getDeploymentModels()) {
            this.createPanel(s, model);
        }
        for (DeploymentSource source : selected) {
            this.myDeploymentModelsList.setSelectedValue((Object)source, true);
        }
        if (selected.isEmpty() && this.myDeploymentModelsList.getItemsCount() > 0) {
            this.myDeploymentModelsList.setSelectedIndex(0);
        }
    }

    private void createPanel(@NotNull CommonStrategy commonStrategy, @NotNull DeploymentModel model) {
        if (commonStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonStrategy", "com/intellij/javaee/deployment/ui/DeploymentSettingsPanel", "createPanel"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/javaee/deployment/ui/DeploymentSettingsPanel", "createPanel"));
        }
        DeploymentModelSettingsPanel panel = new DeploymentModelSettingsPanel(model, commonStrategy, this.myDeploymentProvider);
        Disposer.register((Disposable)this, (Disposable)panel);
        panel.loadFrom(model);
        DeploymentSource source = model.getDeploymentSource();
        this.myPanels.put(source, panel);
        this.myPropertiesPanel.add((Component)panel.getMainPanel(), DeploymentSettingsPanel.getCardName(source));
        this.myDeployOrderHandler.addItem(source);
    }

    protected void applyEditorTo(CommonStrategy s) throws ConfigurationException {
        DeploymentSettingsImpl deploymentSettings = (DeploymentSettingsImpl)s.getDeploymentSettings();
        LOG.assertTrue(deploymentSettings != null, (Object)this.myDeploymentProvider);
        HashMap<DeploymentSource, DeploymentModel> source2model = new HashMap<DeploymentSource, DeploymentModel>();
        for (DeploymentModel model : deploymentSettings.getDeploymentModels()) {
            source2model.put(model.getDeploymentSource(), model);
        }
        ArrayList<DeploymentModel> result = new ArrayList<DeploymentModel>();
        for (DeploymentSource source : this.myDeployOrderHandler.getItems()) {
            DeploymentModelSettingsPanel panel = this.myPanels.get(source);
            DeploymentModel resultModel = (DeploymentModel)source2model.remove(source);
            if (resultModel == null) {
                resultModel = this.myDeploymentProvider.createNewDeploymentModel((CommonModel)s, source);
            }
            panel.applyTo(resultModel);
            result.add(resultModel);
        }
        deploymentSettings.setModels(result);
    }

    public void markForDeployment(Artifact artifact) {
        if (this.getAddedArtifacts().contains(artifact)) {
            return;
        }
        ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)this.myProject).createPointer(artifact);
        ArtifactDeploymentSource source = JavaeeDeploymentUtil.getInstance().createArtifactDeploymentSource(pointer);
        this.addDeploymentModel((DeploymentSource)source);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/deployment/ui/DeploymentSettingsPanel", "createEditor"));
        }
        return jPanel;
    }

    public void removeModels(List<DeploymentSource> sources) {
        for (DeploymentSource source : sources) {
            this.myDeployOrderHandler.removeItem(source);
            DeploymentModelSettingsPanel panel = this.myPanels.remove(source);
            if (panel != null) {
                this.myPropertiesPanel.remove(panel.getMainPanel());
            }
            if (!(source instanceof ArtifactDeploymentSource)) continue;
            this.onArtifactDeploymentChanged((ArtifactDeploymentSource)source, false);
        }
        this.myEditorContext.fireDeploymentSettingsChanged();
    }

    public DeploymentProvider getDeploymentProvider() {
        return this.myDeploymentProvider;
    }

    public Set<Artifact> getAddedArtifacts() {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (DeploymentSource source : this.myDeployOrderHandler.getItems()) {
            if (!(source instanceof ArtifactDeploymentSource)) continue;
            ContainerUtil.addIfNotNull((Object)((ArtifactDeploymentSource)source).getArtifact(), result);
        }
        return result;
    }

    public Set<Module> getAddedModules() {
        HashSet<Module> result = new HashSet<Module>();
        for (DeploymentSource source : this.myDeployOrderHandler.getItems()) {
            if (!(source instanceof ModuleDeploymentSource)) continue;
            ContainerUtil.addIfNotNull((Object)((ModuleDeploymentSource)source).getModule(), result);
        }
        return result;
    }

    public void addDeploymentModel(DeploymentSource deploymentSource) {
        DeploymentModel model = this.myDeploymentProvider.createNewDeploymentModel((CommonModel)this.myCommonModel, deploymentSource);
        if (model == null) {
            LOG.error(this.myDeploymentProvider.getClass() + " uses deprecated 'createNewDeploymentModel' method");
            return;
        }
        CommonStrategy snapshot = this.myCommonModel;
        try {
            snapshot = this.myEditorContext.getSnapshot();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.createPanel(snapshot, model);
        this.myDeploymentModelsList.setSelectedIndices(ArrayUtil.EMPTY_INT_ARRAY);
        this.myDeploymentModelsList.setSelectedValue((Object)deploymentSource, true);
        if (deploymentSource instanceof ArtifactDeploymentSource) {
            this.onArtifactDeploymentChanged((ArtifactDeploymentSource)deploymentSource, true);
        }
        this.myEditorContext.fireDeploymentSettingsChanged();
    }

    private void onArtifactDeploymentChanged(ArtifactDeploymentSource deploymentSource, boolean added) {
        Artifact artifact = deploymentSource.getArtifact();
        if (artifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption((JComponent)this.myMainPanel, (Project)this.myProject, (Artifact)artifact, (boolean)added);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Deploy at the server startup", (int)0, (int)0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, "Center");
        this.myDeploymentModelsListPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 4, 2, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, "empty");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class CustomDeployOrderHandler
    extends DeployOrderHandlerBase<DefaultListModel> {
        private CustomDeployOrderHandler() {
        }

        @Override
        protected DefaultListModel doCreateListModel() {
            return new DefaultListModel();
        }

        @Override
        public Iterable<DeploymentSource> getItems() {
            return ContainerUtil.map((Object[])((DefaultListModel)this.getListModel()).toArray(), (Function)Functions.cast(DeploymentSource.class));
        }

        @Override
        public void clearItems() {
            ((DefaultListModel)this.getListModel()).clear();
        }

        @Override
        public void addItem(DeploymentSource item) {
            ((DefaultListModel)this.getListModel()).addElement(item);
        }

        @Override
        public void removeItem(DeploymentSource item) {
            ((DefaultListModel)this.getListModel()).removeElement(item);
        }

        @Override
        public void customizeToolbarDecorator(ToolbarDecorator toolbarDecorator) {
        }
    }

    private class SortedDeployOrderHandler
    extends DeployOrderHandlerBase<SortedListModel<DeploymentSource>> {
        private SortedDeployOrderHandler() {
        }

        @Override
        protected SortedListModel<DeploymentSource> doCreateListModel() {
            return SortedListModel.create((Comparator)DEPLOYMENT_SOURCE_COMPARATOR);
        }

        @Override
        public Iterable<DeploymentSource> getItems() {
            return ((SortedListModel)this.getListModel()).getItems();
        }

        @Override
        public void clearItems() {
            ((SortedListModel)this.getListModel()).clear();
        }

        @Override
        public void addItem(DeploymentSource item) {
            ((SortedListModel)this.getListModel()).add((Object)item);
        }

        @Override
        public void removeItem(DeploymentSource item) {
            ((SortedListModel)this.getListModel()).remove((Object)item);
        }

        @Override
        public void customizeToolbarDecorator(ToolbarDecorator toolbarDecorator) {
            toolbarDecorator.disableUpDownActions();
        }
    }

    private abstract class DeployOrderHandlerBase<T extends AbstractListModel>
    implements DeployOrderHandler {
        private T myListModel;

        private DeployOrderHandlerBase() {
        }

        @Override
        public AbstractListModel createListModel() {
            this.myListModel = this.doCreateListModel();
            return this.myListModel;
        }

        protected final T getListModel() {
            return this.myListModel;
        }

        protected abstract T doCreateListModel();
    }

    private static interface DeployOrderHandler {
        public AbstractListModel createListModel();

        public Iterable<DeploymentSource> getItems();

        public void clearItems();

        public void addItem(DeploymentSource var1);

        public void removeItem(DeploymentSource var1);

        public void customizeToolbarDecorator(ToolbarDecorator var1);
    }

    private static class DeploymentModelListCellRenderer
    extends DefaultListCellRenderer {
        private DeploymentModelListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DeploymentSource) {
                DeploymentSource source = (DeploymentSource)value;
                this.setText(source.getPresentableName());
                this.setIcon(source.getIcon());
            }
            return component;
        }
    }
}

