/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.merged;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.ManualModelMergerUtil;
import com.intellij.javaee.ejb.EjbMethod;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.EjbRootDescriptor;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.annotations.ejb.ApplicationExceptionImpl;
import com.intellij.javaee.model.annotations.ejb.EjbMethodImpl;
import com.intellij.javaee.model.annotations.ejb.EntityBeanImpl;
import com.intellij.javaee.model.annotations.ejb.InterceptorImpl;
import com.intellij.javaee.model.annotations.ejb.MessageDrivenBeanImpl;
import com.intellij.javaee.model.annotations.ejb.SessionBeanImpl;
import com.intellij.javaee.model.common.EjbReference;
import com.intellij.javaee.model.common.EnvironmentGroup;
import com.intellij.javaee.model.common.JavaeeReference;
import com.intellij.javaee.model.common.Resource;
import com.intellij.javaee.model.common.ServiceRef;
import com.intellij.javaee.model.common.ejb.ActivationConfigProperty;
import com.intellij.javaee.model.common.ejb.ApplicationException;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.CmrField;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EnterpriseBeanSet;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.common.ejb.InterceptorBinding;
import com.intellij.javaee.model.common.ejb.InterceptorMethod;
import com.intellij.javaee.model.common.ejb.InterceptorSet;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.NonEntityBean;
import com.intellij.javaee.model.common.ejb.Query;
import com.intellij.javaee.model.common.ejb.SecurityRole;
import com.intellij.javaee.model.common.ejb.SecurityRoleRef;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.CmpVersion;
import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.model.enums.ResAuth;
import com.intellij.javaee.model.enums.SessionType;
import com.intellij.javaee.model.enums.TransAttribute;
import com.intellij.javaee.model.enums.TransactionType;
import com.intellij.javaee.model.xml.Description;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.MergedObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergedEjbRootElement
extends CommonModelElement.ModuleBase
implements EjbRootElement,
MergedObject<EjbRootElement> {
    private final EjbFacet myFacet;
    private final EjbRootElement[] myTs;

    public MergedEjbRootElement(EjbFacet facet, EjbRootElement ... elements) {
        this.myFacet = facet;
        this.myTs = elements;
    }

    public List<EjbRootElement> getImplementations() {
        return Arrays.asList(this.myTs);
    }

    @NotNull
    public Module getModule() {
        Module module = this.myFacet.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement", "getModule"));
        }
        return module;
    }

    public GenericValue<String> getVersion() {
        return ManualModelMergerUtil.joinValue(Arrays.asList(this.myTs), (Function)new Function<EjbRootElement, GenericValue<String>>(){

            public GenericValue<String> fun(EjbRootElement o) {
                return o.getVersion();
            }
        });
    }

    public EnterpriseBeanSet getEnterpriseBeans() {
        return new MyEnterpriseBeanSet();
    }

    public InterceptorSet getInterceptors() {
        return new MyInterceptorSet();
    }

    public List<? extends ApplicationException> getApplicationExceptions() {
        return ManualModelMergerUtil.join((Object[])this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.AnnoJoiner<EjbRootElement, ApplicationException, PsiClass>(){

            public Collection<? extends ApplicationException> map(EjbRootElement element) {
                return element.getApplicationExceptions();
            }

            public Object key(ApplicationException e) {
                return e.getExceptionClass().getValue();
            }

            protected ApplicationException getCurrentJam(ApplicationException next, PsiClass psiMember) {
                return (ApplicationException)ApplicationExceptionImpl.APPLICATION_EXCEPTION_META.getJamElement((PsiModifierListOwner)psiMember);
            }

            @NotNull
            protected ApplicationException createMergedImplementation(ApplicationException prev, ApplicationException next) {
                MyApplicationException myApplicationException = new MyApplicationException(prev, next);
                if (myApplicationException == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$2", "createMergedImplementation"));
                }
                return myApplicationException;
            }

            protected PsiClass getPsiMember(ApplicationException element) {
                return (PsiClass)element.getExceptionClass().getValue();
            }
        });
    }

    public List<? extends SecurityRole> getSecurityRoles() {
        return ManualModelMergerUtil.join((Object[])this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.SimpleJoiner<EjbRootElement, SecurityRole>(){

            public Collection<? extends SecurityRole> map(EjbRootElement element) {
                return element.getSecurityRoles();
            }

            public Object key(SecurityRole role) {
                return role.getRoleName().getValue();
            }

            @NotNull
            protected SecurityRole createMergedImplementation(SecurityRole prev, SecurityRole next) {
                MySecurityRole mySecurityRole = new MySecurityRole(prev, next);
                if (mySecurityRole == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$3", "createMergedImplementation"));
                }
                return mySecurityRole;
            }
        });
    }

    private static class MyApplicationException
    extends ManualModelMergerUtil.MyMergedObject<ApplicationException>
    implements ApplicationException {
        public MyApplicationException(ApplicationException ... exceptions) {
            super((CommonModelElement[])exceptions);
        }

        public GenericValue<PsiClass> getExceptionClass() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<ApplicationException, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(ApplicationException e) {
                    return e.getExceptionClass();
                }
            });
        }

        public GenericValue<Boolean> getRollback() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<ApplicationException, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(ApplicationException e) {
                    return e.getRollback();
                }
            });
        }
    }

    public static class MySecurityRoleRef
    extends ManualModelMergerUtil.MyMergedObject<SecurityRoleRef>
    implements SecurityRoleRef {
        MySecurityRoleRef(SecurityRoleRef ... references) {
            super((CommonModelElement[])references);
        }

        public GenericValue<String> getRoleName() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<SecurityRoleRef, GenericValue<String>>(){

                public GenericValue<String> fun(SecurityRoleRef ref) {
                    return ref.getRoleName();
                }
            });
        }

        public GenericValue<String> getRoleLink() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<SecurityRoleRef, GenericValue<String>>(){

                public GenericValue<String> fun(SecurityRoleRef ref) {
                    return ref.getRoleLink();
                }
            });
        }
    }

    public static class MySecurityRole
    extends ManualModelMergerUtil.MyMergedObject<SecurityRole>
    implements SecurityRole {
        MySecurityRole(SecurityRole ... roles) {
            super((CommonModelElement[])roles);
        }

        public GenericValue<String> getRoleName() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<SecurityRole, GenericValue<String>>(){

                public GenericValue<String> fun(SecurityRole role) {
                    return role.getRoleName();
                }
            });
        }
    }

    public static class MyEjbMethod
    extends ManualModelMergerUtil.MyMergedObject<EjbMethod>
    implements EjbMethod {
        private MyEjbMethod(EjbMethod ... methods) {
            super((CommonModelElement[])methods);
        }

        public GenericValue<String> getInit() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbMethod, GenericValue<String>>(){

                public GenericValue<String> fun(EjbMethod t) {
                    return t.getInit();
                }
            });
        }

        public GenericValue<Boolean> isRetainIfException() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbMethod, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(EjbMethod t) {
                    return t.isRetainIfException();
                }
            });
        }

        public GenericValue<Boolean> isRemoveMethod() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbMethod, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(EjbMethod t) {
                    return t.isRemoveMethod();
                }
            });
        }

        public GenericValue<TransAttribute> getTransactionAttribute() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbMethod, GenericValue<TransAttribute>>(){

                public GenericValue<TransAttribute> fun(EjbMethod t) {
                    return t.getTransactionAttribute();
                }
            });
        }

        public GenericValue<Boolean> isExcludeClassInterceptors() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbMethod, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(EjbMethod t) {
                    return t.isExcludeClassInterceptors();
                }
            });
        }

        public GenericValue<Boolean> isExcludeDefaultInterceptors() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbMethod, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(EjbMethod t) {
                    return t.isExcludeDefaultInterceptors();
                }
            });
        }

        public List<? extends GenericValue<PsiClass>> getMethodInterceptors() {
            return ManualModelMergerUtil.joinValues((Iterable)this.myTs, (Function)new Function<EjbMethod, Collection<? extends GenericValue<PsiClass>>>(){

                public Collection<? extends GenericValue<PsiClass>> fun(EjbMethod t) {
                    return t.getMethodInterceptors();
                }
            });
        }

        public GenericValue<Boolean> isTimeoutMethod() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbMethod, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(EjbMethod t) {
                    return t.isTimeoutMethod();
                }
            });
        }

        public GenericValue<Boolean> isExcluded() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbMethod, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(EjbMethod t) {
                    return t.isExcluded();
                }
            });
        }

        public PsiMethod getPsiMethod() {
            return ((EjbMethod)this.myTs.get(0)).getPsiMethod();
        }

        public GenericValue<Boolean> isPermitAll() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbMethod, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(EjbMethod t) {
                    return t.isPermitAll();
                }
            });
        }

        public GenericValue<Boolean> isDenyAll() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbMethod, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(EjbMethod t) {
                    return t.isDenyAll();
                }
            });
        }

        public Collection<? extends GenericValue<? extends SecurityRole>> getRolesAllowed() {
            return ManualModelMergerUtil.join((Iterable)this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.NextJoiner<EjbMethod, GenericValue<? extends SecurityRole>>(){

                public Collection<? extends GenericValue<? extends SecurityRole>> map(EjbMethod method) {
                    return method.getRolesAllowed();
                }

                public Object key(GenericValue<? extends SecurityRole> value) {
                    return value.getStringValue();
                }
            });
        }
    }

    public static class MyServiceRef
    extends MyJavaeeReference<ServiceRef>
    implements ServiceRef {
        MyServiceRef(ServiceRef ... refs) {
            super((JavaeeReference[])refs);
        }

        public GenericValue<PsiClass> getType() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<ServiceRef, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(ServiceRef t) {
                    return t.getType();
                }
            });
        }

        public GenericValue<PsiClass> getValue() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<ServiceRef, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(ServiceRef t) {
                    return t.getValue();
                }
            });
        }

        public GenericValue<String> getWsdlLocation() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<ServiceRef, GenericValue<String>>(){

                public GenericValue<String> fun(ServiceRef t) {
                    return t.getWsdlLocation();
                }
            });
        }
    }

    public static class MyResource
    extends MyJavaeeReference<Resource>
    implements Resource {
        MyResource(Resource ... resources) {
            super((JavaeeReference[])resources);
        }

        public GenericValue<PsiClass> getType() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<Resource, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(Resource t) {
                    return t.getType();
                }
            });
        }

        public GenericValue<ResAuth> getAuthenticationType() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<Resource, GenericValue<ResAuth>>(){

                public GenericValue<ResAuth> fun(Resource t) {
                    return t.getAuthenticationType();
                }
            });
        }

        public GenericValue<Boolean> isShareable() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<Resource, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(Resource t) {
                    return t.isShareable();
                }
            });
        }

        public GenericValue<String> getDescription() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<Resource, GenericValue<String>>(){

                public GenericValue<String> fun(Resource t) {
                    return t.getDescription();
                }
            });
        }

        public GenericValue<String> getLookup() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<Resource, GenericValue<String>>(){

                public GenericValue<String> fun(Resource t) {
                    return t.getLookup();
                }
            });
        }
    }

    public static class MyEjbReference
    extends MyJavaeeReference<EjbReference>
    implements EjbReference {
        MyEjbReference(EjbReference ... references) {
            super((JavaeeReference[])references);
        }

        public GenericValue<PsiClass> getBeanInterface() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EjbReference, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(EjbReference t) {
                    return t.getBeanInterface();
                }
            });
        }

        public GenericValue<EnterpriseBean> getEjbLink() {
            return (GenericValue)ManualModelMergerUtil.findLast((List)this.myTs, (Function)new NullableFunction<EjbReference, GenericValue<EnterpriseBean>>(){

                public GenericValue<EnterpriseBean> fun(EjbReference reference) {
                    return reference.getEjbLink();
                }
            }, null);
        }

        public List<Description> getDescriptions() {
            return ContainerUtil.concat((Iterable)this.myTs, (Function)new Function<EjbReference, Collection<? extends Description>>(){

                public Collection<? extends Description> fun(EjbReference reference) {
                    return reference.getDescriptions();
                }
            });
        }

        public Description addDescription() {
            return (Description)ManualModelMergerUtil.findLast((List)this.myTs, (Function)new Function<EjbReference, Description>(){

                public Description fun(EjbReference reference) {
                    return reference.addDescription();
                }
            }, null);
        }
    }

    public static class MyJavaeeReference<T extends JavaeeReference>
    extends ManualModelMergerUtil.MyMergedObject<T>
    implements JavaeeReference {
        MyJavaeeReference(T ... ts) {
            super(ts);
        }

        public GenericValue<String> getName() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<String>>(){

                public GenericValue<String> fun(T t) {
                    return t.getName();
                }
            });
        }

        public GenericValue<String> getMappedName() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<String>>(){

                public GenericValue<String> fun(T t) {
                    return t.getMappedName();
                }
            });
        }

        public List<? extends GenericValue<PsiMember>> getTargetMembers() {
            return ManualModelMergerUtil.join((Iterable)this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.NextJoiner<T, GenericValue<PsiMember>>(){

                public Collection<? extends GenericValue<PsiMember>> map(T t) {
                    return t.getTargetMembers();
                }

                public Object key(GenericValue<PsiMember> value) {
                    return value.getStringValue();
                }
            });
        }
    }

    public static class MyInterceptor
    extends MyEnvironmentGroup<Interceptor>
    implements Interceptor {
        MyInterceptor(Interceptor ... interceptors) {
            super((EnvironmentGroup[])interceptors);
        }

        public GenericValue<PsiClass> getInterceptorClass() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<Interceptor, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(Interceptor interceptor) {
                    return interceptor.getInterceptorClass();
                }
            });
        }

        public void processInterceptorBindings(Processor<InterceptorBinding> processor) {
            for (Interceptor t : this.myTs) {
                t.processInterceptorBindings(processor);
            }
        }

        public void processInterceptorMethods(@Nullable PsiClass currentClass, Processor<InterceptorMethod> processor) {
            for (Interceptor t : this.myTs) {
                t.processInterceptorMethods(currentClass, processor);
            }
        }
    }

    public static class MyEntityBean
    extends MyEnterpriseBean<EntityBean>
    implements EntityBean {
        private MyEntityBean(EntityBean ... entityBeans) {
            super((EnterpriseBean[])entityBeans);
        }

        public GenericValue<PersistenceType> getPersistenceType() {
            return (GenericValue)ManualModelMergerUtil.findDom((Iterable)this.myTs, (Function)new Function<EntityBean, GenericValue<PersistenceType>>(){

                public GenericValue<PersistenceType> fun(EntityBean bean) {
                    return bean.getPersistenceType();
                }
            }, AnnotationGenericValue.nullInstance());
        }

        public GenericValue<PsiClass> getPrimKeyClass() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EntityBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(EntityBean bean) {
                    return bean.getPrimKeyClass();
                }
            });
        }

        public GenericValue<Boolean> getReentrant() {
            return (GenericValue)ManualModelMergerUtil.findDom((Iterable)this.myTs, (Function)new Function<EntityBean, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(EntityBean bean) {
                    return bean.getReentrant();
                }
            }, AnnotationGenericValue.nullInstance());
        }

        public GenericValue<CmpVersion> getCmpVersion() {
            return (GenericValue)ManualModelMergerUtil.findDom((Iterable)this.myTs, (Function)new Function<EntityBean, GenericValue<CmpVersion>>(){

                public GenericValue<CmpVersion> fun(EntityBean bean) {
                    return bean.getCmpVersion();
                }
            }, AnnotationGenericValue.nullInstance());
        }

        public GenericValue<String> getAbstractSchemaName() {
            return (GenericValue)ManualModelMergerUtil.findDom((Iterable)this.myTs, (Function)new Function<EntityBean, GenericValue<String>>(){

                public GenericValue<String> fun(EntityBean bean) {
                    return bean.getAbstractSchemaName();
                }
            }, AnnotationGenericValue.nullInstance());
        }

        public GenericValue<CmpField> getPrimkeyField() {
            return (GenericValue)ManualModelMergerUtil.findDom((Iterable)this.myTs, (Function)new Function<EntityBean, GenericValue<CmpField>>(){

                public GenericValue<CmpField> fun(EntityBean bean) {
                    return bean.getPrimkeyField();
                }
            }, AnnotationGenericValue.nullInstance());
        }

        public List<? extends CmpField> getCmpFields() {
            return (List)ManualModelMergerUtil.findDom((Iterable)this.myTs, (Function)new Function<EntityBean, List<? extends CmpField>>(){

                public List<? extends CmpField> fun(EntityBean bean) {
                    return bean.getCmpFields();
                }
            }, Collections.emptyList());
        }

        public List<? extends CmrField> getCmrFields() {
            return (List)ManualModelMergerUtil.findDom((Iterable)this.myTs, (Function)new Function<EntityBean, List<? extends CmrField>>(){

                public List<? extends CmrField> fun(EntityBean bean) {
                    return bean.getCmrFields();
                }
            }, Collections.emptyList());
        }

        public List<? extends Query> getQueries() {
            return (List)ManualModelMergerUtil.findDom((Iterable)this.myTs, (Function)new Function<EntityBean, List<? extends Query>>(){

                public List<? extends Query> fun(EntityBean bean) {
                    return bean.getQueries();
                }
            }, Collections.emptyList());
        }

        public List<? extends SecurityRoleRef> getSecurityRoleRefs() {
            return ManualModelMergerUtil.join((Iterable)this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.SimpleJoiner<EntityBean, SecurityRoleRef>(){

                public Collection<? extends SecurityRoleRef> map(EntityBean bean) {
                    return bean.getSecurityRoleRefs();
                }

                public Object key(SecurityRoleRef ref) {
                    return ref.getRoleName().getValue();
                }

                @NotNull
                protected SecurityRoleRef createMergedImplementation(SecurityRoleRef prev, SecurityRoleRef next) {
                    MySecurityRoleRef mySecurityRoleRef = new MySecurityRoleRef(prev, next);
                    if (mySecurityRoleRef == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyEntityBean$10", "createMergedImplementation"));
                    }
                    return mySecurityRoleRef;
                }
            });
        }

        public GenericValue<PsiClass> getHome() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EntityBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(EntityBean bean) {
                    return bean.getHome();
                }
            });
        }

        public GenericValue<PsiClass> getRemote() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EntityBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(EntityBean bean) {
                    return bean.getRemote();
                }
            });
        }

        public GenericValue<PsiClass> getLocalHome() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EntityBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(EntityBean bean) {
                    return bean.getLocalHome();
                }
            });
        }

        public GenericValue<PsiClass> getLocal() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<EntityBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(EntityBean bean) {
                    return bean.getLocal();
                }
            });
        }
    }

    public static class MyMessageDrivenBean
    extends MyNonEntityBean<MessageDrivenBean>
    implements MessageDrivenBean {
        MyMessageDrivenBean(MessageDrivenBean ... messageDrivenBeans) {
            super((NonEntityBean[])messageDrivenBeans);
        }

        public GenericValue<PsiClass> getMessageListenerInterface() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<MessageDrivenBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(MessageDrivenBean bean) {
                    return bean.getMessageListenerInterface();
                }
            });
        }

        public List<? extends ActivationConfigProperty> getActivationConfigProperties() {
            return ManualModelMergerUtil.join((Iterable)this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.NextJoiner<MessageDrivenBean, ActivationConfigProperty>(){

                public Collection<? extends ActivationConfigProperty> map(MessageDrivenBean bean) {
                    return bean.getActivationConfigProperties();
                }

                public Object key(ActivationConfigProperty property) {
                    return property.getPropertyName().getValue();
                }
            });
        }
    }

    public static class MySessionBean
    extends MyNonEntityBean<SessionBean>
    implements SessionBean {
        MySessionBean(SessionBean ... sessionBeans) {
            super((NonEntityBean[])sessionBeans);
        }

        public GenericValue<SessionType> getSessionType() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<SessionBean, GenericValue<SessionType>>(){

                public GenericValue<SessionType> fun(SessionBean bean) {
                    return bean.getSessionType();
                }
            });
        }

        public GenericValue<Boolean> getLocalBean() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<SessionBean, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(SessionBean bean) {
                    return bean.getLocalBean();
                }
            });
        }

        public GenericValue<PsiClass> getServiceEndpoint() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<SessionBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(SessionBean bean) {
                    return bean.getServiceEndpoint();
                }
            });
        }

        public List<? extends GenericValue<PsiClass>> getBusinessLocals() {
            return ManualModelMergerUtil.joinValues((Iterable)this.myTs, (Function)new Function<SessionBean, Collection<? extends GenericValue<PsiClass>>>(){

                public Collection<? extends GenericValue<PsiClass>> fun(SessionBean bean) {
                    return bean.getBusinessLocals();
                }
            });
        }

        public List<? extends GenericValue<PsiClass>> getBusinessRemotes() {
            return ManualModelMergerUtil.joinValues((Iterable)this.myTs, (Function)new Function<SessionBean, Collection<? extends GenericValue<PsiClass>>>(){

                public Collection<? extends GenericValue<PsiClass>> fun(SessionBean bean) {
                    return bean.getBusinessRemotes();
                }
            });
        }

        public List<? extends SecurityRoleRef> getSecurityRoleRefs() {
            return ManualModelMergerUtil.join((Iterable)this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.SimpleJoiner<SessionBean, SecurityRoleRef>(){

                public Collection<? extends SecurityRoleRef> map(SessionBean bean) {
                    return bean.getSecurityRoleRefs();
                }

                public Object key(SecurityRoleRef ref) {
                    return ref.getRoleName().getValue();
                }

                @NotNull
                protected SecurityRoleRef createMergedImplementation(SecurityRoleRef prev, SecurityRoleRef next) {
                    MySecurityRoleRef mySecurityRoleRef = new MySecurityRoleRef(prev, next);
                    if (mySecurityRoleRef == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MySessionBean$6", "createMergedImplementation"));
                    }
                    return mySecurityRoleRef;
                }
            });
        }

        public GenericValue<PsiClass> getHome() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<SessionBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(SessionBean bean) {
                    return bean.getHome();
                }
            });
        }

        public GenericValue<PsiClass> getRemote() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<SessionBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(SessionBean bean) {
                    return bean.getRemote();
                }
            });
        }

        public GenericValue<PsiClass> getLocalHome() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<SessionBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(SessionBean bean) {
                    return bean.getLocalHome();
                }
            });
        }

        public GenericValue<PsiClass> getLocal() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<SessionBean, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(SessionBean bean) {
                    return bean.getLocal();
                }
            });
        }
    }

    public static class MyNonEntityBean<T extends NonEntityBean>
    extends MyEnterpriseBean<T>
    implements NonEntityBean {
        MyNonEntityBean(T ... ts) {
            super(ts);
        }

        public GenericValue<TransactionType> getTransactionManagementType() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<TransactionType>>(){

                public GenericValue<TransactionType> fun(T t) {
                    return t.getTransactionManagementType();
                }
            });
        }
    }

    public static class MyEnterpriseBean<T extends EnterpriseBean>
    extends MyEnvironmentGroup<T>
    implements EnterpriseBean {
        MyEnterpriseBean(T ... ts) {
            super(ts);
        }

        @NotNull
        public EjbDescriptorVersion getEjbVersion() {
            EjbDescriptorVersion ejbDescriptorVersion = (EjbDescriptorVersion)ManualModelMergerUtil.findLast((List)this.myTs, (Function)new Function<T, EjbDescriptorVersion>(){

                public EjbDescriptorVersion fun(T t) {
                    return t.getEjbVersion();
                }
            }, (Object)EjbDescriptorVersion.getEjbDescriptorVersion((String)EjbRootDescriptor.EJB_JAR_META_DATA.getDefaultVersion().getName()));
            if (ejbDescriptorVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyEnterpriseBean", "getEjbVersion"));
            }
            return ejbDescriptorVersion;
        }

        public GenericValue<String> getEjbName() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<String>>(){

                public GenericValue<String> fun(T t) {
                    return t.getEjbName();
                }
            });
        }

        public GenericValue<PsiClass> getEjbClass() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<PsiClass>>(){

                public GenericValue<PsiClass> fun(T t) {
                    return t.getEjbClass();
                }
            });
        }

        public GenericValue<TransAttribute> getTransactionAttribute() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<TransAttribute>>(){

                public GenericValue<TransAttribute> fun(T t) {
                    return t.getTransactionAttribute();
                }
            });
        }

        public GenericValue<SecurityRole> getRunAs() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<SecurityRole>>(){

                public GenericValue<SecurityRole> fun(T t) {
                    return t.getRunAs();
                }
            });
        }

        public List<? extends GenericValue<SecurityRole>> getDeclaredRoles() {
            return ManualModelMergerUtil.joinValues((Iterable)this.myTs, (Function)new Function<T, Collection<? extends GenericValue<SecurityRole>>>(){

                public Collection<? extends GenericValue<SecurityRole>> fun(T t) {
                    return t.getDeclaredRoles();
                }
            });
        }

        public GenericValue<Boolean> isExcludeDefaultInterceptors() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(T t) {
                    return t.isExcludeDefaultInterceptors();
                }
            });
        }

        public List<GenericValue<PsiClass>> getClassInterceptors() {
            return ManualModelMergerUtil.joinValues((Iterable)this.myTs, (Function)new Function<T, Collection<? extends GenericValue<PsiClass>>>(){

                public Collection<? extends GenericValue<PsiClass>> fun(T t) {
                    return t.getClassInterceptors();
                }
            });
        }

        public GenericValue<PsiMethod> getTimeoutMethodValue() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<PsiMethod>>(){

                public GenericValue<PsiMethod> fun(T t) {
                    return t.getTimeoutMethodValue();
                }
            });
        }

        public List<? extends GenericValue<PsiClass>> getBusinessInterfaces() {
            return ManualModelMergerUtil.joinValues((Iterable)this.myTs, (Function)new Function<T, Collection<? extends GenericValue<PsiClass>>>(){

                public Collection<? extends GenericValue<PsiClass>> fun(T t) {
                    return t.getBusinessInterfaces();
                }
            });
        }

        public List<? extends EjbMethod> getEjbMethods() {
            return ManualModelMergerUtil.join((Iterable)this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.AnnoJoiner<T, EjbMethod, PsiMethod>(){

                public Collection<? extends EjbMethod> map(T t) {
                    return t.getEjbMethods();
                }

                public Object key(EjbMethod method) {
                    return method.getPsiMethod();
                }

                protected EjbMethod getCurrentJam(EjbMethod next, PsiMethod psiMember) {
                    return (EjbMethod)EjbMethodImpl.METHOD_META.getJamElement((PsiModifierListOwner)psiMember);
                }

                @NotNull
                protected EjbMethod createMergedImplementation(EjbMethod prev, EjbMethod next) {
                    MyEjbMethod myEjbMethod = new MyEjbMethod(new EjbMethod[]{prev, next});
                    if (myEjbMethod == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyEnterpriseBean$11", "createMergedImplementation"));
                    }
                    return myEjbMethod;
                }

                protected PsiMethod getPsiMember(EjbMethod element) {
                    return element.getPsiMethod();
                }
            });
        }

        public GenericValue<Boolean> isPermitAll() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(T t) {
                    return t.isPermitAll();
                }
            });
        }

        public GenericValue<Boolean> isDenyAll() {
            return ManualModelMergerUtil.joinValue((Iterable)this.myTs, (Function)new Function<T, GenericValue<Boolean>>(){

                public GenericValue<Boolean> fun(T t) {
                    return t.isDenyAll();
                }
            });
        }

        public Collection<? extends GenericValue<? extends SecurityRole>> getRolesAllowed() {
            return ManualModelMergerUtil.join((Iterable)this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.NextJoiner<T, GenericValue<? extends SecurityRole>>(){

                public Collection<? extends GenericValue<? extends SecurityRole>> map(T t) {
                    return t.getRolesAllowed();
                }

                public Object key(GenericValue<? extends SecurityRole> value) {
                    return value.getStringValue();
                }
            });
        }

        public void processInterceptorMethods(@Nullable PsiClass currentClass, Processor<InterceptorMethod> processor) {
            for (EnterpriseBean t : this.myTs) {
                t.processInterceptorMethods(currentClass, processor);
            }
        }
    }

    public static class MyEnvironmentGroup<T extends EnvironmentGroup>
    extends ManualModelMergerUtil.MyMergedObject<T>
    implements EnvironmentGroup {
        MyEnvironmentGroup(T ... ts) {
            super(ts);
        }

        public List<? extends EjbReference> getEjbReferences() {
            return ManualModelMergerUtil.join((Iterable)this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.SimpleJoiner<T, EjbReference>(){

                public Collection<? extends EjbReference> map(T t) {
                    return t.getEjbReferences();
                }

                public Object key(EjbReference reference) {
                    return reference.getName().getStringValue();
                }

                @NotNull
                protected EjbReference createMergedImplementation(EjbReference prev, EjbReference next) {
                    MyEjbReference myEjbReference = new MyEjbReference(prev, next);
                    if (myEjbReference == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyEnvironmentGroup$1", "createMergedImplementation"));
                    }
                    return myEjbReference;
                }
            });
        }

        public List<? extends Resource> getResources() {
            return ManualModelMergerUtil.join((Iterable)this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.SimpleJoiner<T, Resource>(){

                public Collection<? extends Resource> map(T t) {
                    return t.getResources();
                }

                public Object key(Resource resource) {
                    return resource.getName().getStringValue();
                }

                @NotNull
                protected Resource createMergedImplementation(Resource prev, Resource next) {
                    MyResource myResource = new MyResource(prev, next);
                    if (myResource == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyEnvironmentGroup$2", "createMergedImplementation"));
                    }
                    return myResource;
                }
            });
        }

        public List<? extends ServiceRef> getServiceRefs() {
            return ManualModelMergerUtil.join((Iterable)this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.SimpleJoiner<T, ServiceRef>(){

                public Collection<? extends ServiceRef> map(T t) {
                    return t.getServiceRefs();
                }

                public Object key(ServiceRef ref) {
                    return ref.getName().getStringValue();
                }

                @NotNull
                protected ServiceRef createMergedImplementation(ServiceRef prev, ServiceRef next) {
                    MyServiceRef myServiceRef = new MyServiceRef(prev, next);
                    if (myServiceRef == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyEnvironmentGroup$3", "createMergedImplementation"));
                    }
                    return myServiceRef;
                }
            });
        }
    }

    public class MyInterceptorSet
    extends CommonModelElement.ModuleBase
    implements InterceptorSet,
    MergedObject<InterceptorSet> {
        @NotNull
        public Module getModule() {
            Module module = MergedEjbRootElement.this.myFacet.getModule();
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyInterceptorSet", "getModule"));
            }
            return module;
        }

        public List<InterceptorSet> getImplementations() {
            return ContainerUtil.map((Object[])MergedEjbRootElement.this.myTs, (Function)new Function<EjbRootElement, InterceptorSet>(){

                public InterceptorSet fun(EjbRootElement ejbRootElement) {
                    return ejbRootElement.getInterceptors();
                }
            });
        }

        public List<? extends Interceptor> getInterceptors() {
            return ManualModelMergerUtil.join((Object[])MergedEjbRootElement.this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.AnnoJoiner<EjbRootElement, Interceptor, PsiClass>(){

                public Collection<? extends Interceptor> map(EjbRootElement element) {
                    return element.getInterceptors().getInterceptors();
                }

                public Object key(Interceptor interceptor) {
                    return interceptor.getInterceptorClass().getValue();
                }

                protected Interceptor getCurrentJam(Interceptor next, PsiClass psiMember) {
                    return (Interceptor)InterceptorImpl.INTERCEPTOR_META.getJamElement((PsiModifierListOwner)psiMember);
                }

                @NotNull
                protected Interceptor createMergedImplementation(Interceptor prev, Interceptor next) {
                    MyInterceptor myInterceptor = new MyInterceptor(prev, next);
                    if (myInterceptor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyInterceptorSet$2", "createMergedImplementation"));
                    }
                    return myInterceptor;
                }

                protected PsiClass getPsiMember(Interceptor element) {
                    return (PsiClass)element.getInterceptorClass().getValue();
                }
            });
        }
    }

    public class MyEnterpriseBeanSet
    extends CommonModelElement.ModuleBase
    implements EnterpriseBeanSet,
    MergedObject<EnterpriseBeanSet> {
        @NotNull
        public Module getModule() {
            Module module = MergedEjbRootElement.this.myFacet.getModule();
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyEnterpriseBeanSet", "getModule"));
            }
            return module;
        }

        public List<EnterpriseBeanSet> getImplementations() {
            return ContainerUtil.map((Object[])MergedEjbRootElement.this.myTs, (Function)new Function<EjbRootElement, EnterpriseBeanSet>(){

                public EnterpriseBeanSet fun(EjbRootElement ejbRootElement) {
                    return ejbRootElement.getEnterpriseBeans();
                }
            });
        }

        public List<? extends SessionBean> getSessions() {
            return ManualModelMergerUtil.join((Object[])MergedEjbRootElement.this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.AnnoJoiner<EjbRootElement, SessionBean, PsiClass>(){

                public Collection<? extends SessionBean> map(EjbRootElement o) {
                    return o.getEnterpriseBeans().getSessions();
                }

                public Object key(SessionBean t) {
                    return t.getEjbName().getValue();
                }

                protected SessionBean getCurrentJam(SessionBean next, PsiClass psiMember) {
                    SessionBeanImpl.Stateful stateful = (SessionBeanImpl.Stateful)SessionBeanImpl.STATEFUL_META.getJamElement((PsiModifierListOwner)psiMember);
                    return stateful != null ? stateful : (SessionBean)SessionBeanImpl.STATELESS_META.getJamElement((PsiModifierListOwner)psiMember);
                }

                @NotNull
                protected SessionBean createMergedImplementation(SessionBean prev, SessionBean next) {
                    MySessionBean mySessionBean = new MySessionBean(prev, next);
                    if (mySessionBean == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyEnterpriseBeanSet$2", "createMergedImplementation"));
                    }
                    return mySessionBean;
                }

                protected PsiClass getPsiMember(SessionBean element) {
                    return (PsiClass)element.getEjbClass().getValue();
                }
            });
        }

        public List<? extends EntityBean> getEntities() {
            return ManualModelMergerUtil.join((Object[])MergedEjbRootElement.this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.AnnoJoiner<EjbRootElement, EntityBean, PsiClass>(){

                public Collection<? extends EntityBean> map(EjbRootElement o) {
                    return o.getEnterpriseBeans().getEntities();
                }

                public Object key(EntityBean t) {
                    return t.getEjbName().getValue();
                }

                protected EntityBean getCurrentJam(EntityBean next, PsiClass psiMember) {
                    return (EntityBean)EntityBeanImpl.ENTITY_META.getJamElement((PsiModifierListOwner)psiMember);
                }

                @NotNull
                protected EntityBean createMergedImplementation(EntityBean prev, EntityBean next) {
                    MyEntityBean myEntityBean = new MyEntityBean(new EntityBean[]{prev, next});
                    if (myEntityBean == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyEnterpriseBeanSet$3", "createMergedImplementation"));
                    }
                    return myEntityBean;
                }

                protected PsiClass getPsiMember(EntityBean element) {
                    return (PsiClass)element.getEjbClass().getValue();
                }
            });
        }

        public List<? extends MessageDrivenBean> getMessageDrivens() {
            return ManualModelMergerUtil.join((Object[])MergedEjbRootElement.this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.AnnoJoiner<EjbRootElement, MessageDrivenBean, PsiClass>(){

                public Collection<? extends MessageDrivenBean> map(EjbRootElement o) {
                    return o.getEnterpriseBeans().getMessageDrivens();
                }

                public Object key(MessageDrivenBean t) {
                    return t.getEjbName().getValue();
                }

                protected MessageDrivenBean getCurrentJam(MessageDrivenBean next, PsiClass psiMember) {
                    return (MessageDrivenBean)MessageDrivenBeanImpl.MDB_META.getJamElement((PsiModifierListOwner)psiMember);
                }

                @NotNull
                protected MessageDrivenBean createMergedImplementation(MessageDrivenBean prev, MessageDrivenBean next) {
                    MyMessageDrivenBean myMessageDrivenBean = new MyMessageDrivenBean(prev, next);
                    if (myMessageDrivenBean == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/merged/MergedEjbRootElement$MyEnterpriseBeanSet$4", "createMergedImplementation"));
                    }
                    return myMessageDrivenBean;
                }

                protected PsiClass getPsiMember(MessageDrivenBean element) {
                    return (PsiClass)element.getEjbClass().getValue();
                }
            });
        }

        public List<? extends GenericValue<PsiClass>> getDefaultInterceptors() {
            return ManualModelMergerUtil.join((Object[])MergedEjbRootElement.this.myTs, (ManualModelMergerUtil.Joiner)new ManualModelMergerUtil.NextJoiner<EjbRootElement, GenericValue<PsiClass>>(){

                public Collection<? extends GenericValue<PsiClass>> map(EjbRootElement ejbRootElement) {
                    return ejbRootElement.getEnterpriseBeans().getDefaultInterceptors();
                }

                public Object key(GenericValue<PsiClass> t) {
                    return t.getValue();
                }
            });
        }
    }
}

