/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.editor;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.module.components.FrameworkElementAsVirtualFileImpl;
import com.intellij.javaee.module.components.FrameworkVirtualFileSystem;
import com.intellij.javaee.module.view.ejb.editor.EjbAsVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.util.JavaeeIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class EjbAsVirtualFileImpl
extends FrameworkElementAsVirtualFileImpl<EjbFacet>
implements EjbAsVirtualFile {
    @NonNls
    public static final String ENTITY_TYPE = "EntityEjb";
    @NonNls
    public static final String SESSION_TYPE = "SessionEjb";
    @NonNls
    public static final String MESSAGE_TYPE = "MessageEjb";

    EjbAsVirtualFileImpl(FacetPointer<EjbFacet> facetPointer, String type, String elementName) {
        super(facetPointer, type, elementName);
    }

    @Nullable
    public EnterpriseBean findElement(Project project) {
        JavaeeFacet facet = (JavaeeFacet)this.findFacet();
        if (facet == null) {
            return null;
        }
        return EjbUtil.findEjbByName(facet.getModule(), this.getElementName());
    }

    @Override
    public String getPresentableName() {
        String type = this.myElementType.equals(SESSION_TYPE) ? J2EEBundle.message((String)"ejb.type.session.bean", (Object[])new Object[0]) : (this.myElementType.equals(ENTITY_TYPE) ? J2EEBundle.message((String)"ejb.type.entity.bean", (Object[])new Object[0]) : (this.myElementType.equals(MESSAGE_TYPE) ? J2EEBundle.message((String)"ejb.type.message.driven.bean", (Object[])new Object[0]) : null));
        return type + " '" + this.getElementName() + "'";
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myElementType.equals(SESSION_TYPE) ? JavaeeIcons.SESSION_BEAN : (this.myElementType.equals(ENTITY_TYPE) ? JavaeeIcons.ENTITY_BEAN : (this.myElementType.equals(MESSAGE_TYPE) ? JavaeeIcons.MESSAGE_BEAN : null));
    }

    @Nullable
    public static EjbAsVirtualFileImpl findFile(EnterpriseBean ejb) {
        if (!ejb.isValid()) {
            return null;
        }
        EjbFacet ejbFacet = EjbModuleUtil.getEjbFacet((JavaeeModelElement)ejb);
        if (ejbFacet == null) {
            return null;
        }
        String name = (String)ejb.getEjbName().getValue();
        String type = ejb instanceof EntityBean ? ENTITY_TYPE : (ejb instanceof SessionBean ? SESSION_TYPE : (ejb instanceof MessageDrivenBean ? MESSAGE_TYPE : null));
        String path = EjbAsVirtualFileImpl.getPath((Facet)ejbFacet, type, name);
        return (EjbAsVirtualFileImpl)FrameworkVirtualFileSystem.getJ2EEInstance().findFileByPath(path);
    }
}

