/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.javaee.model.jam.JamServlet;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.module.view.nodes.FileNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeObjectDescriptor;
import com.intellij.javaee.module.view.nodes.PsiNamedElementNodeDescriptor;
import com.intellij.javaee.module.view.web.editor.ServletAsVirtualFileImpl;
import com.intellij.javaee.module.view.web.nodes.ServletClassNodeDescriptor;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebUtil;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ServletNodeDescriptor
extends JavaeeObjectDescriptor<CommonServlet> {
    public ServletNodeDescriptor(CommonServlet servlet, NodeDescriptor parentDescriptor, Object parameters) {
        super((CommonModelElement)servlet, parentDescriptor, parameters);
    }

    protected String getNewNodeTextExt() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        CommonServlet servlet = (CommonServlet)this.getElement();
        for (GenericValue value : servlet.getUrlPatterns()) {
            String s = value.getStringValue();
            if (!StringUtil.isNotEmpty((String)s)) continue;
            if (!first) {
                result.append(';');
            }
            first = false;
            result.append(s);
        }
        return result.toString();
    }

    public String getNewNodeText() {
        return (String)((CommonServlet)this.getElement()).getServletName().getValue();
    }

    public JavaeeNodeDescriptor[] getChildren() {
        JspFile jspFile;
        CommonServlet servlet = (CommonServlet)this.getElement();
        ArrayList<PsiNamedElementNodeDescriptor> result = new ArrayList<PsiNamedElementNodeDescriptor>();
        PsiClass servletClass = servlet.getPsiClass();
        if (servletClass != null && servletClass.isValid()) {
            result.add(new ServletClassNodeDescriptor(servletClass, (JavaeeNodeDescriptor)this, this.getParameters()));
        }
        if (servlet instanceof Servlet && (jspFile = WebUtil.getWebUtil().getJspFile((Servlet)servlet)) != null && jspFile.isValid()) {
            result.add(new FileNodeDescriptor((PsiFile)jspFile, (NodeDescriptor)this, this.getParameters()));
        }
        return result.toArray(new JavaeeNodeDescriptor[result.size()]);
    }

    protected final Navigatable getNavigatable() {
        VirtualFile file = this.getFile();
        return file == null ? null : new OpenFileDescriptor(this.myProject, file);
    }

    public int getWeight() {
        return 10;
    }

    public Object getData(String dataId) {
        return DataConstants.VIRTUAL_FILE.equals(dataId) ? this.getFile() : super.getData(dataId);
    }

    @Nullable
    private VirtualFile getFile() {
        CommonServlet servlet = (CommonServlet)this.getElement();
        if (servlet instanceof JamServlet) {
            return ((JamServlet)servlet).getPsiElement().getContainingFile().getVirtualFile();
        }
        return ServletAsVirtualFileImpl.findFile(servlet);
    }

    public Icon getNewIcon() {
        return AllIcons.Nodes.Servlet;
    }
}

