/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.module.view.nodes.DirectoryNodeDescriptor;
import com.intellij.javaee.module.view.nodes.FileNodeDescriptor;
import com.intellij.javaee.module.view.nodes.PsiNamedElementNodeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class WebFragmentDescriptor
extends SimpleNode {
    private final PsiDirectory myDirectory;
    private final Object myParameters;

    public WebFragmentDescriptor(PsiDirectory directory, VirtualFile jarFile, NodeDescriptor parent, Object parameters) {
        this(directory, parent, parameters);
        this.myName = jarFile.getName();
        this.setIcon(PlatformIcons.JAR_ICON);
    }

    public WebFragmentDescriptor(PsiDirectory directory, @NotNull Module module, NodeDescriptor parent, Object parameters) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/module/view/web/nodes/WebFragmentDescriptor", "<init>"));
        }
        this(directory, parent, parameters);
        this.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
        this.myName = module.getName();
    }

    private WebFragmentDescriptor(PsiDirectory directory, NodeDescriptor parent, Object parameters) {
        super(directory.getProject(), parent);
        this.myDirectory = directory;
        this.myParameters = parameters;
    }

    public SimpleNode[] getChildren() {
        PsiDirectory resources;
        ArrayList<PsiNamedElementNodeDescriptor> nodes = new ArrayList<PsiNamedElementNodeDescriptor>(2);
        PsiFile file = this.myDirectory.findFile("web-fragment.xml");
        if (file != null) {
            nodes.add(new FileNodeDescriptor(file, (NodeDescriptor)this, this.myParameters));
        }
        if ((resources = this.myDirectory.findSubdirectory("resources")) != null) {
            nodes.add(new DirectoryNodeDescriptor(resources, (NodeDescriptor)this, this.myParameters));
        }
        return nodes.toArray(new SimpleNode[nodes.size()]);
    }

    public int getWeight() {
        return Integer.MAX_VALUE;
    }
}

