/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeePersistentDataEditor<T extends JavaeePersistentData>
extends ApplicationServerPersistentDataEditor<T> {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaeePersistentDataEditor.class.getName()));
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton home;
    private JLabel error;
    private JPanel myCustomPanelPlaceHolder;
    private JComponent myVersionComponent;
    private String myServerVersion;
    private final JavaeeIntegration myIntegration;
    private VersionContribution myVersionContribution;

    public JavaeePersistentDataEditor(final JavaeeIntegration integration) {
        super(new Factory<T>(){

            public T create() {
                return (Object)((JavaeePersistentData)integration.getApplicationServerHelper().createPersistentDataEmptyInstance());
            }
        });
        this.myIntegration = integration;
        this.$$$setupUI$$$();
        String serverName = this.getServerName();
        for (Component component : this.myMainPanel.getComponents()) {
            if (!(component instanceof JLabel)) continue;
            JLabel label = (JLabel)component;
            label.setText(MessageFormat.format(label.getText(), serverName));
        }
        this.home.addBrowseFolderListener(JavaeeBundle.getText("PersistentDataEditor.chooser.title", serverName), JavaeeBundle.getText("PersistentDataEditor.chooser.description", serverName), null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.home.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent event) {
                JavaeePersistentDataEditor.this.homeChanged();
            }
        });
        this.error.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
        this.error.setText(JavaeeBundle.getText("PersistentDataEditor.warning", serverName));
    }

    private JavaeeIntegration getIntegration() {
        return this.myIntegration;
    }

    protected void resetEditorFrom(T settings) {
        this.home.setText(((JavaeePersistentData)((Object)settings)).HOME);
        this.homeChanged();
    }

    protected void applyEditorTo(T settings) {
        ((JavaeePersistentData)((Object)settings)).HOME = this.home.getText();
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/JavaeePersistentDataEditor", "createEditor"));
        }
        return jPanel;
    }

    protected String getServerName() {
        return this.getIntegration().getName();
    }

    private void homeChanged() {
        this.setVersion(this.getVersionContribution().detectVersion());
        this.onHomeChanged();
    }

    private void createUIComponents() {
        this.myVersionComponent = this.getVersionContribution().createVersionComponent();
    }

    protected JPanel getCustomPanelPlaceHolder() {
        return this.myCustomPanelPlaceHolder;
    }

    protected String getHome() {
        return this.home.getText();
    }

    protected void onHomeChanged() {
    }

    protected boolean isValidHomeSelected() {
        return this.myServerVersion != null;
    }

    protected String getVersion() {
        return this.myServerVersion;
    }

    protected void setVersion(String version) {
        this.myServerVersion = version;
        this.error.setVisible(version == null);
    }

    private VersionContribution getVersionContribution() {
        if (this.myVersionContribution == null) {
            this.myVersionContribution = this.createVersionContribution();
        }
        return this.myVersionContribution;
    }

    protected VersionContribution createVersionContribution() {
        return new SimpleVersionContribution();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.home = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, new Dimension(300, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("resources/javaee").getString("PersistentDataEditor.label.version"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("resources/javaee").getString("PersistentDataEditor.label.home"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.error = jLabel = new JLabel();
        jLabel.setText("---");
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myCustomPanelPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JComponent jComponent = this.myVersionComponent;
        jPanel2.add((Component)jComponent, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel3.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private class SimpleVersionContribution
    implements VersionContribution {
        private JLabel myVersionLabel;

        private SimpleVersionContribution() {
        }

        @Override
        public JComponent createVersionComponent() {
            return this.getVersionLabel();
        }

        @Override
        public String detectVersion() {
            JLabel versionLabel = this.getVersionLabel();
            try {
                String result = JavaeePersistentDataEditor.this.getIntegration().detectVersion((JavaeePersistentData)((Object)JavaeePersistentDataEditor.this.getSnapshot()));
                versionLabel.setText(result);
                return result;
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                versionLabel.setText(JavaeeBundle.getText("PersistentDataEditor.unknown", new Object[0]));
                return null;
            }
        }

        private JLabel getVersionLabel() {
            if (this.myVersionLabel == null) {
                this.myVersionLabel = new JLabel();
            }
            return this.myVersionLabel;
        }
    }

    protected static interface VersionContribution {
        public JComponent createVersionComponent();

        @Nullable
        public String detectVersion();
    }
}

