/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.javaee.oss.util.ConfigBase;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedConfig<D>
extends ConfigBase {
    private long stamp;

    @Nullable
    protected static <D, C extends CachedConfig<? super D>> C get(Map<Key, C> cache, Factory<D, C> factory, D data) {
        Key key = factory.createKey(data);
        if (key.isValid()) {
            CachedConfig<Object> config = (CachedConfig)cache.get(key);
            if (config == null) {
                config = factory.createConfig(data);
                cache.put(key, config);
            }
            config.check(data);
            return (C)config;
        }
        return null;
    }

    public static long getStamp(File file) {
        return file != null && file.exists() ? file.lastModified() ^ file.length() : 0L;
    }

    protected static long getStamp(String str) {
        return str != null ? (long)str.hashCode() : 0L;
    }

    protected abstract long getStamp(D var1);

    protected abstract void update(D var1);

    protected void check(D data) {
        if (this.stamp != this.getStamp(data)) {
            this.update(data);
            this.stamp = this.getStamp(data);
        }
    }

    protected static interface Factory<D, C extends CachedConfig<? super D>> {
        @NotNull
        public Key createKey(D var1);

        @NotNull
        public C createConfig(D var1);
    }

    protected static class Key {
        private final String[] parts;

        public Key(String ... parts) {
            if (parts == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parts", "com/intellij/javaee/oss/util/CachedConfig$Key", "<init>"));
            }
            this.parts = parts;
        }

        public boolean isValid() {
            for (String part : this.parts) {
                if (!StringUtil.isEmpty((String)part)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object other) {
            return other instanceof Key && Arrays.equals(this.parts, ((Key)other).parts);
        }

        public int hashCode() {
            return Arrays.hashCode(this.parts);
        }
    }
}

