/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution;

import com.intellij.compiler.server.BuildManager;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.J2EEProcessHandlerHelper;
import com.intellij.javaee.serverInstances.DefaultJ2EEServerEvent;
import com.intellij.javaee.serverInstances.DefaultServerInstance;
import com.intellij.javaee.serverInstances.J2EEServerEvent;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public abstract class LocalJavaeeServerProcessHandler
extends OSProcessHandler
implements J2EEProcess,
KillableProcess {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.run.execution.LocalJavaeeServerProcessHandler");
    protected final OSProcessHandler myStartupHandler;
    protected final J2EEProcessHandlerHelper myHelper;
    private boolean myIsInsideStartNotification = false;
    protected final boolean myStartupScriptTerminatesAfterServerStartup;

    public LocalJavaeeServerProcessHandler(J2EEProcessHandlerHelper helper, OSProcessHandler startupHandler, boolean startupScriptTerminatesAfterServerStartup) {
        super(startupHandler.getProcess(), startupHandler.getCommandLine(), EncodingManager.getInstance().getDefaultCharset());
        this.myStartupScriptTerminatesAfterServerStartup = startupScriptTerminatesAfterServerStartup;
        this.myHelper = helper;
        this.myStartupHandler = startupHandler;
        this.init();
    }

    private void init() {
        BuildManager.ALLOW_AUTOMAKE.set((UserDataHolder)this, (Object)Boolean.TRUE);
        ProcessAdapter baseProcessListener = new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                if (LocalJavaeeServerProcessHandler.this.myIsInsideStartNotification) {
                    return;
                }
                LocalJavaeeServerProcessHandler.super.startNotify();
                LocalJavaeeServerProcessHandler.this.myHelper.startNotify();
            }

            public void processTerminated(ProcessEvent event) {
                LocalJavaeeServerProcessHandler.this.myStartupHandler.removeProcessListener((ProcessListener)this);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LocalJavaeeServerProcessHandler.this.onBaseProcessTerminated();
                    }
                });
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (LocalJavaeeServerProcessHandler.this.myIsInsideStartNotification && ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                    return;
                }
                LocalJavaeeServerProcessHandler.this.notifyTextAvailable(event.getText(), outputType);
            }
        };
        this.myStartupHandler.addProcessListener((ProcessListener)baseProcessListener);
    }

    public boolean detachIsDefault() {
        return false;
    }

    public void destroyProcess() {
        this.detachProcess();
    }

    protected abstract void onBaseProcessTerminated();

    public abstract void shutdown();

    protected void onOSProcessTerminated(int exitCode) {
        if (this.myStartupScriptTerminatesAfterServerStartup) {
            return;
        }
        this.myHelper.onTerminated(exitCode);
        super.onOSProcessTerminated(exitCode);
    }

    @Override
    public void terminate() {
        this.myHelper.onTerminated(0);
        if (this.myStartupScriptTerminatesAfterServerStartup) {
            this.notifyProcessTerminated(0);
        }
    }

    @NotNull
    protected Reader createProcessOutReader() {
        StringReader stringReader = new StringReader("");
        if (stringReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/execution/LocalJavaeeServerProcessHandler", "createProcessOutReader"));
        }
        return stringReader;
    }

    @NotNull
    protected Reader createProcessErrReader() {
        StringReader stringReader = new StringReader("");
        if (stringReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/execution/LocalJavaeeServerProcessHandler", "createProcessErrReader"));
        }
        return stringReader;
    }

    public void terminateAndNotify() {
        this.myHelper.onTerminated(0);
        this.notifyProcessTerminated(0);
    }

    @Override
    public void started() {
        this.notifyTextAvailable(J2EEBundle.message((String)"message.text.connected.to.server", (Object[])new Object[0]) + "\n", ProcessOutputTypes.STDOUT);
    }

    @Override
    public CommonStrategy getCommonStrategy() {
        return this.myHelper.getStrategy();
    }

    @Override
    public void invokeTerminate() {
        this.myStartupHandler.destroyProcess();
    }

    public boolean canKillProcess() {
        return !this.myStartupScriptTerminatesAfterServerStartup && this.myStartupHandler != null && !this.myStartupHandler.isProcessTerminated();
    }

    public void killProcess() {
        this.killProcessTree(this.myStartupHandler.getProcess());
        J2EEServerInstance serverInstance = this.myHelper.getServerInstance();
        if (serverInstance instanceof DefaultServerInstance) {
            ((DefaultServerInstance)serverInstance).fireServerListeners((J2EEServerEvent)new DefaultJ2EEServerEvent(false, false, false, true));
        }
    }

    public void startNotify() {
        this.myIsInsideStartNotification = true;
        try {
            super.startNotify();
            this.myStartupHandler.startNotify();
            this.myHelper.startNotify();
        }
        finally {
            this.myIsInsideStartNotification = false;
        }
    }

    protected void destroyProcessImpl() {
        LOG.debug("shutting down server");
        boolean starting = this.myHelper.getServerInstance().isStarting();
        this.myHelper.destroy();
        if (this.myHelper.getServerInstance().getIntegration().isKillOnDestroyWhileStarting() && starting) {
            this.killProcess();
        } else {
            this.shutdown();
        }
    }

    protected void detachProcessImpl() {
        this.destroyProcessImpl();
    }

    @Override
    public J2EEServerInstance getServerInstance() {
        return this.myHelper.getServerInstance();
    }

    public Charset getCharset() {
        return this.myStartupHandler.getCharset();
    }
}

