/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.util;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.util.AnnotationManipulator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationTextUtil {
    @NonNls
    public static final String VALUE_PARAM = "value";
    public static Comparator<PsiAnnotation> ANNOTATION_COMPARATOR = new Comparator<PsiAnnotation>(){

        @Override
        public int compare(PsiAnnotation o1, PsiAnnotation o2) {
            int parametersFlag;
            String name;
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int namesFlag = o1.getQualifiedName().compareTo(o2.getQualifiedName());
            if (namesFlag != 0) {
                return namesFlag;
            }
            HashSet<String> checkedNames = new HashSet<String>();
            for (PsiNameValuePair pair : o1.getParameterList().getAttributes()) {
                name = pair.getName() != null ? pair.getName() : AnnotationTextUtil.VALUE_PARAM;
                parametersFlag = AnnotationTextUtil.compareMemberValues(pair.getValue(), o2.findAttributeValue(name));
                if (parametersFlag != 0) {
                    return parametersFlag;
                }
                checkedNames.add(name);
            }
            for (PsiNameValuePair pair : o2.getParameterList().getAttributes()) {
                String string = name = pair.getName() != null ? pair.getName() : AnnotationTextUtil.VALUE_PARAM;
                if (checkedNames.contains(name) || (parametersFlag = AnnotationTextUtil.compareMemberValues(o2.findAttributeValue(name), pair.getValue())) == 0) continue;
                return parametersFlag;
            }
            return 0;
        }
    };

    private AnnotationTextUtil() {
    }

    public static int compareMemberValues(PsiAnnotationMemberValue v1, PsiAnnotationMemberValue v2) {
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (v1 instanceof PsiAnnotation) {
            if (!(v2 instanceof PsiAnnotation)) {
                return -1;
            }
            return ANNOTATION_COMPARATOR.compare((PsiAnnotation)v1, (PsiAnnotation)v2);
        }
        if (v1 instanceof PsiExpression) {
            if (!(v2 instanceof PsiExpression)) {
                return -1;
            }
            Object o1 = JamCommonUtil.computeMemberValue((PsiElement)v1);
            Object o2 = JamCommonUtil.computeMemberValue((PsiElement)v2);
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
        if (v1 instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] a2;
            if (!(v2 instanceof PsiArrayInitializerMemberValue)) {
                return -1;
            }
            PsiAnnotationMemberValue[] a1 = ((PsiArrayInitializerMemberValue)v1).getInitializers();
            if (a1.length != (a2 = ((PsiArrayInitializerMemberValue)v2).getInitializers()).length) {
                return a1.length - a2.length < 0 ? -1 : 1;
            }
            for (int i = 0; i < a1.length; ++i) {
                int arrayItemFlag = AnnotationTextUtil.compareMemberValues(a1[i], a2[i]);
                if (arrayItemFlag == 0) continue;
                return arrayItemFlag;
            }
        }
        return v1.hashCode() - v2.hashCode() < 0 ? -1 : 1;
    }

    @Nullable
    public static String createAnnotationText(@NotNull PsiElement context, String annotationName, boolean merge, PsiAnnotation curAnnotation, String ... arguments) throws IncorrectOperationException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javaee/util/AnnotationTextUtil", "createAnnotationText"));
        }
        assert (arguments.length % 3 == 0) : "arguments length should be 3*x";
        PsiClass annotationClass = JavaPsiFacade.getInstance((Project)context.getProject()).findClass(annotationName, context.getResolveScope());
        HashMap<String, PsiAnnotationMethod> annoMethodsMap = new HashMap<String, PsiAnnotationMethod>();
        if (annotationClass != null && annotationClass.isAnnotationType()) {
            for (PsiMethod psiMethod : annotationClass.getMethods()) {
                if (!PsiUtil.isAnnotationMethod((PsiElement)psiMethod)) continue;
                annoMethodsMap.put(psiMethod.getName(), (PsiAnnotationMethod)psiMethod);
            }
        }
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)context.getManager().getProject());
        JavaCodeStyleManager javaStyle = JavaCodeStyleManager.getInstance((Project)context.getProject());
        PsiAnnotation curAnnotationCopy = curAnnotation == null ? null : (curAnnotation instanceof PsiCompiledElement ? curAnnotation : (PsiAnnotation)javaStyle.qualifyClassReferences(styleManager.reformat(curAnnotation.copy(), false)));
        LinkedHashMap<String, String> attributesDefs = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> attributesCur = new LinkedHashMap<String, String>();
        if (curAnnotationCopy != null) {
            for (PsiNameValuePair pair : curAnnotationCopy.getParameterList().getAttributes()) {
                String name = pair.getName();
                String value = pair.getValue().getText();
                name = name != null ? name : VALUE_PARAM;
                attributesCur.put(name, value);
            }
            if (merge) {
                attributes.putAll(attributesCur);
            }
        }
        for (int i = 0; i < arguments.length; i += 3) {
            PsiAnnotationMethod method;
            String value = arguments[i + 1];
            String name = arguments[i];
            if (value == null) continue;
            if (arguments[i + 2] != null) {
                attributesDefs.put(name, arguments[i + 2]);
            }
            boolean isArray = (method = (PsiAnnotationMethod)annoMethodsMap.get(name)) != null && method.getReturnType() instanceof PsiArrayType;
            String prevValue = attributes.put(name, value);
            String curValue = value;
            if (!merge || prevValue == null || !isArray || prevValue.indexOf(64) != -1 || value.indexOf(64) != -1) continue;
            String mergedValue = AnnotationTextUtil.mergeSimpleAttributeArrayInitializer(curAnnotationCopy, name, curValue, prevValue);
            attributes.put(name, mergedValue);
        }
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            PsiAnnotationMethod method = (PsiAnnotationMethod)annoMethodsMap.get(entry.getKey());
            if ((method == null || method.getDefaultValue() == null || !((String)entry.getValue()).equals(method.getDefaultValue().getText())) && !((String)entry.getValue()).equals(attributesDefs.get(entry.getKey()))) continue;
            it.remove();
        }
        if (curAnnotationCopy != null && attributes.equals(attributesCur)) {
            return null;
        }
        String text = AnnotationTextUtil.createAnnotationText(annotationName, attributes);
        PsiAnnotation psiAnnotation = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createAnnotationFromText(text, null);
        return styleManager.reformat((PsiElement)psiAnnotation).getText();
    }

    private static String mergeSimpleAttributeArrayInitializer(PsiAnnotation annotation, String name, String curValue, String prevValue) throws IncorrectOperationException {
        PsiAnnotation prevAnno;
        try {
            prevAnno = JavaPsiFacade.getInstance((Project)annotation.getProject()).getElementFactory().createAnnotationFromText("@" + annotation.getQualifiedName() + "(" + name + "=" + AnnotationTextUtil.ensureSurrounded(prevValue, "{", "}") + ")", null);
        }
        catch (IncorrectOperationException e) {
            return curValue;
        }
        PsiAnnotationMemberValue memberValue = prevAnno.findAttributeValue(name);
        if (!(memberValue instanceof PsiArrayInitializerMemberValue)) {
            return curValue;
        }
        PsiArrayInitializerMemberValue prevArray = (PsiArrayInitializerMemberValue)memberValue;
        PsiAnnotation curAnno = JavaPsiFacade.getInstance((Project)annotation.getProject()).getElementFactory().createAnnotationFromText("@" + annotation.getQualifiedName() + "(" + name + "=" + AnnotationTextUtil.ensureSurrounded(curValue, "{", "}") + ")", null);
        PsiArrayInitializerMemberValue curArray = (PsiArrayInitializerMemberValue)curAnno.findAttributeValue(name);
        assert (curArray != null);
        ArrayList<String> list = new ArrayList<String>();
        for (PsiAnnotationMemberValue psiValue : prevArray.getInitializers()) {
            list.add(psiValue.getText());
        }
        boolean changed = false;
        for (PsiAnnotationMemberValue psiValue : curArray.getInitializers()) {
            String text = psiValue.getText();
            if (list.contains(text)) continue;
            list.add(text);
            changed = true;
        }
        return !changed ? prevValue : AnnotationTextUtil.createStringArrayInitializer(list, new String[0]);
    }

    public static String createAnnotationText(String annotationName, Map<String, String> attributes) {
        StringBuilder sb = new StringBuilder("@").append(annotationName);
        if (attributes.size() > 0) {
            sb.append("(");
            if (attributes.size() == 1 && attributes.keySet().iterator().next().equals(VALUE_PARAM)) {
                sb.append(attributes.values().iterator().next());
            } else {
                boolean first = true;
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(entry.getKey()).append("=").append(entry.getValue());
                }
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public static <T> String createArrayInitializer(Collection<T> collection, Function<T, String> toString, String ... prefixPostfix) {
        String prefix = prefixPostfix.length > 0 ? prefixPostfix[0] : null;
        String postfix = prefixPostfix.length > 1 ? prefixPostfix[1] : prefix;
        boolean addBraces = collection.size() != 1;
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        if (addBraces) {
            sb.append("{");
        }
        for (T value : collection) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append((String)toString.fun(value));
            if (postfix == null) continue;
            sb.append(postfix);
        }
        if (addBraces) {
            sb.append("}");
        }
        return sb.toString();
    }

    public static String createStringArrayInitializer(Collection<String> collection, String ... prefixPostfix) {
        return AnnotationTextUtil.createArrayInitializer(collection, FunctionUtil.id(), prefixPostfix);
    }

    public static <T extends GenericValue<?>> String createGenericValueArrayInitializer(Collection<T> collection, String ... prefixPostfix) {
        return AnnotationTextUtil.createArrayInitializer(collection, new Function<T, String>(){

            public String fun(T s) {
                Object o = s.getValue();
                return o instanceof String ? (String)o : s.getStringValue();
            }
        }, prefixPostfix);
    }

    public static String quote(String s) {
        if (s != null) {
            return "\"" + StringUtil.escapeStringCharacters((String)s) + "\"";
        }
        return null;
    }

    public static String ensureSurrounded(String s, String prefix, String postfix) {
        return !s.startsWith(prefix) ? prefix + s + postfix : s;
    }

    public static <T> void createMultiAnnotation(Collection<String> annotationTexts, T owner, String singleAnnoName, String multiAnnoName, AnnotationManipulator<T> manipulator) throws IncorrectOperationException {
        PsiAnnotation annotation = manipulator.findAnnotation(owner, singleAnnoName);
        PsiAnnotation multiAnno = manipulator.findAnnotation(owner, multiAnnoName);
        if (annotationTexts.size() == 1 && annotation == null && multiAnno == null) {
            String text = annotationTexts.iterator().next();
            if (text != null) {
                manipulator.addAnnotation(owner, text, null);
            }
        } else if (annotationTexts.size() > 0 || multiAnno != null) {
            ArrayList<String> annoList = new ArrayList<String>();
            for (String text : annotationTexts) {
                annoList.add(text);
            }
            if (annotation != null) {
                Project project = manipulator.getElement(owner).getProject();
                JavaCodeStyleManager javaStyle = JavaCodeStyleManager.getInstance((Project)project);
                boolean alreadyThere = annoList.contains(javaStyle.qualifyClassReferences(annotation.copy()).getText());
                if (annoList.size() == 1 && alreadyThere) {
                    return;
                }
                if (!alreadyThere) {
                    annoList.add(0, annotation.getText());
                }
                manipulator.removeAnnotation(owner, annotation);
            }
            if (annoList.size() > 0) {
                String text;
                PsiAnnotation existingAnnotation = manipulator.findAnnotation(owner, multiAnnoName);
                text = AnnotationTextUtil.createAnnotationText(manipulator.getElement(owner), multiAnnoName, true, existingAnnotation, VALUE_PARAM, AnnotationTextUtil.createStringArrayInitializer(annoList, new String[0]), null);
                if (text != null) {
                    manipulator.addAnnotation(owner, text, existingAnnotation);
                }
            }
        }
    }
}

