/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetConfigurationBase;
import com.intellij.javaee.facet.JavaeeFacetEditorValidator;
import com.intellij.javaee.module.view.web.WebFacetEditor;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetImpl;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class WebFacetConfigurationImpl
extends JavaeeFacetConfigurationBase
implements WebFacetConfiguration {
    private List<WebRootData> myWebRoots = new ArrayList<WebRootData>();
    private List<String> mySourceRoots = new ArrayList<String>();

    public WebFacetConfigurationImpl(ConfigFileMetaDataProvider metaDataProvider) {
        super(metaDataProvider);
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext context, FacetValidatorsManager validatorsManager) {
        WebFacetImpl webFacet = (WebFacetImpl)context.getFacet();
        validatorsManager.registerValidator((FacetEditorValidator)new JavaeeFacetEditorValidator((JavaeeFacet)webFacet, context), new JComponent[0]);
        WebFacetEditor facetEditor = new WebFacetEditor(webFacet, context, validatorsManager);
        return new FacetEditorTab[]{facetEditor};
    }

    @Override
    @NotNull
    public List<WebRootData> getWebRoots() {
        List<WebRootData> list = Collections.unmodifiableList(this.myWebRoots);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/facet/WebFacetConfigurationImpl", "getWebRoots"));
        }
        return list;
    }

    public List<String> getSourceRoots() {
        return this.mySourceRoots;
    }

    public void setSourceRoots(List<String> sourceRoots) {
        this.mySourceRoots = new ArrayList<String>(sourceRoots);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        Element sourceRoots;
        Element webRootsElement = element.getChild("webroots");
        if (webRootsElement != null) {
            List roots = webRootsElement.getChildren("root");
            for (Element root : roots) {
                this.myWebRoots.add(new WebRootData(root));
            }
        }
        if ((sourceRoots = element.getChild("sourceRoots")) != null) {
            List list = sourceRoots.getChildren("root");
            for (Element rootElement : list) {
                this.mySourceRoots.add(rootElement.getAttributeValue("url"));
            }
        }
        super.readExternal(element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        Element roots = new Element("webroots");
        for (WebRootData webRoot : this.myWebRoots) {
            Element root = new Element("root");
            webRoot.writeExternal(root);
            roots.addContent(root);
        }
        element.addContent(roots);
        Element sourceRoots = new Element("sourceRoots");
        for (String sourceRoot : this.mySourceRoots) {
            sourceRoots.addContent(new Element("root").setAttribute("url", sourceRoot));
        }
        element.addContent(sourceRoots);
    }

    public void setWebRoots(@NotNull List<WebRootData> webRoots) {
        if (webRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webRoots", "com/intellij/javaee/web/facet/WebFacetConfigurationImpl", "setWebRoots"));
        }
        this.myWebRoots = new ArrayList<WebRootData>(webRoots);
    }

    public void addWebRoot(@NotNull WebRootData root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/javaee/web/facet/WebFacetConfigurationImpl", "addWebRoot"));
        }
        this.myWebRoots.add(root);
    }

    public void removeWebRoot(WebRootData webRootData) {
        this.myWebRoots.remove(webRootData);
    }
}

